/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.relational;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public class DRTLCNamingStandard
extends DesignRule {
    private final String RULE_ID = "B7742349-1469-D1DC-BB3C-F79B1A0FB994";
    private NamingStandardRule namingRule;
    private String tableName = "";
    private String tableAbbr = "";
    private String modelName = "";

    public DRTLCNamingStandard() {
        this.setName(Messages.getString("DRTLCNamingStandard.IdentifyCheckConstraintsWithWrongNamingStandards"));
        this.setDescription(Messages.getString("DRTLCNamingStandard.CheckConstraintsWithWrongNamingStandardsNotRecommended"));
    }

    private int getPosition(TableLevelConstraint tableLevelConstraint) {
        Object[] objectArray = tableLevelConstraint.getTable().getCheckConstraints().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!tableLevelConstraint.equals(object)) continue;
            return i + 1;
        }
        return 0;
    }

    @Override
    public CheckResult doCheck(Object object) {
        TableLevelConstraint tableLevelConstraint = (TableLevelConstraint)object;
        this.namingRule = tableLevelConstraint.getTable().getDesign().getDLSettings().getNamingStandardRule();
        String string = this.namingRule.getCkConstr();
        this.tableName = tableLevelConstraint.getTable().getName();
        this.tableName = this.tableName.replaceAll("\\$", "\\\\\\$");
        int n = this.getPosition(tableLevelConstraint);
        string = string.replaceAll("\\{table\\}", this.tableName);
        string = string.replaceAll("\\{seq nr\\}", String.valueOf(n));
        this.tableAbbr = tableLevelConstraint.getTable().getAbbreviation();
        this.tableAbbr = this.tableAbbr.replaceAll("\\$", "\\\\\\$");
        string = string.replaceAll("\\{table abbr\\}", this.tableAbbr);
        this.modelName = tableLevelConstraint.getDesignPart().getName();
        this.modelName = this.modelName.replaceAll("\\$", "\\\\\\$");
        string = string.replaceAll("\\{model\\}", this.modelName);
        if (tableLevelConstraint.getName().equalsIgnoreCase(string)) {
            return CheckResult.createOk(tableLevelConstraint.getTable(), this, Messages.getString("DRTLCNamingStandard.CheckConstraintNameIsInValidFormat"));
        }
        return CheckResult.createWarning(tableLevelConstraint.getTable(), this, this.getDescription());
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "B7742349-1469-D1DC-BB3C-F79B1A0FB994";
    }
}

