/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.relational;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public class DRPrimaryKeyNamingStandard
extends DesignRule {
    private final String RULE_ID = "579BA374-4A07-4FC1-DDE9-F01D46886788";
    private NamingStandardRule namingRule;
    private String tableName = "";
    private String tableAbbr = "";
    private String modelName = "";

    public DRPrimaryKeyNamingStandard() {
        this.setName(Messages.getString("DRPrimaryKeyNamingStandard.IdentifyPKWithWrongNamingStandards"));
        this.setDescription(Messages.getString("DRPrimaryKeyNamingStandard.PKWithWrongNamingStandardsNotRecommended"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        Index index = (Index)object;
        if (index.isPK()) {
            Table table = index.getTable();
            this.namingRule = table.getDesign().getDLSettings().getNamingStandardRule();
            String string = this.namingRule.getPkConstr();
            this.tableName = table.getName();
            this.tableName = this.tableName.replaceAll("\\$", "\\\\\\$");
            string = string.replaceAll("\\{table\\}", this.tableName);
            this.tableAbbr = table.getAbbreviation();
            this.tableAbbr = this.tableAbbr.replaceAll("\\$", "\\\\\\$");
            string = string.replaceAll("\\{table abbr\\}", this.tableAbbr);
            this.modelName = table.getDesignPart().getName();
            this.modelName = this.modelName.replaceAll("\\$", "\\\\\\$");
            string = string.replaceAll("\\{model\\}", this.modelName);
            if (index.getElements().length > 0) {
                String string2 = table.getPK().getElement(0).getName();
                string2 = string2.replaceAll("\\$", "\\\\\\$");
                string = string.replaceAll("\\{column\\}", string2);
                String string3 = ((Column)table.getPK().getElement(0)).getAbbreviation();
                string3 = string3.replaceAll("\\$", "\\\\\\$");
                string = string.replaceAll("\\{column abbr\\}", string2);
            }
            if (index.getName().equalsIgnoreCase(string)) {
                return CheckResult.createOk(index, this, Messages.getString("DRPrimaryKeyNamingStandard.PKNameIsInValidFormat"));
            }
            return CheckResult.createWarning(index, this, this.getDescription());
        }
        return CheckResult.createOk(index, this, Messages.getString("DRPrimaryKeyNamingStandard.PKNameIsInValidFormat"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "579BA374-4A07-4FC1-DDE9-F01D46886788";
    }
}

