/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.relational;

import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DRObjectMaxNameLength;
import oracle.dbtools.crest.model.designrules.relational.DRForeignKeyMaxNameLength;
import oracle.dbtools.crest.model.designrules.relational.DRPlainIndexMaxNameLength;
import oracle.dbtools.crest.model.designrules.relational.DRPrimaryKeyMaxNameLength;
import oracle.dbtools.crest.model.designrules.relational.DRUniqueKeyMaxNameLength;

public class DRIndexMaxNameLength
extends DRObjectMaxNameLength {
    private final String RULE_ID = "380368AD-4DFA-5018-09F7-759B491724AE";

    public DRIndexMaxNameLength() {
        this("DRIndexMaxNameLength.CheckForIndexMaximumNameLength", "DRIndexMaxNameLength.IndexNameHasTooManyCharacters", "DRIndexMaxNameLength.TheLengthOfTheNameIsOK", "DRIndexMaxNameLength.NoNameSpecified", "DRIndexMaxNameLength.NameHasMoreThan");
    }

    public DRIndexMaxNameLength(String string, String string2) {
        this(string, string2, "DRIndexMaxNameLength.TheLengthOfTheNameIsOK", "DRIndexMaxNameLength.NoNameSpecified", "DRIndexMaxNameLength.NameHasMoreThan");
    }

    public DRIndexMaxNameLength(String string, String string2, String string3, String string4, String string5) {
        super(string, string2, string3, string4, string5);
    }

    @Override
    public CheckResult doCheck(Object object) {
        Index index = (Index)object;
        if (index.isPK()) {
            return new DRPrimaryKeyMaxNameLength().doCheck(object);
        }
        if (index.isUnique()) {
            return new DRUniqueKeyMaxNameLength().doCheck(object);
        }
        if (index.isFK()) {
            return new DRForeignKeyMaxNameLength().doCheck(object);
        }
        return new DRPlainIndexMaxNameLength().doCheck(object);
    }

    @Override
    public String getRuleId() {
        return "380368AD-4DFA-5018-09F7-759B491724AE";
    }
}

