/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.relational;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public class DRColumnCheckConstraintNamingStandard
extends DesignRule {
    private final String RULE_ID = "B5375FED-9CAE-FB43-76AC-2689979D50B6";
    private NamingStandardRule namingRule;

    public DRColumnCheckConstraintNamingStandard() {
        this.setName(Messages.getString("DRColumnCheckConstraintNamingStandard.IdentifyColumnCheckConstraintsWithWrongNamingStandards"));
        this.setDescription(Messages.getString("DRColumnCheckConstraintNamingStandard.ColumnCheckConstraintsWithWrongNamingStandardsAreNotRecommended"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        Column column = (Column)object;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        this.namingRule = column.getDesign().getDLSettings().getNamingStandardRule();
        String string5 = this.namingRule.getColckConstr();
        if (column.getCheck() != null) {
            string = column.getContainer().getName();
            string = string.replaceAll("\\$", "\\\\\\$");
            string5 = string5.replaceAll("\\{table\\}", string);
            string3 = column.getAbbreviation();
            string3 = string3.replaceAll("\\$", "\\\\\\$");
            string5 = string5.replaceAll("\\{table abbr\\}", string3);
            string2 = column.getName();
            string2 = string2.replaceAll("\\$", "\\\\\\$");
            string5 = string5.replaceAll("\\{column\\}", string2);
            String string6 = column.getAbbreviation();
            string6 = string6.replaceAll("\\$", "\\\\\\$");
            string5 = string5.replaceAll("\\{column abbr\\}", string2);
            string4 = column.getDesignPart().getName();
            string4 = string4.replaceAll("\\$", "\\\\\\$");
            string5 = string5.replaceAll("\\{model\\}", string4);
            if (column.getConstraintName().equalsIgnoreCase(string5)) {
                return CheckResult.createOk(string2, this, Messages.getString("DRColumnCheckConstraintNamingStandard.ColumnCheckConstraintNameIsInValidFormat"));
            }
            return CheckResult.createWarning(column, this, this.getDescription());
        }
        return CheckResult.createOk(column, this, Messages.getString("DRColumnCheckConstraintNamingStandard.ColumnCheckConstraintNameIsInValidFormat"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "B5375FED-9CAE-FB43-76AC-2689979D50B6";
    }
}

