/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.process;

import java.text.MessageFormat;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.swingui.process.AbstractDataFlowTV;

public class DRStoreWithoutFlows
extends DesignRule {
    private final String RULE_ID = "209B69A0-BD07-560B-9072-9B53D0395434";

    public DRStoreWithoutFlows() {
        this.setName(Messages.getString("DRStoreWithoutFlows.IdentifyInformationStoresWithoutFlowsConnectedTothem"));
        this.setDescription(Messages.getString("DRStoreWithoutFlows.StoreShouldHaveIncomingAndOutgoingFlows"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        InfoStore infoStore = (InfoStore)object;
        if (infoStore.getNumberOfFlows() == 0) {
            return CheckResult.createWarning(object, this, Messages.getString("DRStoreWithoutFlows.StoreDoesntHaveFlowsConnectedToIt"));
        }
        List list = infoStore.getAllViews();
        for (AbstractDataFlowTV abstractDataFlowTV : list) {
            if (abstractDataFlowTV.isConnected()) continue;
            return CheckResult.createWarning(object, this, MessageFormat.format(Messages.getString("DRStoreWithoutFlows.StoreDoesntHaveFlowsConnectedToItIn"), abstractDataFlowTV.getDesignPartView().getDesignPart().getName()));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRStoreWithoutFlows.StoreHasFlowsConnectedToIt"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "209B69A0-BD07-560B-9072-9B53D0395434";
    }
}

