/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.process;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;

public class DRProcessWithWrongInsert
extends DesignRule {
    private final String RULE_ID = "B47CCEFD-8820-AE36-091C-796C3FFE283A";

    public DRProcessWithWrongInsert() {
        this.setName(Messages.getString("DRProcessWithWrongInsert.IdentifyPrimitiveProcessesThatViolateNotNullConstraints"));
        this.setDescription(Messages.getString("DRProcessWithWrongInsert.AllNotNullAttributesShouldBeIncludedIntoInsertOperation"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        Process process = (Process)object;
        List list = process.getProcessedEntities(true);
        if (!process.isComposite() && list.size() > 0) {
            ArrayList<DesignObject> arrayList = new ArrayList<DesignObject>();
            for (Object object2 : process.getProcessedAttributes(true)) {
                if (((Process.ProcessedObject)object2).getObject() == null) continue;
                arrayList.add(((Process.ProcessedObject)object2).getObject());
            }
            for (Process.ProcessedObject processedObject : list) {
                if (!processedObject.isOpCreate()) continue;
                Entity entity = (Entity)processedObject.getObject();
                ContainedObject[] containedObjectArray = entity.getElements();
                for (int i = 0; i < containedObjectArray.length; ++i) {
                    if (containedObjectArray[i].getNullsAllowed() || arrayList.indexOf(containedObjectArray[i]) >= 0) continue;
                    return CheckResult.createFailed(object, this, MessageFormat.format(Messages.getString("DRProcessWithWrongInsert.ProcessViolateNotNullConstraintFor"), containedObjectArray[i].getName(), entity.getName()));
                }
            }
        }
        return CheckResult.createOk(object, this, Messages.getString("DRProcessWithWrongInsert.ProcessDoNotViolateNotNullConstraint"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "B47CCEFD-8820-AE36-091C-796C3FFE283A";
    }
}

