/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.logical;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;

public class DRKeyNullsAllowed
extends DesignRule {
    private final String RULE_ID = "F925ECDE-98B3-786C-ED03-C2D3C7C364F9";

    public DRKeyNullsAllowed() {
        this.setName(Messages.getString("DRKeyNullsAllowed.IdentifyNotNullsAllowedForPK"));
        this.setDescription(Messages.getString("DRKeyNullsAllowed.PKMustContainNotNullsAllowedAttributes"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        KeyObject keyObject = (KeyObject)object;
        boolean bl = false;
        boolean bl2 = false;
        if (keyObject.isPK()) {
            Attribute[] attributeArray = (Attribute[])keyObject.getElements();
            for (int i = 0; i < attributeArray.length; ++i) {
                if (attributeArray[i].getNullsAllowed()) {
                    bl = true;
                } else {
                    bl2 = true;
                }
                if (!bl2 || !bl) continue;
                return CheckResult.createWarning(object, this, Messages.getString("DRKeyNullsAllowed.NotAllRDBMSAllowNullsAllowedClumnsInPK"));
            }
            if (!bl2) {
                return CheckResult.createFailed(object, this, Messages.getString("DRKeyNullsAllowed.PKDoesNotContainNotNullsAllowedAttributes"));
            }
            if (!bl) {
                return CheckResult.createOk(object, this, Messages.getString("DRKeyNullsAllowed.PKContainsNotNullsAllowedAttributes"));
            }
        }
        return CheckResult.createOk(object, this, Messages.getString("DRKeyNullsAllowed.KeyNotPKMustNotContainNotNullsAllowedAttributes"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "F925ECDE-98B3-786C-ED03-C2D3C7C364F9";
    }
}

