/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.logical;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;

public class DRAttributeNoDatatype
extends DesignRule {
    private final String RULE_ID = "57128D30-B9BC-3824-E2BC-A685CAF0C728";

    public DRAttributeNoDatatype() {
        this.setName(Messages.getString("DRAttributeNoDatatype.IdentifyAttributesWithoutDatatype"));
        this.setDescription(Messages.getString("DRAttributeNoDatatype.AttributesWithoutDatatypeNotAllowed"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        try {
            Attribute attribute = (Attribute)object;
            Datatype datatype = attribute.getDataType();
            if (datatype != null && !datatype.getName().equalsIgnoreCase("unknown")) {
                return CheckResult.createOk(object, this, Messages.getString("DRAttributeNoDatatype.AttributeHasDatatype"));
            }
            return CheckResult.createFailed(object, this, this.getDescription());
        }
        catch (Exception exception) {
            return CheckResult.createFailed(object, this, this.getDescription());
        }
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "57128D30-B9BC-3824-E2BC-A685CAF0C728";
    }
}

