/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.logical;

import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.util.options.namingstandards.NamingConstants;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public class DRAttributeNamingStandard
extends DesignRule
implements NamingConstants {
    private final String RULE_ID = "B1CCFFED-E720-B693-A9B6-109545989F45";
    private NamingStandardRule namingRule;

    public DRAttributeNamingStandard() {
        this.setName(Messages.getString("DRAttributeNamingStandard.IdentifyAttributesWithWrongNamingStandards"));
        this.setDescription(Messages.getString("DRAttributeNamingStandard.AttributesWithWrongNamingStandardsNotRecommended"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        Attribute attribute = (Attribute)object;
        this.namingRule = attribute.getDesign().getDLSettings().getNamingStandardRule();
        Iterator iterator = this.namingRule.getGlossaries().iterator();
        String string = "";
        char c = this.namingRule.getLogicalSeparatorChar();
        boolean bl = "Title Case".equalsIgnoreCase(this.namingRule.getLogicalSep());
        while (iterator.hasNext()) {
            Glossary glossary = (Glossary)iterator.next();
            String string2 = glossary.checkValidName(attribute.getName(), this.namingRule.getAttributesList(), c, bl, false, false, false);
            if (string2 == null) {
                return CheckResult.createOk(attribute, this, Messages.getString("DRAttributeNamingStandard.AttributeNameIsInValidFormat"));
            }
            if (string.length() == 0) {
                string = string2;
                continue;
            }
            string = string + ". " + string2;
        }
        if ("".equals(string)) {
            return CheckResult.createOk(attribute, this, Messages.getString("DRAttributeNamingStandard.AttributeNameIsInValidFormat"));
        }
        return CheckResult.createWarning(attribute, this, string);
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "B1CCFFED-E720-B693-A9B6-109545989F45";
    }
}

