/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.domains;

import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.util.options.namingstandards.NamingConstants;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public class DRDomainNamingStandard
extends DesignRule
implements NamingConstants {
    private final String RULE_ID = "11C997DB-7967-6159-2D54-B7ACB29F4585";
    private NamingStandardRule namingRule;

    public DRDomainNamingStandard() {
        this.setName(Messages.getString("DRDomainNamingStandard.IdentifyDomainsWithWrongNamingStandards"));
        this.setDescription(Messages.getString("DRDomainNamingStandard.WrongNamingAtandardsNotRecommended"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        Domain domain = (Domain)object;
        this.namingRule = domain.getDesign().getDLSettings().getNamingStandardRule();
        Iterator iterator = this.namingRule.getGlossaries().iterator();
        String string = "";
        char c = this.namingRule.getLogicalSeparatorChar();
        boolean bl = "Title Case".equalsIgnoreCase(this.namingRule.getLogicalSep());
        while (iterator.hasNext()) {
            Glossary glossary = (Glossary)iterator.next();
            String string2 = glossary.checkValidName(domain.getName(), this.namingRule.getDomainsList(), c, bl, false, false, false);
            if (string2 == null) {
                return CheckResult.createOk(domain, this, Messages.getString("DRDomainNamingStandard.DomainNameIsInValidFormat"));
            }
            if (string.length() == 0) {
                string = string2;
                continue;
            }
            string = string + ". " + string2;
        }
        return CheckResult.createOk(domain, this, Messages.getString("DRDomainNamingStandard.DomainNameIsInValidFormat"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "11C997DB-7967-6159-2D54-B7ACB29F4585";
    }
}

