/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.model.designrules.DesignRuleSubjectSet;
import oracle.dbtools.crest.model.designrules.RuleNode;

public abstract class RuleHandler
implements RuleNode {
    public static final DesignRuleSubjectSet EMPTY_DESIGNRULE_SUBJECT_SET = new EmptyDesignRuleSubjectSet();
    public static final String GENERAL_PATH = "General";
    public static final String LOGICAL_PATH = "Logical";
    public static final String RELATIONAL_PATH = "Relational";
    public static final String PROCESSMODEL_PATH = "Process Model";
    public static final String PHYSICAL_PATH = "Physical";
    private static RuleHandler nullInstance;
    private RuleHandler successor;
    private List rules = new LinkedList();
    private String label = "Rules";
    private DesignRuleSubjectSet ruleSubjectSet = EMPTY_DESIGNRULE_SUBJECT_SET;
    public boolean hasEvalErr = false;

    public void append(RuleHandler ruleHandler) {
        if (this.successor == null) {
            this.successor = ruleHandler;
        } else {
            this.successor.append(ruleHandler);
        }
    }

    protected void doHandle(Object object, Collection collection) {
        for (DesignRule designRule : this.getRules()) {
            designRule.collectCheckResults(collection, object);
        }
    }

    protected void doHandleRule(Object object, Collection collection, DesignRule designRule) {
        designRule.collectCheckResults(collection, object);
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getLabel() {
        return this.label;
    }

    protected abstract boolean canHandle(Object var1);

    public void handle(Object object, Collection collection) {
        if (this.canHandle(object)) {
            this.doHandle(object, collection);
        } else if (this.successor != null) {
            this.successor.handle(object, collection);
        }
    }

    public void addRule(DesignRule designRule) {
        designRule.setRuleHandler(this);
        this.rules.add(designRule);
    }

    public void removeRule(DesignRule designRule) {
        this.rules.remove(designRule);
    }

    public List getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    public int getIndexInList(int n) {
        ++n;
        if (this.successor == null) {
            return n;
        }
        return this.successor.getIndexInList(n);
    }

    public RuleHandler getNthInList(int n) {
        if (--n == -1) {
            return this;
        }
        if (this.successor == null) {
            throw new IndexOutOfBoundsException("RuleHandler linked list");
        }
        return this.successor.getNthInList(n);
    }

    public int getIndexInListFor(RuleHandler ruleHandler, int n) {
        ++n;
        if (this.equals(ruleHandler)) {
            return n;
        }
        if (this.successor == null) {
            return -1;
        }
        return this.successor.getIndexInListFor(ruleHandler, n);
    }

    @Override
    public int size() {
        return this.rules.size();
    }

    @Override
    public Object getElement(int n) {
        return this.rules.get(n);
    }

    @Override
    public int getIndexFor(Object object) {
        return this.rules.indexOf(object);
    }

    public static RuleHandler getNullInstance() {
        if (nullInstance == null) {
            nullInstance = new RuleHandler(){

                @Override
                protected boolean canHandle(Object object) {
                    return false;
                }
            };
        }
        return nullInstance;
    }

    public void setRuleSubjectSet(DesignObjectSet designObjectSet) {
        if (designObjectSet != null) {
            this.setRuleSubjectSet(new DesignObjectSetWrapper(designObjectSet));
        } else {
            this.ruleSubjectSet = EMPTY_DESIGNRULE_SUBJECT_SET;
        }
    }

    public void setRuleSubjectSet(ModelObjectSet modelObjectSet) {
        if (modelObjectSet != null) {
            this.setRuleSubjectSet(new ModelObjectSetWrapper(modelObjectSet));
        } else {
            this.ruleSubjectSet = EMPTY_DESIGNRULE_SUBJECT_SET;
        }
    }

    public void setRuleSubjectSet(RelationalObjectProxySet relationalObjectProxySet) {
        if (relationalObjectProxySet != null) {
            this.setRuleSubjectSet(new PhysicalObjectProxySetWrapper(relationalObjectProxySet));
        }
    }

    public void setRuleSubjectSet(List list) {
        if (list != null) {
            this.setRuleSubjectSet(new ListWrapper(list));
        } else {
            this.ruleSubjectSet = EMPTY_DESIGNRULE_SUBJECT_SET;
        }
    }

    public void setRuleSubjectSet(DesignRuleSubjectSet designRuleSubjectSet) {
        this.ruleSubjectSet = designRuleSubjectSet == null ? EMPTY_DESIGNRULE_SUBJECT_SET : designRuleSubjectSet;
    }

    public Collection applyRulesToSubject() {
        ArrayList arrayList = new ArrayList();
        return this.applyRulesToSubject(arrayList);
    }

    public Collection applyRulesToSubject(Collection collection) {
        Iterator iterator = this.ruleSubjectSet.getDesignRuleSubjects();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (this.hasEvalErr) break;
            if (!this.canHandle(e)) continue;
            this.doHandle(e, collection);
        }
        return collection;
    }

    public Collection applyRule(Collection collection, DesignRule designRule) {
        designRule.init();
        Iterator iterator = this.ruleSubjectSet.getDesignRuleSubjects();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (this.hasEvalErr) break;
            if (!this.canHandle(e)) continue;
            this.doHandleRule(e, collection, designRule);
        }
        return collection;
    }

    private static class ListWrapper
    implements DesignRuleSubjectSet {
        private List list;

        private ListWrapper(List list) {
            this.list = list;
        }

        @Override
        public Iterator getDesignRuleSubjects() {
            return this.list.iterator();
        }
    }

    private static class DesignObjectSetWrapper
    implements DesignRuleSubjectSet {
        private DesignObjectSet set;

        private DesignObjectSetWrapper(DesignObjectSet designObjectSet) {
            this.set = designObjectSet;
        }

        @Override
        public Iterator getDesignRuleSubjects() {
            return this.set.iterator();
        }
    }

    private static class ModelObjectSetWrapper
    implements DesignRuleSubjectSet {
        private ModelObjectSet set;

        private ModelObjectSetWrapper(ModelObjectSet modelObjectSet) {
            this.set = modelObjectSet;
        }

        @Override
        public Iterator getDesignRuleSubjects() {
            return this.set.iterator();
        }
    }

    private static class PhysicalObjectProxySetWrapper
    implements DesignRuleSubjectSet {
        private RelationalObjectProxySet set;

        private PhysicalObjectProxySetWrapper(RelationalObjectProxySet relationalObjectProxySet) {
            this.set = relationalObjectProxySet;
        }

        @Override
        public Iterator getDesignRuleSubjects() {
            return Collections.unmodifiableCollection(this.set.getObjectCollection()).iterator();
        }
    }

    static class EmptyDesignRuleSubjectSet
    implements DesignRuleSubjectSet {
        EmptyDesignRuleSubjectSet() {
        }

        @Override
        public Iterator getDesignRuleSubjects() {
            return Collections.EMPTY_LIST.iterator();
        }
    }
}

