/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.CompositeRuleHandler;
import oracle.dbtools.crest.model.designrules.DRCustomScript;
import oracle.dbtools.crest.model.designrules.DRCustomValidationScript;
import oracle.dbtools.crest.model.designrules.RuleHandler;
import oracle.dbtools.crest.model.designrules.RuleNode;
import oracle.dbtools.crest.model.designrules.domains.RHDomain;
import oracle.dbtools.crest.model.designrules.logical.RHAttribute;
import oracle.dbtools.crest.model.designrules.logical.RHEntity;
import oracle.dbtools.crest.model.designrules.logical.RHEntityView;
import oracle.dbtools.crest.model.designrules.logical.RHKey;
import oracle.dbtools.crest.model.designrules.process.RHAgent;
import oracle.dbtools.crest.model.designrules.process.RHFlow;
import oracle.dbtools.crest.model.designrules.process.RHProcess;
import oracle.dbtools.crest.model.designrules.process.RHStore;
import oracle.dbtools.crest.model.designrules.process.RHTransformation;
import oracle.dbtools.crest.model.designrules.process.RHTransformationTask;
import oracle.dbtools.crest.model.designrules.relational.RHColumn;
import oracle.dbtools.crest.model.designrules.relational.RHIndex;
import oracle.dbtools.crest.model.designrules.relational.RHTable;
import oracle.dbtools.crest.model.designrules.relational.RHTableLevelConstraint;
import oracle.dbtools.crest.model.designrules.relational.RHView;
import oracle.dbtools.crest.model.propertyholder.functionality.UpdateListener;
import oracle.dbtools.crest.model.propertyholder.functionality.UpdateSubject;
import oracle.dbtools.crest.model.propertyholder.functionality.UpdateSubjectImpl;
import oracle.dbtools.crest.swingui.ApplicationView;

public class DesignRuleManager
implements RuleNode,
UpdateSubject {
    public static final int FILTER_ALL = 0;
    public static final int FILTER_FAIL_WARN = 1;
    public static final int FILTER_FAIL = 2;
    private int filtering = 0;
    private UpdateSubjectImpl delegate = new UpdateSubjectImpl();
    private RuleHandler firstHandler = null;
    private Design design;
    private RuleHandler logicalRH = null;
    private RuleHandler relationalRH = null;
    private RuleHandler generalRH = null;
    private CompositeRuleHandler physicalRH = null;
    private RuleHandler processModelRH = null;
    private RelationalDesign relDesign;
    private DataFlowDesign dataFlowDesign;
    private RHTable tableRH;
    private RHColumn columnRH;
    private RHIndex indexRH;
    private RHView viewRH;
    private RHTableLevelConstraint constrRH;
    private RHProcess processRH;
    private RHAgent agentRH;
    private RHStore storeRH;
    private RHFlow flowRH;
    private RHTransformation transformationRH;
    private RHTransformationTask trTaskRH;
    private TreeMap<String, Object> objects = new TreeMap();
    private ArrayList<DRCustomScript> tempListCustomDR = new ArrayList();
    private ApplicationView appView;
    public boolean res;

    public DesignRuleManager(Design design, RelationalDesign relationalDesign, ApplicationView applicationView) {
        this.appView = applicationView;
        this.design = design;
        this.relDesign = relationalDesign;
        this.initChain();
    }

    public Design getDesign() {
        return this.design;
    }

    protected void initChain() {
        CompositeRuleHandler compositeRuleHandler;
        CompositeRuleHandler compositeRuleHandler2 = new CompositeRuleHandler();
        compositeRuleHandler2.setLabel("General");
        RHDomain rHDomain = new RHDomain();
        rHDomain.setRuleSubjectSet(this.getDesign().getDomainSet());
        compositeRuleHandler2.add(rHDomain);
        this.addRuleHandler(compositeRuleHandler2);
        this.generalRH = compositeRuleHandler2;
        CompositeRuleHandler compositeRuleHandler3 = new CompositeRuleHandler();
        compositeRuleHandler3.setLabel("Logical");
        RHEntity rHEntity = new RHEntity();
        rHEntity.setRuleSubjectSet(this.getDesign().getLogicalDesign().getEntitySet());
        compositeRuleHandler3.add(rHEntity);
        RHAttribute rHAttribute = new RHAttribute();
        rHAttribute.setRuleSubjectSet(this.getDesign().getLogicalDesign().getAttributeSet());
        compositeRuleHandler3.add(rHAttribute);
        RHKey rHKey = new RHKey();
        rHKey.setRuleSubjectSet(this.getDesign().getLogicalDesign().getGlobalCandidateKeySet());
        compositeRuleHandler3.add(rHKey);
        RHEntityView rHEntityView = new RHEntityView();
        rHEntityView.setRuleSubjectSet(this.getDesign().getLogicalDesign().getEntityViewSet());
        compositeRuleHandler3.add(rHEntityView);
        this.logicalRH = compositeRuleHandler3;
        this.addRuleHandler(compositeRuleHandler3);
        if (this.relDesign != null) {
            compositeRuleHandler = new CompositeRuleHandler();
            compositeRuleHandler.setLabel("Relational");
            this.tableRH = new RHTable();
            this.tableRH.setRuleSubjectSet(this.getTableSet());
            compositeRuleHandler.add(this.tableRH);
            this.columnRH = new RHColumn();
            this.columnRH.setRuleSubjectSet(this.getColumnSet());
            compositeRuleHandler.add(this.columnRH);
            this.indexRH = new RHIndex();
            this.indexRH.setRuleSubjectSet(this.getGlobalIndexSet());
            compositeRuleHandler.add(this.indexRH);
            this.constrRH = new RHTableLevelConstraint();
            this.constrRH.setRuleSubjectSet(this.getConstraintSet());
            compositeRuleHandler.add(this.constrRH);
            this.viewRH = new RHView();
            this.viewRH.setRuleSubjectSet(this.getTableViewSet());
            compositeRuleHandler.add(this.viewRH);
            this.relationalRH = compositeRuleHandler;
            this.addRuleHandler(compositeRuleHandler);
        }
        compositeRuleHandler = new CompositeRuleHandler();
        compositeRuleHandler.setLabel("Process Model");
        this.processRH = new RHProcess();
        this.processRH.setRuleSubjectSet(this.getAllProcesses());
        compositeRuleHandler.add(this.processRH);
        this.flowRH = new RHFlow();
        this.flowRH.setRuleSubjectSet(this.getAllFlows());
        compositeRuleHandler.add(this.flowRH);
        this.storeRH = new RHStore();
        this.storeRH.setRuleSubjectSet(this.getAllStores());
        compositeRuleHandler.add(this.storeRH);
        this.agentRH = new RHAgent();
        this.agentRH.setRuleSubjectSet(this.getAllAgents());
        compositeRuleHandler.add(this.agentRH);
        this.transformationRH = new RHTransformation();
        this.transformationRH.setRuleSubjectSet(this.getDesign().getProcessModel().getTransformations());
        compositeRuleHandler.add(this.transformationRH);
        this.trTaskRH = new RHTransformationTask();
        this.trTaskRH.setRuleSubjectSet(this.getDesign().getProcessModel().getAllTransformationTasks());
        compositeRuleHandler.add(this.trTaskRH);
        this.processModelRH = compositeRuleHandler;
        this.addRuleHandler(compositeRuleHandler);
        if (this.relDesign != null) {
            CompositeRuleHandler compositeRuleHandler4 = new CompositeRuleHandler();
            compositeRuleHandler4.setLabel("Physical");
            this.physicalRH = compositeRuleHandler4;
            this.addRuleHandler(compositeRuleHandler4);
        }
        this.addObject(rHAttribute, "Attribute");
        this.addObject(rHEntity, "Entity");
        this.addObject(rHKey, "Key");
        this.addObject(this.viewRH, "View");
        this.addObject(this.agentRH, "External Agent");
        this.addObject(this.flowRH, "Information Flow");
        this.addObject(this.storeRH, "Information Store");
        this.addObject(this.processRH, "Process");
        this.addObject(this.trTaskRH, "Transformation Task");
        this.addObject(this.transformationRH, "Transformation");
        this.addObject(this.columnRH, "Column");
        this.addObject(rHDomain, "Domain");
        this.addObject(this.indexRH, "Index/Constraint");
        this.addObject(this.constrRH, "Table Level Constraint");
        this.addObject(this.tableRH, "Table");
        this.addRemoveCustomRules();
    }

    public void addRemoveCustomRules() {
        ArrayList<DRCustomScript> arrayList = this.appView.getCustomDesignRules();
        for (DRCustomValidationScript object : new ArrayList<DRCustomScript>(this.tempListCustomDR)) {
            if (arrayList.contains(object)) continue;
            RuleHandler ruleHandler = object.getRuleHandler();
            ruleHandler.removeRule(object);
            object.setRuleHandler(null);
            this.tempListCustomDR.remove(object);
        }
        for (DRCustomScript dRCustomScript : arrayList) {
            RuleHandler ruleHandler;
            DRCustomValidationScript dRCustomValidationScript;
            if (!(dRCustomScript instanceof DRCustomValidationScript) || this.tempListCustomDR.contains(dRCustomValidationScript = (DRCustomValidationScript)dRCustomScript)) continue;
            dRCustomValidationScript.setRuleHandler((RuleHandler)this.objects.get(dRCustomValidationScript.getObject()));
            if (dRCustomValidationScript.getPurpose().equals("validation") && (ruleHandler = dRCustomValidationScript.getRuleHandler()) != null) {
                ruleHandler.addRule(dRCustomValidationScript);
            }
            this.tempListCustomDR.add(dRCustomValidationScript);
        }
    }

    private void resetRuleSubjectSets() {
        this.tableRH.setRuleSubjectSet(this.getTableSet());
        this.columnRH.setRuleSubjectSet(this.getColumnSet());
        this.indexRH.setRuleSubjectSet(this.getGlobalIndexSet());
        this.constrRH.setRuleSubjectSet(this.getConstraintSet());
        this.viewRH.setRuleSubjectSet(this.getTableViewSet());
        this.physicalRH.clear();
        StorageDesign[] storageDesignArray = this.relDesign.getStorageDesignFactory().getOpenStorageDesigns();
        for (int i = 0; i < storageDesignArray.length; ++i) {
            StorageDesign storageDesign = storageDesignArray[i];
            this.physicalRH.add(storageDesign.getRuleHandler());
        }
    }

    private void resetProcessRuleSubjectSets() {
        this.processRH.setRuleSubjectSet(this.getAllProcesses());
        this.agentRH.setRuleSubjectSet(this.getAllAgents());
        this.storeRH.setRuleSubjectSet(this.getAllStores());
        this.flowRH.setRuleSubjectSet(this.getAllFlows());
        this.resetTransformationRuleSubjectSets();
        this.resetTrTaskRuleSubjectSets();
    }

    private void resetTransformationRuleSubjectSets() {
        this.transformationRH.setRuleSubjectSet(this.getDesign().getProcessModel().getTransformations());
    }

    private void resetTrTaskRuleSubjectSets() {
        this.trTaskRH.setRuleSubjectSet(this.getDesign().getProcessModel().getAllTransformationTasks());
    }

    public RuleHandler getLogicalRuleHandler() {
        return this.logicalRH;
    }

    public RuleHandler getRelationalRuleHandler() {
        return this.relationalRH;
    }

    public CompositeRuleHandler getPhysicalRuleHandler() {
        return this.physicalRH;
    }

    public RuleHandler getProcessModelRuleHandler() {
        return this.processModelRH;
    }

    public RuleHandler getGeneralRuleHandler() {
        return this.generalRH;
    }

    public void addRuleHandler(RuleHandler ruleHandler) {
        if (this.firstHandler == null) {
            this.firstHandler = ruleHandler;
        } else {
            this.firstHandler.append(ruleHandler);
        }
        this.fireUpdate();
    }

    public void handle(Object object, Collection collection) {
        this.firstHandler.handle(object, collection);
    }

    @Override
    public int size() {
        if (this.firstHandler == null) {
            return 0;
        }
        return this.firstHandler.getIndexInList(0);
    }

    @Override
    public Object getElement(int n) {
        if (this.firstHandler == null) {
            return null;
        }
        return this.firstHandler.getNthInList(n);
    }

    @Override
    public int getIndexFor(Object object) {
        if (this.firstHandler == null) {
            return -1;
        }
        if (object instanceof RuleHandler) {
            return this.firstHandler.getIndexInListFor((RuleHandler)object, -1);
        }
        return -1;
    }

    @Override
    public void addUpdateListener(UpdateListener updateListener) {
        this.delegate.addUpdateListener(updateListener);
    }

    @Override
    public void removeUpdateListener(UpdateListener updateListener) {
        this.delegate.removeUpdateListener(updateListener);
    }

    protected void fireUpdate() {
        this.delegate.fireChange();
    }

    public Collection applyRulesToSubject() {
        Collection collection = this.createCollection();
        for (int i = 0; i < this.size(); ++i) {
            RuleHandler ruleHandler = (RuleHandler)this.getElement(i);
            ruleHandler.applyRulesToSubject(collection);
            if (!ruleHandler.hasEvalErr) continue;
            this.res = ruleHandler.hasEvalErr;
            break;
        }
        return collection;
    }

    public void setFilterLevel(int n) {
        this.filtering = n;
    }

    public int getFilterLevel() {
        return this.filtering;
    }

    public Collection createCollection() {
        switch (this.getFilterLevel()) {
            case 2: {
                return new FilterOkWarningList();
            }
            case 1: {
                return new FilterOkList();
            }
        }
        return new ArrayList();
    }

    public void setRelDesign(RelationalDesign relationalDesign) {
        this.relDesign = relationalDesign;
        if (relationalDesign != null) {
            this.resetRuleSubjectSets();
        }
    }

    public void setDataFlowDesign(DataFlowDesign dataFlowDesign) {
        this.dataFlowDesign = dataFlowDesign;
        this.resetProcessRuleSubjectSets();
    }

    private DesignObjectSet getTableSet() {
        if (this.relDesign != null) {
            return this.relDesign.getTableSet();
        }
        return null;
    }

    private DesignObjectSet getColumnSet() {
        if (this.relDesign != null) {
            return this.relDesign.getColumnSet();
        }
        return null;
    }

    private ModelObjectSet getGlobalIndexSet() {
        if (this.relDesign != null) {
            return this.relDesign.getGlobalIndexSet();
        }
        return null;
    }

    private List getConstraintSet() {
        if (this.relDesign != null) {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = this.relDesign.getTableSet().iterator();
            while (iterator.hasNext()) {
                Table table = (Table)iterator.next();
                arrayList.addAll(table.getCheckConstraints());
            }
            return arrayList;
        }
        return null;
    }

    private DesignObjectSet getTableViewSet() {
        if (this.relDesign != null) {
            return this.relDesign.getTableViewSet();
        }
        return null;
    }

    private List getAllProcesses() {
        if (this.dataFlowDesign != null) {
            return this.dataFlowDesign.getAllProcesses();
        }
        return null;
    }

    private DesignObjectSet getAllAgents() {
        if (this.dataFlowDesign != null) {
            return this.dataFlowDesign.getExternalAgentSet();
        }
        return null;
    }

    private DesignObjectSet getAllStores() {
        if (this.dataFlowDesign != null) {
            return this.dataFlowDesign.getInfoStoreSet();
        }
        return null;
    }

    private List getAllFlows() {
        if (this.dataFlowDesign != null) {
            return this.dataFlowDesign.getAllFlows();
        }
        return null;
    }

    public TreeMap<String, Object> getObjects() {
        return this.objects;
    }

    public void addObject(Object object, String string) {
        this.getObjects().put(string, object);
    }

    class FilterOkWarningList
    extends ArrayList {
        FilterOkWarningList() {
        }

        @Override
        public boolean add(Object object) {
            CheckResult checkResult = (CheckResult)object;
            if (checkResult.isOk() || checkResult.isWarning()) {
                return false;
            }
            return super.add(object);
        }
    }

    class FilterOkList
    extends ArrayList {
        FilterOkList() {
        }

        @Override
        public boolean add(Object object) {
            CheckResult checkResult = (CheckResult)object;
            if (checkResult.isOk()) {
                return false;
            }
            return super.add(object);
        }
    }
}

