/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules;

import java.util.Collection;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.RuleHandler;
import oracle.dbtools.crest.model.designrules.RuleNode;

public abstract class DesignRule
implements RuleNode {
    public static final int TYPE_ERROR = 0;
    public static final int TYPE_WARNING = 1;
    public static final int TYPE_INFO = 2;
    private String contextString = "";
    private RuleHandler ruleHandler;
    private String name;
    private String description;

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setDescription(StringBuffer stringBuffer) {
        this.setDescription(stringBuffer.toString());
    }

    public String getDescription() {
        return this.description;
    }

    public abstract CheckResult doCheck(Object var1);

    public void collectCheckResults(Collection collection, Object object) {
        try {
            CheckResult checkResult = this.doCheck(object);
            if (checkResult != null && !checkResult.isOk()) {
                collection.add(checkResult);
            }
        }
        catch (Throwable throwable) {
            collection.add(CheckResult.createFailed(object, this, throwable.toString()));
        }
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public Object getElement(int n) {
        return null;
    }

    @Override
    public int getIndexFor(Object object) {
        return -1;
    }

    protected CheckResult createNoImplementationWarning(Object object) {
        return CheckResult.createWarning(object, this, new StringBuffer().append(this.getClass().getName()).append(Messages.getString("DesignRule.NotYetImplemented")).toString());
    }

    public void setContextString(String string) {
        this.contextString = string;
    }

    public String getContextString() {
        return this.contextString;
    }

    public abstract int getType();

    public RuleHandler getRuleHandler() {
        return this.ruleHandler;
    }

    public void setRuleHandler(RuleHandler ruleHandler) {
        this.ruleHandler = ruleHandler;
    }

    public abstract String getRuleId();

    public void init() {
    }
}

