/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules;

import java.text.MessageFormat;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRDesignObjectMaxNameLength
extends AbstractDRStorageDesign {
    private final String RULE_ID = "0271E7BF-AA54-9AB8-FDAB-C8822C5D2364";

    public DRDesignObjectMaxNameLength(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRDesignObjectMaxNameLength.IdentifyObjectsExceedingMaximumNameLength"));
        this.setDescription(Messages.getString("DRDesignObjectMaxNameLength.ObjectNameHasTooManyCharactersMustStartWithLetter"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        ModelIDObject modelIDObject = (ModelIDObject)object;
        String string = modelIDObject.getName();
        if (string.length() > 0) {
            if (modelIDObject.getMaxNameLength() > 0 && string.length() > modelIDObject.getMaxNameLength()) {
                return CheckResult.createFailed(modelIDObject, this, new StringBuffer(MessageFormat.format(Messages.getString("DRDesignObjectMaxNameLength.NameHasMorethan"), modelIDObject.getMaxNameLength())).toString());
            }
            if (!Character.isLetter(string.charAt(0))) {
                return CheckResult.createFailed(modelIDObject, this, Messages.getString("DRDesignObjectMaxNameLength.FirstCharacterOfTheNameMustBeLetter"));
            }
        } else {
            return CheckResult.createFailed(modelIDObject, this, Messages.getString("DRDesignObjectMaxNameLength.ThereIsNoNameSpecified"));
        }
        return CheckResult.createOk(modelIDObject, this, Messages.getString("DRDesignObjectMaxNameLength.LengthFirstCharacterOfNameIsOk"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "0271E7BF-AA54-9AB8-FDAB-C8822C5D2364";
    }
}

