/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.model.designrules.RuleHandler;

public class CompositeRuleHandler
extends RuleHandler {
    private static final Object[] RULEHANDLER_PROTO = new RuleHandler[0];
    private List composedList = new ArrayList();

    @Override
    public void addRule(DesignRule designRule) {
        throw new IllegalArgumentException("CompositeRuleHandler just groups RuleHandlers, does not accept Rules");
    }

    public void add(RuleHandler ruleHandler) {
        if (!this.composedList.contains(ruleHandler)) {
            this.composedList.add(ruleHandler);
        }
    }

    public void remove(RuleHandler ruleHandler) {
        this.composedList.remove(ruleHandler);
    }

    public void clear() {
        this.composedList.clear();
    }

    @Override
    protected boolean canHandle(Object object) {
        RuleHandler[] ruleHandlerArray = (RuleHandler[])this.composedList.toArray(RULEHANDLER_PROTO);
        for (int i = 0; i < ruleHandlerArray.length; ++i) {
            if (!ruleHandlerArray[i].canHandle(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void doHandle(Object object, Collection collection) {
        RuleHandler[] ruleHandlerArray = (RuleHandler[])this.composedList.toArray(RULEHANDLER_PROTO);
        for (int i = 0; i < ruleHandlerArray.length; ++i) {
            if (!ruleHandlerArray[i].canHandle(object)) continue;
            ruleHandlerArray[i].doHandle(object, collection);
        }
    }

    @Override
    public int size() {
        return this.composedList.size();
    }

    @Override
    public int getIndexFor(Object object) {
        return this.composedList.indexOf(object);
    }

    @Override
    public Object getElement(int n) {
        return this.composedList.get(n);
    }

    @Override
    public Collection applyRulesToSubject(Collection collection) {
        super.applyRulesToSubject(collection);
        for (RuleHandler ruleHandler : this.composedList) {
            ruleHandler.hasEvalErr = false;
            ruleHandler.applyRulesToSubject(collection);
            this.hasEvalErr = ruleHandler.hasEvalErr;
            if (!ruleHandler.hasEvalErr) continue;
            break;
        }
        return collection;
    }
}

