/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules;

import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.designrules.CRAdapter;
import oracle.dbtools.crest.model.designrules.CRCustom;
import oracle.dbtools.crest.model.designrules.CRFailed;
import oracle.dbtools.crest.model.designrules.CRInfo;
import oracle.dbtools.crest.model.designrules.CROk;
import oracle.dbtools.crest.model.designrules.CRWarning;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.model.propertyholder.functionality.UpdateListener;
import oracle.dbtools.crest.model.propertyholder.functionality.UpdateSubject;
import oracle.dbtools.crest.model.propertyholder.functionality.UpdateSubjectImpl;

public abstract class CheckResult
implements UpdateSubject {
    private UpdateSubjectImpl updater = new UpdateSubjectImpl();
    private Object affected;
    private String subName;
    private DesignRule rule;
    private String message;
    private String customErrType;

    public abstract boolean isOk();

    public boolean isWarning() {
        return false;
    }

    public boolean isInfo() {
        return false;
    }

    public boolean isCustom() {
        return false;
    }

    public void setAffected(Object object) {
        this.affected = object;
        this.updater.fireChange();
    }

    public Object getAffected() {
        return this.affected;
    }

    public void setSubName(String string) {
        this.subName = string;
    }

    public String getSubName() {
        return this.subName;
    }

    public void setRule(DesignRule designRule) {
        this.rule = designRule;
    }

    public DesignRule getRule() {
        return this.rule;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public String getMessage() {
        return this.message;
    }

    public String getCustomErrType() {
        return this.customErrType;
    }

    public void setCustomErrType(String string) {
        this.customErrType = string;
    }

    public CheckResult reCheck() {
        if (this.getRule() == null) {
            return this;
        }
        this.getRule().init();
        return this.getRule().doCheck(this.getAffected());
    }

    public void selectInModel() {
        if (this.getAffected() != null) {
            if (this.getAffected() instanceof DesignObject) {
                DesignObject designObject = (DesignObject)this.getAffected();
                designObject.showModal = true;
                if (designObject instanceof Index) {
                    if (((Index)designObject).isFK()) {
                        Index index = (Index)designObject;
                        FKIndexAssociation fKIndexAssociation = index.getFKAssociation();
                        fKIndexAssociation.showModal = true;
                        fKIndexAssociation.showPropertyDialog();
                    }
                } else {
                    designObject.showPropertyDialog();
                }
            } else if (this.getAffected() instanceof StorageObject) {
                StorageObject storageObject = (StorageObject)this.getAffected();
                storageObject.showModal = true;
                storageObject.showPropertyDialog();
            }
        }
    }

    private static CheckResult createResult(CheckResult checkResult, Object object, String string, DesignRule designRule, String string2, String string3) {
        CRAdapter cRAdapter = new CRAdapter(checkResult);
        ((CheckResult)cRAdapter).setAffected(object);
        ((CheckResult)cRAdapter).setRule(designRule);
        ((CheckResult)cRAdapter).setMessage(string2);
        ((CheckResult)cRAdapter).setSubName(string);
        cRAdapter.setCustomErrType(string3);
        return cRAdapter;
    }

    public static CheckResult createOk(Object object, String string, DesignRule designRule, String string2) {
        return CheckResult.createResult(new CROk(), object, string, designRule, string2, null);
    }

    public static CheckResult createFailed(Object object, String string, DesignRule designRule, String string2) {
        return CheckResult.createResult(new CRFailed(), object, string, designRule, string2, null);
    }

    public static CheckResult createCustom(Object object, String string, DesignRule designRule, String string2, String string3) {
        return CheckResult.createResult(new CRCustom(), object, string, designRule, string2, string3);
    }

    public static CheckResult createWarning(Object object, String string, DesignRule designRule, String string2) {
        return CheckResult.createResult(new CRWarning(), object, string, designRule, string2, null);
    }

    public static CheckResult createInfo(Object object, String string, DesignRule designRule, String string2) {
        return CheckResult.createResult(new CRInfo(), object, string, designRule, string2, null);
    }

    public static CheckResult createOk(Object object, DesignRule designRule, String string) {
        return CheckResult.createOk(object, null, designRule, string);
    }

    public static CheckResult createFailed(Object object, DesignRule designRule, String string) {
        return CheckResult.createFailed(object, null, designRule, string);
    }

    public static CheckResult createWarning(Object object, DesignRule designRule, String string) {
        return CheckResult.createWarning(object, null, designRule, string);
    }

    public static CheckResult createInfo(Object object, DesignRule designRule, String string) {
        return CheckResult.createInfo(object, null, designRule, string);
    }

    public static CheckResult createCustom(Object object, DesignRule designRule, String string, String string2) {
        return CheckResult.createCustom(object, null, designRule, string, string2);
    }

    @Override
    public void addUpdateListener(UpdateListener updateListener) {
        this.updater.addUpdateListener(updateListener);
    }

    @Override
    public void removeUpdateListener(UpdateListener updateListener) {
        this.updater.removeUpdateListener(updateListener);
    }

    protected void fireChange() {
        this.updater.fireChange();
    }
}

