/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.undo.relational.memento;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;

public class IndexMemento {
    public String comments = "";
    public String notes = "";
    public String comments_in_rdbms;
    public String name;
    public String id;
    public boolean generate_in_DDL;
    public Table table;
    public Index index;
    public List<ColWr> columns = new ArrayList<ColWr>();
    public boolean spatial;
    public boolean engineer;
    public String expression = "";
    public String index_state;
    public String is_geodetic;
    public String layer_type;
    public SchemaObject schemaObject;
    public int dimensionsNumber = 2;
    public boolean isOidKey = false;

    public IndexMemento(Index index) {
        this.index = index;
        this.name = index.getName();
        this.id = index.getObjectID();
        this.comments = index.getComment();
        this.comments_in_rdbms = index.getCommentInRDBMS();
        this.notes = index.getNotes();
        this.generate_in_DDL = index.isMarkedGenerate();
        this.table = (Table)index.getContainerWithKeyObject();
        this.spatial = index.isSpatialIndex();
        this.engineer = index.getShouldEngineer();
        this.index_state = index.getIndexState();
        this.schemaObject = index.getSchemaObject();
        this.expression = index.getIndexExpression();
        this.is_geodetic = index.getGeodetic();
        this.layer_type = index.getLayerType();
        this.dimensionsNumber = index.getDimensionsNumber();
        this.isOidKey = index.isOidKey();
        for (Column column : index.getElementsCollection()) {
            ColWr colWr = new ColWr();
            colWr.col_id = column.getObjectID();
            colWr.sort_order = index.getColumnSortOrder(column);
            this.columns.add(colWr);
        }
    }

    public void copyto(IndexMemento indexMemento) {
        indexMemento.name = this.name;
        indexMemento.id = this.id;
        indexMemento.comments = this.comments;
        indexMemento.comments_in_rdbms = this.comments_in_rdbms;
        indexMemento.notes = this.notes;
        indexMemento.generate_in_DDL = this.generate_in_DDL;
        indexMemento.spatial = this.spatial;
        indexMemento.engineer = this.engineer;
        indexMemento.index_state = this.index_state;
        indexMemento.schemaObject = this.schemaObject;
        indexMemento.expression = this.expression;
        indexMemento.is_geodetic = this.is_geodetic;
        indexMemento.layer_type = this.layer_type;
        indexMemento.dimensionsNumber = this.dimensionsNumber;
        indexMemento.isOidKey = this.isOidKey;
        indexMemento.columns.clear();
        for (ColWr colWr : this.columns) {
            ColWr colWr2 = new ColWr();
            colWr2.col_id = colWr.col_id;
            colWr2.sort_order = colWr.sort_order;
            indexMemento.columns.add(colWr2);
        }
    }

    public boolean contains(Column column) {
        return this.get(column) != null;
    }

    public ColWr get(Column column) {
        String string = column.getObjectID();
        for (ColWr colWr : this.columns) {
            if (!colWr.col_id.equals(string)) continue;
            return colWr;
        }
        return null;
    }

    public void remove(Column column) {
        this.columns.remove(this.get(column));
    }

    public void add(Column column) {
        this.columns.add(new ColWr(column.getObjectID(), this.index.getColumnSortOrder(column)));
    }

    public class ColWr {
        public String col_id;
        public String sort_order;

        public ColWr() {
        }

        public ColWr(String string, String string2) {
            this.col_id = string;
            this.sort_order = string2;
        }
    }
}

