/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.undo.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.undo.DesignObjectEdit;
import oracle.dbtools.crest.model.design.undo.RemoveDO_Edit;

public class IndexRemoveEdit
extends RemoveDO_Edit {
    private Index index;
    private Index backup;
    private List savedItems = new ArrayList();
    private Table table;
    private List mappings = new ArrayList();

    public IndexRemoveEdit(Index index) {
        super(index);
        this.index = index;
        this.table = (Table)index.getContainerWithKeyObject();
        this.backup = new Index(index.getDesignPart());
        this.backup.setContainerObject(this.table);
        this.backup.setObjectID(index.getObjectID());
        index.copy(this.backup);
        this.saveMappings(index, this.mappings);
        if (index.isPK() || index.isUnique()) {
            Collection collection = ((RelationalDesign)index.getDesignPart()).getFKIndexAssociationSet().getAssociationsWith(index);
            this.backupFKeys(collection, this.savedItems);
        }
    }

    @Override
    protected void removeObject() {
        this.index.remove();
    }

    @Override
    protected void restoreObject() {
        Index index = (Index)this.table.getKeySet().getObjectByID(this.backup.getObjectID());
        if (index == null) {
            index = this.index;
            this.table.add(index);
        } else {
            this.index = index;
        }
        this.backup.copy(index);
        for (DesignObjectEdit.MappingWr mappingWr : this.mappings) {
            Index index2 = (Index)this.table.getLocalObject(mappingWr.object.getObjectID());
            if (index2 == null) continue;
            mappingWr.object = index2;
        }
        this.restoreMappings(this.mappings);
        this.restoreFKeys(this.savedItems);
    }

    private void backupFKeys(Collection collection, List list) {
        for (FKIndexAssociation fKIndexAssociation : collection) {
            list.add(this.backupFK(fKIndexAssociation, true));
        }
    }

    private void restoreFKeys(List list) {
        for (DesignObjectEdit.FKProperties fKProperties : list) {
            this.restoreFK(fKProperties);
        }
    }
}

