/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.undo.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.undo.relational.FKColumnPreserver;

public class IndexColumnPreserver {
    private Column column;
    private String id;
    private String ind_id;
    private Table table;
    private int position;
    private RelationalDesign phdes;
    private List fk_col_preservers = new ArrayList();
    private Index index;
    private String sortOrder;

    public IndexColumnPreserver(Index index, Column column) {
        this.phdes = (RelationalDesign)column.getDesignPart();
        this.index = index;
        this.ind_id = index.getObjectID();
        this.table = (Table)index.getContainerWithKeyObject();
        this.preserve(column);
    }

    private void preserve(Column column) {
        this.column = column;
        this.id = this.column.getObjectID();
        this.position = this.index.getIndexOf(column);
        this.sortOrder = this.index.getColumnSortOrder(column);
        if (this.index.isPK() || this.index.isUnique()) {
            Collection collection = this.phdes.getFKIndexAssociationSet().getAssociationsWith(this.index);
            for (FKIndexAssociation fKIndexAssociation : collection) {
                Column column2 = fKIndexAssociation.getColumnForDelegate(column);
                if (column2 == null) continue;
                FKColumnPreserver fKColumnPreserver = new FKColumnPreserver();
                fKColumnPreserver.preserve(column2);
                this.fk_col_preservers.add(fKColumnPreserver);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore() {
        Index index = (Index)this.table.getKeySet().getObjectByID(this.ind_id);
        if (index == null) {
            throw new RuntimeException("IndexColumnPreserver.restore() - Index " + this.index.getName() + " cannot be found in Table " + this.table.getName());
        }
        this.index = index;
        Column column = (Column)this.table.getElementByID(this.id);
        if (column == null) {
            throw new RuntimeException("IndexColumnPreserver.restore() - Column " + this.column.getLongName() + " cannot be restored in Index " + this.index.getName());
        }
        Column column2 = (Column)this.index.getElementByID(this.id);
        if (column2 == null) {
            try {
                this.index.getDesign().setPropagatePKChahges(false);
                this.index.add(column);
            }
            finally {
                this.index.getDesign().setPropagatePKChahges(true);
            }
            column2 = column;
        }
        this.index.moveToIndex(column2, this.position);
        this.index.setColumnSortOrder(column2, this.sortOrder);
        for (FKColumnPreserver fKColumnPreserver : this.fk_col_preservers) {
            fKColumnPreserver.restore();
        }
    }
}

