/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.undo.relational;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.undo.relational.FKColumnPreserver;

public class ColumnPreserver
extends FKColumnPreserver {
    private Column column;
    private Column backup;
    private String id;
    private Table table;
    private int position;
    private int[][] occurences;
    private KeyObject[] keys;
    private RelationalDesign phdes;
    private List fk_col_preservers = new ArrayList();

    public ColumnPreserver(Column column) {
        this.phdes = (RelationalDesign)column.getDesignPart();
        this.preserve(column);
    }

    @Override
    public void preserve(Column column) {
        this.column = column;
        this.backup = new Column(this.phdes);
        this.column.copy(this.backup);
        this.id = this.column.getObjectID();
        this.backup.setObjectID(this.id);
        this.position = this.column.getIndex();
        this.table = (Table)this.column.getContainerWithKeyObject();
        this.keys = this.table.getKeys();
        this.occurences = this.occursInCandidateKeys(this.keys, this.column);
        this.saveMappings(this.column, this.mappings);
        ColumnPreserver.saveFKandDelegates(column, this.delegates);
        List list = this.getUK_PKFor(column);
        if (list.size() > 0) {
            List list2 = this.phdes.getFKIndexAssociationSet().getFKeysToListOfKeys(list);
            for (FKIndexAssociation fKIndexAssociation : list2) {
                Column column2 = fKIndexAssociation.getColumnForDelegate(column);
                if (column2 == null) continue;
                FKColumnPreserver fKColumnPreserver = new FKColumnPreserver();
                fKColumnPreserver.preserve(column2);
                this.fk_col_preservers.add(fKColumnPreserver);
            }
        }
    }

    @Override
    public void restore(Column column) {
        this.backup.copy(column);
        column.setObjectID(this.id);
        this.table.moveToIndex(column, this.position);
        if (this.occurences != null) {
            this.insertInCandidateKeys(this.keys, column, this.occurences);
        }
        this.restoreMappings(this.mappings);
        ColumnPreserver.restoreFKandDelegates(column, this.delegates);
        for (FKColumnPreserver fKColumnPreserver : this.fk_col_preservers) {
            fKColumnPreserver.restore(column);
        }
    }

    @Override
    public void restore() {
        Column column = (Column)this.table.getElementByID(this.id);
        if (column == null) {
            column = this.column;
            this.column.setObjectID(this.id);
            this.table.add(column);
        }
        this.backup.copy(column);
        this.table.moveToIndex(column, this.position);
        if (this.occurences != null) {
            this.insertInCandidateKeys(this.keys, column, this.occurences);
        }
        this.restoreMappings(this.mappings);
        ColumnPreserver.restoreFKandDelegates(column, this.delegates);
        for (FKColumnPreserver fKColumnPreserver : this.fk_col_preservers) {
            fKColumnPreserver.restore();
        }
    }

    private List getUK_PKFor(Column column) {
        Table table = (Table)column.getContainerWithKeyObject();
        ArrayList<KeyObject> arrayList = new ArrayList<KeyObject>();
        KeyObject[] keyObjectArray = table.getKeys();
        for (int i = 0; i < keyObjectArray.length; ++i) {
            if (!keyObjectArray[i].isPK() && !keyObjectArray[i].isUnique()) continue;
            arrayList.add(keyObjectArray[i]);
        }
        return arrayList;
    }
}

