/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.undo;

import java.text.MessageFormat;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CompoundEdit;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.undo.DesignObjectEdit;
import oracle.dbtools.crest.model.design.undo.NoteRemoveEdit;
import oracle.dbtools.crest.model.design.undo.relational.ColumnRemoveEdit;
import oracle.dbtools.crest.model.design.undo.relational.FKArcRemoveEdit;
import oracle.dbtools.crest.model.design.undo.relational.FKRemoveEdit;
import oracle.dbtools.crest.model.design.undo.relational.IndexRemoveEdit;
import oracle.dbtools.crest.model.design.undo.relational.TableRemoveEdit;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class RemoveDO_Edit
extends DesignObjectEdit {
    private static final Logger LOGGER = new Logger(RemoveDO_Edit.class);
    private DesignObject designObject;

    public RemoveDO_Edit(DesignObject designObject) {
        this.designObject = designObject;
    }

    protected abstract void restoreObject();

    protected abstract void removeObject();

    @Override
    public String getRedoPresentationName() {
        return MessageFormat.format(Messages.getString("RemoveDO_Edit.RedoRemove"), this.designObject.getLongName());
    }

    @Override
    public String getUndoPresentationName() {
        return MessageFormat.format(Messages.getString("RemoveDO_Edit.UndoRemove"), this.designObject.getLongName());
    }

    @Override
    public void redo() throws CannotRedoException {
        try {
            super.redo();
            this.removeObject();
        }
        catch (Exception exception) {
            LOGGER.error("Error in RemoveDO_Edit.redo \n" + this.getUndoPresentationName() + "\n" + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undo() {
        try {
            DesignObjectEdit.UNDOABLE_ADD = true;
            super.undo();
            this.restoreObject();
        }
        catch (Exception exception) {
            LOGGER.error("Error in RemoveDO_Edit.undo \n" + this.getUndoPresentationName() + "\n" + exception.getMessage());
        }
        finally {
            DesignObjectEdit.UNDOABLE_ADD = false;
        }
    }

    public static void addUndoableRemoveEditForObject(CompoundEdit compoundEdit, DesignObject designObject) {
        RemoveDO_Edit removeDO_Edit = null;
        if (designObject instanceof Note) {
            removeDO_Edit = new NoteRemoveEdit((Note)designObject);
        } else if (designObject instanceof Table) {
            removeDO_Edit = new TableRemoveEdit((Table)designObject);
        } else if (designObject instanceof FKIndexAssociation) {
            removeDO_Edit = new FKRemoveEdit((FKIndexAssociation)designObject);
        } else if (designObject instanceof Column) {
            removeDO_Edit = new ColumnRemoveEdit((Column)designObject);
        } else if (designObject instanceof Index) {
            removeDO_Edit = new IndexRemoveEdit((Index)designObject);
        } else if (designObject instanceof FKArc) {
            removeDO_Edit = new FKArcRemoveEdit((FKArc)designObject);
        }
        if (removeDO_Edit != null) {
            if (removeDO_Edit instanceof CompoundEdit) {
                ((CompoundEdit)removeDO_Edit).end();
            }
            compoundEdit.addEdit(removeDO_Edit);
        }
    }
}

