/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.undo;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.undo.UpdateDO_Edit;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.SwingUIConstants;
import oracle.dbtools.crest.swingui.TopView;

public class FormatTV_Edit
extends UpdateDO_Edit {
    Object[] topViews;
    Object[] initialViews;
    List dpvs = new ArrayList();
    List savedItems = new ArrayList();
    List fonts;
    boolean useCustomFormat;
    boolean useDefault;
    Color bgColor;
    Color fgColor;

    public FormatTV_Edit(Object[] objectArray, boolean bl, boolean bl2, Color color, Color color2, List list) {
        super(((TopView)objectArray[0]).getModel());
        this.initialViews = objectArray;
        if (!bl) {
            this.topViews = this.getAllTopViews(objectArray);
        } else {
            this.topViews = objectArray;
            if (objectArray.length > 0) {
                this.dpvs.add(((TopView)objectArray[0]).getDesignPartView());
            }
        }
        this.fonts = list;
        this.useCustomFormat = bl;
        this.useDefault = bl2;
        this.bgColor = color;
        this.fgColor = color2;
        this.saveState();
    }

    public Object[] getTopViews() {
        return this.topViews;
    }

    @Override
    public String getRedoPresentationName() {
        if (this.initialViews.length > 1) {
            return "Redo Format Group Of Objects";
        }
        if (this.initialViews.length == 1) {
            TopView topView = (TopView)this.initialViews[0];
            return "Redo Format " + topView.toString();
        }
        return "Redo Format";
    }

    @Override
    public String getUndoPresentationName() {
        if (this.initialViews.length > 1) {
            return "Undo Format Group of Objects";
        }
        if (this.initialViews.length == 1) {
            TopView topView = (TopView)this.initialViews[0];
            return "Undo Format " + topView.toString();
        }
        return "Undo Format";
    }

    @Override
    public void applyUpdates() {
        SwingUIConstants swingUIConstants2;
        int n;
        TopView topView;
        int n2;
        if (this.useDefault) {
            for (n2 = 0; n2 < this.topViews.length; ++n2) {
                topView = (TopView)this.topViews[n2];
                topView.setUseCustomFormat(this.useCustomFormat);
                topView.setUseDefaultColor(true);
                topView.setBackgroundColor(null);
                topView.setForegroundColor(null);
            }
        } else {
            for (n2 = 0; n2 < this.topViews.length; ++n2) {
                topView = (TopView)this.topViews[n2];
                topView.setUseCustomFormat(this.useCustomFormat);
                topView.setUseDefaultColor(false);
                topView.setBackgroundColor(this.bgColor);
                topView.setForegroundColor(this.fgColor);
            }
        }
        Object[] objectArray = this.getAllTopViews(this.initialViews);
        for (n = 0; n < objectArray.length; ++n) {
            swingUIConstants2 = (TopView)objectArray[n];
            ((TopView)swingUIConstants2).setUseCustomFormat(this.useCustomFormat);
        }
        if (this.fonts.size() > 0) {
            for (n = 0; n < this.topViews.length; ++n) {
                swingUIConstants2 = (TopView)this.topViews[n];
                if (!(((TopView)swingUIConstants2).getModel() instanceof EditableFonts)) continue;
                EditableFonts editableFonts = (EditableFonts)((Object)((TopView)swingUIConstants2).getModel());
                for (FontObject fontObject : this.fonts) {
                    FontObject fontObject2 = editableFonts.getFontObject(fontObject.getType());
                    if (fontObject2 == null) continue;
                    editableFonts.getEditableFonts().remove(fontObject2);
                    editableFonts.getEditableFonts().add(fontObject.copy());
                }
            }
        }
        if (this.topViews.length > 0) {
            for (SwingUIConstants swingUIConstants2 : this.dpvs) {
                ((Component)((Object)swingUIConstants2)).repaint();
            }
        }
    }

    @Override
    protected void restoreObject() {
        for (Object object : this.savedItems) {
            if (((TVWrap)object).useDefault) {
                ((TVWrap)object).tv.setUseCustomFormat(((TVWrap)object).useCustomFormat);
                ((TVWrap)object).tv.setUseDefaultColor(true);
                ((TVWrap)object).tv.setBackgroundColor(null);
                ((TVWrap)object).tv.setForegroundColor(null);
            } else {
                ((TVWrap)object).tv.setUseCustomFormat(((TVWrap)object).useCustomFormat);
                ((TVWrap)object).tv.setUseDefaultColor(false);
                ((TVWrap)object).tv.setBackgroundColor(((TVWrap)object).bgColor);
                ((TVWrap)object).tv.setForegroundColor(((TVWrap)object).fgColor);
            }
            if (!(((TVWrap)object).tv.getModel() instanceof EditableFonts)) continue;
            this.restoreFonts((EditableFonts)((Object)((TVWrap)object).tv.getModel()), ((TVWrap)object).fonts);
        }
        if (this.topViews.length > 0) {
            for (DesignPartView designPartView : this.dpvs) {
                designPartView.repaint();
            }
        }
    }

    private void saveState() {
        for (int i = 0; i < this.topViews.length; ++i) {
            TopView topView = (TopView)this.topViews[i];
            TVWrap tVWrap = new TVWrap();
            tVWrap.useCustomFormat = topView.useCustomFormat();
            tVWrap.useDefault = topView.useDefaultColor();
            tVWrap.bgColor = topView.getBackgroundColor();
            tVWrap.fgColor = topView.getForegroundColor();
            tVWrap.tv = topView;
            if (topView.getModel() instanceof EditableFonts) {
                this.saveFonts((EditableFonts)((Object)topView.getModel()), tVWrap.fonts);
            }
            this.savedItems.add(tVWrap);
        }
    }

    private Object[] getAllTopViews(Object[] objectArray) {
        ArrayList<TopView> arrayList = new ArrayList<TopView>();
        for (int i = 0; i < objectArray.length; ++i) {
            TopView topView = (TopView)objectArray[i];
            DesignObject designObject = topView.getModel();
            if (designObject instanceof MultiShapedDesignObject) {
                arrayList.addAll(((MultiShapedDesignObject)designObject).getAllTopViews());
                continue;
            }
            arrayList.add(topView);
        }
        for (TopView topView : arrayList) {
            if (this.dpvs.contains(topView.getDesignPartView())) continue;
            this.dpvs.add(topView.getDesignPartView());
        }
        return arrayList.toArray();
    }

    class TVWrap {
        TopView tv;
        boolean useCustomFormat;
        boolean useDefault;
        Color bgColor;
        Color fgColor;
        List fonts = new ArrayList();

        TVWrap() {
        }
    }
}

