/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.undo;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.design.undo.UpdateDO_Edit;
import oracle.dbtools.crest.swingui.TopView;

public class FormatLineEdit
extends UpdateDO_Edit {
    Object[] topViews;
    List savedItems = new ArrayList();
    boolean useDefault;
    Color bgColor;
    int lineWidth;

    public FormatLineEdit(Object[] objectArray, boolean bl, Color color, int n) {
        super(((TopView)objectArray[0]).getModel());
        this.topViews = objectArray;
        this.useDefault = bl;
        this.bgColor = color;
        this.lineWidth = n;
        this.saveState();
    }

    @Override
    public void applyUpdates() {
        if (this.useDefault) {
            for (int i = 0; i < this.topViews.length; ++i) {
                TopView topView = (TopView)this.topViews[i];
                topView.setUseDefaultColor(true);
                topView.setBackgroundColor(null);
                topView.setLineWidth(1);
            }
        } else {
            for (int i = 0; i < this.topViews.length; ++i) {
                TopView topView = (TopView)this.topViews[i];
                topView.setUseDefaultColor(false);
                topView.setBackgroundColor(this.bgColor);
                topView.setLineWidth(this.lineWidth);
            }
        }
        if (this.topViews.length > 0) {
            ((TopView)this.topViews[0]).getDesignPartView().repaint();
        }
    }

    @Override
    protected void restoreObject() {
        for (LineTVWrap lineTVWrap : this.savedItems) {
            if (lineTVWrap.useDefault) {
                lineTVWrap.tv.setUseDefaultColor(true);
                lineTVWrap.tv.setBackgroundColor(null);
                lineTVWrap.tv.setLineWidth(1);
                continue;
            }
            lineTVWrap.tv.setUseDefaultColor(false);
            lineTVWrap.tv.setBackgroundColor(lineTVWrap.bgColor);
            lineTVWrap.tv.setLineWidth(lineTVWrap.lineWidth);
        }
        if (this.topViews.length > 0) {
            ((TopView)this.topViews[0]).getDesignPartView().repaint();
        }
    }

    private void saveState() {
        for (int i = 0; i < this.topViews.length; ++i) {
            TopView topView = (TopView)this.topViews[i];
            LineTVWrap lineTVWrap = new LineTVWrap();
            lineTVWrap.useDefault = topView.useDefaultColor();
            lineTVWrap.bgColor = topView.getBackgroundColor();
            lineTVWrap.tv = topView;
            lineTVWrap.lineWidth = topView.getLineWidth();
            this.savedItems.add(lineTVWrap);
        }
    }

    @Override
    public String getRedoPresentationName() {
        if (this.topViews.length > 1) {
            return "Redo Format Group Of Objects";
        }
        if (this.topViews.length == 1) {
            TopView topView = (TopView)this.topViews[0];
            return "Redo Format " + topView.toString();
        }
        return "Redo Format";
    }

    @Override
    public String getUndoPresentationName() {
        if (this.topViews.length > 1) {
            return "Undo Format Group Of Objects";
        }
        if (this.topViews.length == 1) {
            TopView topView = (TopView)this.topViews[0];
            return "Undo Format " + topView.toString();
        }
        return "Undo Format";
    }

    class LineTVWrap {
        TopView tv;
        boolean useDefault;
        Color bgColor;
        int lineWidth = 1;

        LineTVWrap() {
        }
    }
}

