/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.undo;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.undo.CompoundEdit;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.undo.relational.FKColumnPreserver;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.diagram.graph.ConnectionSet;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultPort;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;

public abstract class DesignObjectEdit
extends CompoundEdit {
    public static boolean UNDOABLE_ADD = false;

    @Override
    public boolean isSignificant() {
        return true;
    }

    protected void saveShapedTopViews(MultiShapedDesignObject multiShapedDesignObject, List list) {
        for (TopView topView : multiShapedDesignObject.getAllTopViews()) {
            ShapedStore shapedStore = this.backupShapedTopView(topView);
            list.add(shapedStore);
        }
    }

    protected ShapedStore backupShapedTopView(TopView topView) {
        ShapedStore shapedStore = new ShapedStore();
        shapedStore.hasCellview = topView.getCellView() != null;
        shapedStore.celView = topView.getCellView();
        topView.synchronizeBoundsWithCellView();
        shapedStore.settings = topView.getApplicationView().getGraphicalPropsFor(topView);
        shapedStore.topView = topView;
        shapedStore.viewID = topView.getViewID();
        return shapedStore;
    }

    protected void restoreShapedTopViews(MultiShapedDesignObject multiShapedDesignObject, List list) {
        for (ShapedStore shapedStore : list) {
            this.restoreShapedTopView(shapedStore);
        }
    }

    protected void restoreShapedTopView(ShapedStore shapedStore) {
        MultiShapedDesignObject multiShapedDesignObject = (MultiShapedDesignObject)shapedStore.topView.getModel();
        shapedStore.topView.getApplicationView().setGraphicalPropsFor(shapedStore.topView, shapedStore.settings);
        shapedStore.topView.synchronizeBoundsWithCellView();
        shapedStore.topView.setViewID(shapedStore.viewID);
        shapedStore.topView.getDesignPartView().restoreTopview(shapedStore.topView, multiShapedDesignObject);
    }

    public void saveFonts(EditableFonts editableFonts, List list) {
        for (FontObject fontObject : editableFonts.getEditableFonts()) {
            FontStore fontStore = new FontStore();
            fontStore.objectType = fontObject.getType();
            fontStore.fontName = fontObject.getFont().getName();
            fontStore.fontSize = fontObject.getFont().getSize();
            fontStore.fontStyle = fontObject.getFont().getStyle();
            fontStore.fontColor = fontObject.getColor().getRGB();
            list.add(fontStore);
        }
    }

    public void restoreFonts(EditableFonts editableFonts, List list) {
        Iterator iterator = list.iterator();
        List list2 = editableFonts.getEditableFonts();
        list2.clear();
        while (iterator.hasNext()) {
            FontStore fontStore = (FontStore)iterator.next();
            Font font = new Font(fontStore.fontName, fontStore.fontStyle, fontStore.fontSize);
            FontObject fontObject = new FontObject(fontStore.objectType, font, new Color(fontStore.fontColor));
            list2.add(fontObject);
        }
    }

    public void saveConnectorTopViews(ConnectionInterface connectionInterface, List list) {
        for (TVConnector tVConnector : connectionInterface.getAllViews()) {
            ConnectorStore connectorStore = this.backupTVConnector(tVConnector);
            list.add(connectorStore);
        }
    }

    public void saveConnectorTopViews(List list, List list2) {
        for (TVConnector tVConnector : list) {
            ConnectorStore connectorStore = this.backupTVConnector(tVConnector);
            list2.add(connectorStore);
        }
    }

    public ConnectorStore backupTVConnector(TVConnector tVConnector) {
        ConnectorStore connectorStore = new ConnectorStore();
        connectorStore.topView = tVConnector;
        connectorStore.sourceTV = tVConnector.getSourceTopView();
        connectorStore.targetTV = tVConnector.getTargetTopView();
        if (tVConnector != null && tVConnector.getEdge() != null && tVConnector.getEdge().getCellView() != null) {
            connectorStore.edge = tVConnector.getEdge();
            connectorStore.sourceP = (DefaultPort)tVConnector.getEdge().getSource();
            connectorStore.targetP = (DefaultPort)tVConnector.getEdge().getTarget();
            connectorStore.hasCell = true;
            Hashtable hashtable = new Hashtable(tVConnector.getEdge().getCellView().getAttributes());
            connectorStore.attributes = new Hashtable();
            connectorStore.attributes.put(connectorStore.edge, hashtable);
            List list = ((EdgeView)tVConnector.getEdge().getCellView()).getPoints();
            for (int i = 1; i < list.size() - 1; ++i) {
                Point2D point2D = (Point2D)list.get(i);
                connectorStore.points.add(DiagramConstants.createPoint(point2D.getX(), point2D.getY()));
            }
        } else if (tVConnector != null) {
            List list = tVConnector.getEdgePoints();
            for (int i = 0; i < list.size(); ++i) {
                Point2D point2D = (Point2D)list.get(i);
                connectorStore.points.add(DiagramConstants.createPoint(point2D.getX(), point2D.getY()));
            }
        }
        this.backupLabels(tVConnector, connectorStore.labels);
        connectorStore.restoreLabels = true;
        return connectorStore;
    }

    private void backupLabels(TVConnector tVConnector, List list) {
        for (Label label : tVConnector.getLabels()) {
            LabelStore labelStore = new LabelStore();
            labelStore.label = label;
            labelStore.topView = label.getFirstViewForDPV(tVConnector.getDesignPartView());
            if (labelStore.topView != null) {
                labelStore.topView.synchronizeBoundsWithCellView();
            }
            labelStore.site = label.getSite();
            labelStore.bounds = new Rectangle(tVConnector.getLabelBoundsFor(labelStore.site));
            labelStore.useDefaultColor = label.useDefaultColor();
            labelStore.fgColor = label.getForegroundColor();
            labelStore.bgColor = label.getBackgroundColor();
            this.saveFonts(label, labelStore.fonts);
            list.add(labelStore);
        }
    }

    private void restoreLabels(TVConnector tVConnector, List list) {
        for (LabelStore labelStore : list) {
            tVConnector.setLabel(labelStore.label, labelStore.site);
            tVConnector.setLabelBoundsFor(labelStore.bounds, labelStore.site);
            if (labelStore.useDefaultColor) {
                labelStore.label.setUseDefaultColor(true);
                labelStore.label.setBackgroundColor(null);
                labelStore.label.setForegroundColor(null);
            } else {
                labelStore.label.setUseDefaultColor(false);
                labelStore.label.setBackgroundColor(labelStore.bgColor);
                labelStore.label.setForegroundColor(labelStore.fgColor);
            }
            if (labelStore.topView != null) {
                labelStore.topView.setModel(labelStore.label);
            }
            if (labelStore.topView == null || labelStore.topView.getCellView() == null || labelStore.topView.getCellView().getCell() == null) continue;
            DefaultDiagramCell defaultDiagramCell = (DefaultDiagramCell)labelStore.topView.getCellView().getCell();
            if (labelStore.topView.getDesignPartView().getWorkSpace().getModel().contains(defaultDiagramCell)) continue;
            labelStore.topView.getDesignPartView().getWorkSpace().addContainer(defaultDiagramCell, labelStore.bounds);
        }
        tVConnector.displayLabels();
    }

    public void restoreConnectorTopViews(ConnectionInterface connectionInterface, List list) {
        for (ConnectorStore connectorStore : list) {
            this.restoreConnectorTopView(connectionInterface, connectorStore);
        }
    }

    public void restoreConnectorTopViews(List list) {
        for (ConnectorStore connectorStore : list) {
            this.restoreConnectorTopView((ConnectionInterface)((Object)connectorStore.topView.getModel()), connectorStore);
        }
    }

    public void restoreConnectorTopView(ConnectionInterface connectionInterface, ConnectorStore connectorStore) {
        boolean bl = connectorStore.topView.getDesignPartView().getViewFor(connectionInterface.getObject()) == null;
        connectionInterface.restoreTopView(connectorStore.topView, connectorStore.sourceTV, connectorStore.targetTV);
        if (connectorStore.topView.getCellView() != null) {
            connectorStore.topView.getDesignPartView().getWorkSpace().removeCells(new Object[]{connectorStore.topView.getCellView().getCell()});
            for (Label label : connectorStore.topView.getLabels()) {
                connectorStore.topView.getDesignPartView().getWorkSpace().removeLabel(label);
            }
        }
        if (connectorStore.edge != null && connectorStore.sourceTV.getCellView() != null && connectorStore.targetTV.getCellView() != null) {
            boolean bl2 = false;
            ((DefaultDiagramCell)connectorStore.sourceTV.getCellView().getCell()).add(connectorStore.sourceP);
            ((DefaultDiagramCell)connectorStore.targetTV.getCellView().getCell()).add(connectorStore.targetP);
            if (connectorStore.topView.getDesignPartView().isAutoRoute()) {
                connectorStore.topView.getDesignPartView().getWorkSpace().restoreConnection(connectorStore.edge, connectorStore.sourceP, connectorStore.targetP, connectorStore.attributes);
            } else {
                connectorStore.topView.getDesignPartView().getWorkSpace().restoreConnection(connectorStore.edge, connectorStore.sourceP, connectorStore.targetP, connectorStore.attributes);
                if (connectorStore.points.size() == 0) {
                    bl2 = true;
                }
            }
            connectorStore.topView.setCellView(connectorStore.edge.getCellView());
            if (bl2) {
                connectorStore.edge.straightLine(false);
            }
        }
        this.restoreLabels(connectorStore.topView, connectorStore.labels);
    }

    public void saveMappings(DesignObject designObject, List list) {
        MappingWr mappingWr = new MappingWr();
        mappingWr.object = designObject;
        list.add(mappingWr);
        mappingWr.mappings.addAll(designObject.getDesign().getExtendedMap().getOrCreateCollector(designObject).getAllMappings());
    }

    public void restoreMappings(List list) {
        for (MappingWr mappingWr : list) {
            for (XtdMapping xtdMapping : mappingWr.mappings) {
                boolean bl;
                if (mappingWr.object.getObjectID().equals(xtdMapping.getDeletedID())) {
                    mappingWr.object.getDesign().getExtendedMap().restoreDeletedMapping(xtdMapping, mappingWr.object);
                    continue;
                }
                boolean bl2 = bl = false;
            }
        }
    }

    public FKProperties backupFK(FKIndexAssociation fKIndexAssociation, boolean bl) {
        FKProperties fKProperties = new FKProperties();
        fKProperties.fk = fKIndexAssociation;
        fKProperties.name = fKIndexAssociation.getName();
        fKProperties.comments = fKIndexAssociation.getComment();
        fKProperties.notes = fKIndexAssociation.getNotes();
        fKProperties.mandatory = fKIndexAssociation.isMandatory();
        fKProperties.generate_in_DDL = fKIndexAssociation.isMarkedGenerate();
        fKProperties.transferable = fKIndexAssociation.isTransferable();
        fKProperties.table = (Table)fKIndexAssociation.getContainerWithKeyObject();
        fKProperties.remoteTable = fKIndexAssociation.getRemoteTable();
        fKProperties.remoteKey = fKIndexAssociation.getRemoteIndex().getObjectID();
        fKProperties.deleteRule = fKIndexAssociation.getDeleteRule();
        fKProperties.id = fKIndexAssociation.getObjectID();
        fKProperties.index_id = fKIndexAssociation.getLocalFKIndex().getObjectID();
        fKProperties.index_name = fKIndexAssociation.getLocalFKIndex().getName();
        if (bl) {
            fKProperties.arc = fKIndexAssociation.getArc();
            if (fKProperties.arc != null && fKProperties.arc.getFkeys().size() == 2) {
                fKProperties.arcBackup = this.backupFKArc(fKProperties.arc);
            }
        }
        this.backupFKColumns(fKIndexAssociation, fKProperties.columns);
        this.saveConnectorTopViews(fKIndexAssociation, (List)fKProperties.views);
        this.saveMappings(fKIndexAssociation, fKProperties.fk_mappings);
        return fKProperties;
    }

    protected void backupFKColumns(FKIndexAssociation fKIndexAssociation, List list) {
        for (Column column : fKIndexAssociation.getLocalFKIndex().getElementsCollection()) {
            Column column2 = column.getReferencedColumn(fKIndexAssociation);
            if (column == null || column2 == null) continue;
            DelegateWr delegateWr = new DelegateWr();
            delegateWr.columnID = column.getObjectID();
            delegateWr.delegateID = column2.getObjectID();
            if (fKIndexAssociation.canRemoveColumnAutomaticaly(column)) {
                delegateWr.preserver = new FKColumnPreserver();
                delegateWr.preserver.preserve(column);
            }
            list.add(delegateWr);
        }
    }

    public FKIndexAssociation restoreFK(FKProperties fKProperties) {
        FKIndexAssociation fKIndexAssociation = fKProperties.fk;
        fKIndexAssociation.setName(fKProperties.name);
        fKIndexAssociation.setComment(fKProperties.comments);
        fKIndexAssociation.setNotes(fKProperties.notes);
        fKIndexAssociation.setMarkedGenerate(fKProperties.generate_in_DDL);
        fKIndexAssociation.setDeleteRule(fKProperties.deleteRule);
        fKIndexAssociation.setObjectID(fKProperties.id);
        fKIndexAssociation.setKeyObject((KeyObject)fKProperties.remoteTable.getKeySet().getObjectByID(fKProperties.remoteKey));
        fKProperties.table.restoreFKAssociation(fKIndexAssociation, fKProperties.index_id);
        fKIndexAssociation.getLocalFKIndex().setName(fKProperties.index_name);
        this.restoreFKColumns(fKIndexAssociation, fKProperties.table, fKProperties.remoteTable, fKProperties.columns);
        fKIndexAssociation.setMandatory(fKProperties.mandatory);
        this.restoreConnectorTopViews(fKIndexAssociation, fKProperties.views);
        if (fKProperties.arc != null) {
            fKProperties.arc.addFkey(fKIndexAssociation);
            if (fKProperties.arcBackup != null) {
                this.restoreFKArc(fKProperties.arcBackup, fKProperties.table);
            }
        }
        this.restoreMappings(fKProperties.fk_mappings);
        return fKIndexAssociation;
    }

    protected void restoreFKColumns(FKIndexAssociation fKIndexAssociation, Table table, Table table2, List list) {
        for (DelegateWr delegateWr : list) {
            Column column = (Column)table.getElementByID(delegateWr.columnID);
            if (column == null) {
                delegateWr.preserver.restore();
                column = (Column)table.getElementByID(delegateWr.columnID);
            }
            Column column2 = (Column)table2.getElementByID(delegateWr.delegateID);
            if (column == null) continue;
            if (column2 != null) {
                column.addFKAssociation(column2, fKIndexAssociation);
            }
            fKIndexAssociation.getLocalFKIndex().add(column);
        }
    }

    public FKArcProps backupFKArc(FKArc fKArc) {
        FKArcProps fKArcProps = new FKArcProps();
        fKArcProps.arc = fKArc;
        fKArcProps.id = fKArc.getObjectID();
        fKArcProps.comments = fKArc.getComment();
        fKArcProps.notes = fKArc.getNotes();
        fKArcProps.inDDL = fKArc.isMarkedGenerate();
        fKArcProps.mandatory = fKArc.isMandatory();
        for (DesignObject designObject : fKArc.getFkeys()) {
            fKArcProps.used_fkeys.add(designObject.getObjectID());
        }
        this.saveShapedTopViews(fKArc, fKArcProps.arcViews);
        this.saveMappings(fKArc, fKArcProps.mappings);
        return fKArcProps;
    }

    public void restoreFKArc(FKArcProps fKArcProps, Table table) throws RuntimeException {
        Object object2;
        ArrayList<FKIndexAssociation> arrayList = new ArrayList<FKIndexAssociation>();
        for (Object object2 : fKArcProps.used_fkeys) {
            FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)((RelationalDesign)table.getDesignPart()).getFKIndexAssociationSet().getObjectByID((String)object2);
            if (fKIndexAssociation != null) {
                if (fKIndexAssociation.getContainerWithKeyObject() == table) {
                    arrayList.add(fKIndexAssociation);
                    continue;
                }
                throw new RuntimeException(MessageFormat.format(Messages.getString("DesignObjectEdit.ForeignKeyDoesntBelongToTable"), fKIndexAssociation.getLongName(), table.getName()));
            }
            throw new RuntimeException(MessageFormat.format(Messages.getString("DesignObjectEdit.MissingFK"), object2));
        }
        if (arrayList.size() < 2) {
            throw new RuntimeException(Messages.getString("DesignObjectEdit.NotEnoughFKToCreateArc"));
        }
        object2 = fKArcProps.arc;
        ((DesignObject)object2).setObjectID(fKArcProps.id);
        ((ModelIDObject)object2).setComment(fKArcProps.comments);
        ((ModelIDObject)object2).setNotes(fKArcProps.notes);
        ((FKArc)object2).setMandatory(fKArcProps.mandatory);
        ((ModelIDObject)object2).setMarkedGenerate(fKArcProps.inDDL);
        table.addArc((FKArc)object2);
        for (FKIndexAssociation fKIndexAssociation : arrayList) {
            ((FKArc)object2).addFkey(fKIndexAssociation);
        }
        table.getDesign().addDesignObject((DesignObject)object2);
        ((RelationalDesign)table.getDesignPart()).getArcSet().add((DesignObject)object2);
        this.restoreShapedTopViews((MultiShapedDesignObject)object2, fKArcProps.arcViews);
        this.restoreMappings(fKArcProps.mappings);
    }

    public TableProps backupTable(Table table) {
        TableProps tableProps = new TableProps();
        tableProps.phdes = (RelationalDesign)table.getDesignPart();
        tableProps.created = table;
        tableProps.removed = new Table(table.getDesignPart());
        tableProps.created.backupTo(tableProps.removed);
        this.saveShapedTopViews(tableProps.created, tableProps.topViews);
        this.saveFKeys(tableProps.created, tableProps.fkeys);
        this.saveArcs(tableProps.created, tableProps.arcs);
        for (DesignObject designObject : this.getTableObjects(tableProps.created)) {
            this.saveMappings(designObject, tableProps.mappings);
        }
        this.saveFonts(table, tableProps.fonts);
        return tableProps;
    }

    private List getTableObjects(Table table) {
        ArrayList<ContainerObject> arrayList = new ArrayList<ContainerObject>();
        arrayList.add(table);
        arrayList.addAll(table.getElementsCollectionImmutable());
        Iterator iterator = table.getKeySet().iterator();
        while (iterator.hasNext()) {
            Index index = (Index)iterator.next();
            arrayList.add(index);
        }
        return arrayList;
    }

    public void restoreTable(TableProps tableProps) {
        tableProps.removed.restoreTo(tableProps.created);
        tableProps.phdes.getDesign().addDesignObject(tableProps.created);
        tableProps.phdes.getTableSet().add(tableProps.created);
        this.restoreShapedTopViews(tableProps.created, tableProps.topViews);
        this.restoreFKeys(tableProps.created, tableProps.fkeys);
        this.restoreArcs(tableProps.arcs, tableProps.created);
        this.restoreContainedInMappingWrs(tableProps.created, tableProps.mappings);
        this.restoreMappings(tableProps.mappings);
        this.restoreFonts(tableProps.created, tableProps.fonts);
    }

    private void restoreContainedInMappingWrs(Table table, List list) {
        for (MappingWr mappingWr : list) {
            DesignObject designObject;
            if (mappingWr.object instanceof Table || (designObject = (DesignObject)table.getLocalObject(mappingWr.object.getObjectID())) == null) continue;
            mappingWr.object = designObject;
        }
    }

    private void saveFKeys(Table table, List list) {
        Object object2;
        for (Object object2 : ((RelationalDesign)table.getDesignPart()).getFKIndexAssociationSet().getAssociationsWith(table)) {
            FKProperties fKProperties = this.backupFK((FKIndexAssociation)object2, true);
            list.add(fKProperties);
        }
        object2 = table.getFKAssociations();
        for (int i = 0; i < ((FKIndexAssociation[])object2).length; ++i) {
            FKProperties fKProperties = this.backupFK(object2[i], false);
            list.add(fKProperties);
        }
    }

    private void restoreFKeys(Table table, List list) {
        for (int i = list.size() - 1; i > -1; --i) {
            FKProperties fKProperties = (FKProperties)list.get(i);
            this.restoreFK(fKProperties);
        }
    }

    private void saveArcs(Table table, List list) {
        for (FKArc fKArc : table.getArcs()) {
            FKArcProps fKArcProps = this.backupFKArc(fKArc);
            list.add(fKArcProps);
        }
    }

    private void restoreArcs(List list, Table table) {
        for (FKArcProps fKArcProps : list) {
            this.restoreFKArc(fKArcProps, table);
        }
    }

    public class MappingWr {
        public List mappings = new ArrayList();
        public DesignObject object;
    }

    public class FKArcProps {
        List arcViews = new ArrayList();
        public FKArc arc;
        String id;
        boolean mandatory;
        boolean inDDL;
        String comments;
        String notes;
        List used_fkeys = new ArrayList();
        List mappings = new ArrayList();
    }

    public class TableProps {
        public Table removed;
        public Table created;
        public RelationalDesign phdes;
        public List topViews = new ArrayList();
        public List fkeys = new ArrayList();
        public List mappings = new ArrayList();
        public List arcs = new ArrayList();
        List fonts = new ArrayList();
    }

    class DelegateWr {
        String columnID;
        String delegateID;
        Column backup;
        FKColumnPreserver preserver;

        DelegateWr() {
        }
    }

    public class FKProperties {
        FKIndexAssociation fk;
        String comments = "";
        String notes = "";
        String name;
        String index_name;
        String id;
        String index_id;
        boolean mandatory;
        boolean transferable;
        boolean generate_in_DDL;
        Table table;
        Table remoteTable;
        String remoteKey;
        List columns = new ArrayList();
        String deleteRule = "";
        ArrayList views = new ArrayList();
        ArrayList fk_mappings = new ArrayList();
        FKArc arc;
        FKArcProps arcBackup;
    }

    protected class LabelStore {
        Label label;
        TopView topView;
        int site;
        boolean useDefaultColor;
        Color fgColor;
        Color bgColor;
        Rectangle bounds;
        List fonts = new ArrayList();

        protected LabelStore() {
        }
    }

    public class ConnectorStore {
        TVConnector topView;
        TopView sourceTV;
        TopView targetTV;
        String sourceVID;
        String targetVID;
        List points = new ArrayList();
        List labels = new ArrayList();
        Map attributes;
        DefaultEdge edge;
        ConnectionSet cset;
        DefaultPort sourceP;
        DefaultPort targetP;
        boolean hasCell = false;
        boolean restoreLabels = false;
    }

    protected class FontStore {
        String objectType;
        String fontName;
        int fontColor;
        int fontSize;
        int fontStyle;

        protected FontStore() {
        }
    }

    protected class ShapedStore {
        TopView topView;
        Map settings;
        boolean hasCellview = false;
        String viewID = "-200";
        AbstractCellView celView;

        protected ShapedStore() {
        }
    }
}

