/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb.v81;

import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageObjectDB2;
import oracle.dbtools.crest.model.design.storage.udb.BufferPoolUDB;
import oracle.dbtools.crest.model.design.storage.udb.NodeGroupUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.BufferPoolUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.ContainerUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.swingui.editor.storage.udb.v81.TableSpacePropertyDialogUDBv81;

public class TableSpaceUDBv81
extends TableSpaceUDB {
    public static final String DATATYPE_LARGE = "LARGE";
    protected static String[] availableDataTypes = new String[]{"REGULAR", "LARGE", "SYSTEM TEMPORARY", "USER TEMPORARY"};

    public TableSpaceUDBv81(StorageDesign storageDesign) {
        super(storageDesign);
    }

    public static String[] getAvailableDataTypes() {
        return availableDataTypes;
    }

    @Override
    public void setPrefetchSize(String string) {
        if (this.checkPrefetchSize(string)) {
            this.prefetchSize = string;
        }
    }

    @Override
    protected boolean checkPrefetchSize(String string) {
        if ("AUTOMATIC".equalsIgnoreCase(string) || "".equalsIgnoreCase(string)) {
            return true;
        }
        try {
            if (Integer.parseInt(string) > 1) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TableSpacePropertyDialogUDBv81 tableSpacePropertyDialogUDBv81 = new TableSpacePropertyDialogUDBv81(this.getDesign().getAppView(), this.getStorageDesign(), this);
            tableSpacePropertyDialogUDBv81.show();
        }
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        TableSpaceUDBv81 tableSpaceUDBv81 = null;
        StorageObject storageObject = (StorageObject)((StorageDesignUDBv81)storageDesign).getTableSpaceSet().getByName(this.getName());
        if (storageObject != null) {
            if (!this.isRawObject()) {
                tableSpaceUDBv81 = (TableSpaceUDBv81)storageObject;
            }
        } else {
            tableSpaceUDBv81 = (TableSpaceUDBv81)((StorageDesignUDBv81)storageDesign).getTableSpaceSet().createTableSpace();
        }
        if (tableSpaceUDBv81 != null) {
            AbstractStorageObjectDB2 abstractStorageObjectDB2;
            tableSpaceUDBv81.setName(this.getName());
            for (int i = 0; i < this.getContainers().length; ++i) {
                abstractStorageObjectDB2 = (ContainerUDBv81)this.getContainers()[i];
                ContainerUDBv81 containerUDBv81 = (ContainerUDBv81)((StorageDesignUDBv81)storageDesign).getContainerSet().getByName(abstractStorageObjectDB2.getName());
                if (containerUDBv81 == null) {
                    ContainerUDBv81 containerUDBv812 = (ContainerUDBv81)((StorageDesignUDBv81)storageDesign).getContainerSet().createContainer();
                    containerUDBv812.setName(abstractStorageObjectDB2.getName());
                    containerUDBv812.setTableSpace(tableSpaceUDBv81);
                    containerUDBv812.setRawObject(true);
                    ((StorageDesignUDBv81)storageDesign).getContainerSet().add(containerUDBv812);
                    tableSpaceUDBv81.addContainersFromDesign(((StorageDesignUDBv81)storageDesign).getContainerSet());
                    continue;
                }
                containerUDBv81.setTableSpace(tableSpaceUDBv81);
                ((StorageDesignUDBv81)storageDesign).getContainerSet().add(abstractStorageObjectDB2);
                tableSpaceUDBv81.addContainersFromDesign(((StorageDesignUDBv81)storageDesign).getContainerSet());
            }
            tableSpaceUDBv81.setDBDefOnly(this.getDBDefOnly());
            tableSpaceUDBv81.setManagedBy(this.getManagedBy());
            tableSpaceUDBv81.setDataType(this.getDataType());
            if (this.getNodeGroup() != null) {
                NodeGroupUDB nodeGroupUDB = (NodeGroupUDB)((StorageDesignUDBv81)storageDesign).getNodeGroupSet().getByName(this.getNodeGroup().getName());
                if (nodeGroupUDB == null) {
                    abstractStorageObjectDB2 = ((StorageDesignUDBv81)storageDesign).getNodeGroupSet().createNodeGroup();
                    abstractStorageObjectDB2.setName(this.getNodeGroup().getName());
                    abstractStorageObjectDB2.setRawObject(true);
                    tableSpaceUDBv81.setNodeGroup((NodeGroupUDB)abstractStorageObjectDB2);
                } else {
                    tableSpaceUDBv81.setNodeGroup(nodeGroupUDB);
                }
            }
            tableSpaceUDBv81.setPageSize(this.getPageSize());
            tableSpaceUDBv81.setExtentSize(this.getExtentSize());
            tableSpaceUDBv81.setPrefetchSize(this.getPrefetchSize());
            if (this.getBufferPool() != null) {
                BufferPoolUDBv81 bufferPoolUDBv81 = (BufferPoolUDBv81)((StorageDesignUDBv81)storageDesign).getBufferPoolSet().getByName(this.getBufferPool().getName());
                if (bufferPoolUDBv81 == null) {
                    abstractStorageObjectDB2 = (BufferPoolUDBv81)((StorageDesignUDBv81)storageDesign).getBufferPoolSet().createBufferPool();
                    abstractStorageObjectDB2.setName(this.getBufferPool().getName());
                    abstractStorageObjectDB2.setRawObject(true);
                    tableSpaceUDBv81.setBufferPool((BufferPoolUDB)abstractStorageObjectDB2);
                } else {
                    tableSpaceUDBv81.setBufferPool(bufferPoolUDBv81);
                }
            }
            tableSpaceUDBv81.setOverhead(this.getOverhead());
            tableSpaceUDBv81.setTransferRate(this.getTransferRate());
            tableSpaceUDBv81.setDroppedTableRecovery(this.getDroppedTableRecovery());
            tableSpaceUDBv81.recreateUserSet(this.getUserSet().toString());
            tableSpaceUDBv81.recreateUserGroupSet(this.getUserGroupSet().toString());
            tableSpaceUDBv81.setGrantOption(this.getGrantOption());
            tableSpaceUDBv81.setComment(this.getComment());
            tableSpaceUDBv81.setCommentInRDBMS(this.getCommentInRDBMS());
            tableSpaceUDBv81.setRawObject(false);
        }
    }
}

