/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb.v81;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.constraint.TableCheckConstraintListener;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraintEvent;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StagingTableUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableCheckConstraintProxySetUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableCheckConstraintProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.model.design.storage.udb.TriggerUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.SchemaUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StagingTableUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableCheckConstraintProxySetUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableCheckConstraintProxyUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableSpaceUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TriggerUDBv81;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.udb.v81.TablePropertyDialogUDBv81;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class TableProxyUDBv81
extends TableProxyUDB
implements TableCheckConstraintListener,
PropertiesPropagator {
    protected String restrictOnDrop = "NO";
    protected String valueCompression = "NO";
    protected boolean organizeByDimensions = false;
    protected String dimensions = "";
    protected boolean useRemoteOptions = false;
    protected String roRemoteServer = "";
    protected String roRemoteSchema = "";
    protected String roRemoteTabName = "";
    private String validation = "ENFORCED";
    private String queryOptimization = "ENABLE";
    public static final String ENFORCED = "ENFORCED";
    public static final String NOT_ENFORCED = "NOT ENFORCED";
    public static final String ENABLE = "ENABLE";
    public static final String DISABLE = "DISABLE";
    public static String[] validationChoices = new String[]{"ENFORCED", "NOT ENFORCED"};
    private static Set validationSet = null;
    public static String[] queryOptimizationChoices = new String[]{"ENABLE", "DISABLE"};
    private static Set queryOptimizationSet = null;
    private List propertyWrapperList = null;

    public TableProxyUDBv81(Table table, StorageDesign storageDesign) {
        super(table, storageDesign);
        this.stagingTables = new StorageObjectCollection(((StorageDesignUDBv81)storageDesign).getStagingTableSet());
        this.stagingTables.setParent(this);
        this.stagingTables.setName(Messages.getString("TableProxyUDBv81.StagingTables"));
        this.stagingTables.setClassForParent(TableProxyUDB.class);
        this.stagingTables.setSetMethod("setTable");
        this.stagingTables.setAllowedNumberOfElements(1);
        this.stagingTables.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON", 16));
        ((StorageDesignUDBv81)storageDesign).getStagingTableSet().addSetListener(this);
        this.addStagingTablesFromDesign(((StorageDesignUDBv81)storageDesign).getStagingTableSet());
        if (this.summaryQuery.equalsIgnoreCase("YES") && this.summaryRefreshOptions.equalsIgnoreCase(SUMMARY_REFRESH_OPTIONS_STATES[0])) {
            this.enableStagingTables();
        } else {
            this.disableStagingTables();
        }
        this.tableCheckConstraints = new StorageObjectCollection();
        this.tableCheckConstraints.setParent(this);
        this.tableCheckConstraints.setName(Messages.getString("TableProxyOracle.TableCheckConstraints"));
        this.tableCheckConstraints.setIcon(GUIConfiguration.getInstance().getIcon("CONSTRAINT_ICON", 16));
        ((StorageDesignUDBv81)storageDesign).getTableCheckConstraintSet().addSetListener(this);
        this.addTableCheckConstraintFromDesign(((StorageDesignUDBv81)storageDesign).getTableCheckConstraintSet());
    }

    public TableProxyUDBv81(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
        this.stagingTables = new StorageObjectCollection(((StorageDesignUDBv81)storageDesign).getStagingTableSet());
        this.stagingTables.setParent(this);
        this.stagingTables.setName(Messages.getString("TableProxyUDBv81.StagingTables"));
        this.stagingTables.setClassForParent(TableProxyUDB.class);
        this.stagingTables.setSetMethod("setTable");
        this.stagingTables.setAllowedNumberOfElements(1);
        this.stagingTables.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON", 16));
        ((StorageDesignUDB)storageDesign).getTriggerSet().addSetListener(this);
        this.addStagingTablesFromDesign(((StorageDesignUDBv81)storageDesign).getStagingTableSet());
        if (this.summaryQuery.equalsIgnoreCase("YES") && this.summaryRefreshOptions.equalsIgnoreCase(SUMMARY_REFRESH_OPTIONS_STATES[0])) {
            this.enableStagingTables();
        } else {
            this.disableStagingTables();
        }
        this.tableCheckConstraints = new StorageObjectCollection();
        this.tableCheckConstraints.setParent(this);
        this.tableCheckConstraints.setName(Messages.getString("TableProxyOracle.TableCheckConstraints"));
        this.tableCheckConstraints.setIcon(GUIConfiguration.getInstance().getIcon("CONSTRAINT_ICON", 16));
        ((StorageDesignUDBv81)storageDesign).getTableCheckConstraintSet().addSetListener(this);
        this.addTableCheckConstraintFromDesign(((StorageDesignUDBv81)storageDesign).getTableCheckConstraintSet());
    }

    public String getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(String string) {
        this.dimensions = string;
        this.fireDataFieldChange();
    }

    public boolean getOrganizeByDimensions() {
        return this.organizeByDimensions;
    }

    public void setOrganizeByDimensions(boolean bl) {
        this.organizeByDimensions = bl;
    }

    public String getRestrictOnDrop() {
        return this.restrictOnDrop;
    }

    public void setRestrictOnDrop(String string) {
        if (this.checkYesNo(string)) {
            this.restrictOnDrop = string;
            this.fireDataFieldChange();
        }
    }

    public String getValueCompression() {
        return this.valueCompression;
    }

    public void setValueCompression(String string) {
        if (this.checkYesNo(string)) {
            this.valueCompression = string;
            this.fireDataFieldChange();
        }
    }

    public boolean getUseRemoteOptions() {
        return this.useRemoteOptions;
    }

    public void setUseRemoteOptions(boolean bl) {
        this.useRemoteOptions = bl;
    }

    public String getRoRemoteSchema() {
        return this.roRemoteSchema;
    }

    public void setRoRemoteSchema(String string) {
        this.roRemoteSchema = string;
        this.fireDataFieldChange();
    }

    public String getRoRemoteServer() {
        return this.roRemoteServer;
    }

    public void setRoRemoteServer(String string) {
        this.roRemoteServer = string;
        this.fireDataFieldChange();
    }

    public String getRoRemoteTabName() {
        return this.roRemoteTabName;
    }

    public void setRoRemoteTabName(String string) {
        this.roRemoteTabName = string;
        this.fireDataFieldChange();
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TablePropertyDialogUDBv81 tablePropertyDialogUDBv81 = new TablePropertyDialogUDBv81(this.getDesign().getAppView(), this.getStorageDesign(), this);
            tablePropertyDialogUDBv81.show();
        }
    }

    private void addStagingTablesFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            StagingTableUDBv81 stagingTableUDBv81 = (StagingTableUDBv81)iterator.next();
            stagingTableUDBv81.addObjectListener(this);
            if (stagingTableUDBv81.getTable() != null && stagingTableUDBv81.getTable() == this) {
                stagingTableUDBv81.setParent(this.stagingTables);
                this.stagingTables.add(stagingTableUDBv81);
                continue;
            }
            this.stagingTables.remove(stagingTableUDBv81);
        }
    }

    @Override
    public int getNumberOfChildren() {
        return super.getNumberOfChildren() + 2;
    }

    @Override
    public ModelObject getChild(int n) {
        if (n == this.getNumberOfChildren() - 3) {
            return this.stagingTables;
        }
        if (n == this.getNumberOfChildren() - 4) {
            return this.tableCheckConstraints;
        }
        return super.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.stagingTables) {
            return this.getNumberOfChildren() - 3;
        }
        if (modelObject == this.tableCheckConstraints) {
            return this.getNumberOfChildren() - 4;
        }
        return super.getIndexForChild(modelObject);
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.stagingTables) {
            return this.getNumberOfChildren() - 3;
        }
        if (object == this.tableCheckConstraints) {
            return this.getNumberOfChildren() - 4;
        }
        return super.getIndexForChild(object);
    }

    @Override
    public void changed(RelationalObjectProxySet relationalObjectProxySet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof ColumnProxy) {
                ColumnProxy columnProxy = (ColumnProxy)modelObjectSetEvent.getAffected();
                if (this.getObject() == ((Column)columnProxy.getObject()).getContainerWithKeyObject()) {
                    this.columns.add(modelObjectSetEvent.getAffected());
                }
            } else if (modelObjectSetEvent.getAffected() instanceof IndexProxy) {
                IndexProxy indexProxy = (IndexProxy)modelObjectSetEvent.getAffected();
                if (this.getObject() == ((Index)indexProxy.getObject()).getContainerWithKeyObject()) {
                    if (((Index)indexProxy.getObject()).isFK()) {
                        if (!this.fkeys.contains(indexProxy)) {
                            indexProxy.setParent(this.fkeys);
                            this.fkeys.add(modelObjectSetEvent.getAffected());
                        }
                    } else if (!this.indexes.contains(indexProxy)) {
                        indexProxy.setParent(this.indexes);
                        this.indexes.add(modelObjectSetEvent.getAffected());
                    }
                }
            } else if (modelObjectSetEvent.getAffected() instanceof TriggerUDB) {
                TriggerUDB triggerUDB = (TriggerUDB)modelObjectSetEvent.getAffected();
                triggerUDB.addObjectListener(this);
                if (triggerUDB.getTable() != null && triggerUDB.getTable() == this) {
                    triggerUDB.setParent(this.triggers);
                    this.triggers.add(triggerUDB);
                } else {
                    this.triggers.remove(triggerUDB);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof StagingTableUDB) {
                StagingTableUDB stagingTableUDB = (StagingTableUDB)modelObjectSetEvent.getAffected();
                stagingTableUDB.addObjectListener(this);
                if (stagingTableUDB.getTable() != null && stagingTableUDB.getTable() == this) {
                    stagingTableUDB.setParent(this.stagingTables);
                    this.stagingTables.add(stagingTableUDB);
                } else {
                    this.stagingTables.remove(stagingTableUDB);
                }
            }
        } else if (modelObjectSetEvent.isType(0)) {
            if (modelObjectSetEvent.getAffected() instanceof ColumnProxy) {
                this.columns.remove(((ColumnProxy)modelObjectSetEvent.getAffected()).getObject().getObjectID());
            } else if (modelObjectSetEvent.getAffected() instanceof IndexProxy) {
                IndexProxy indexProxy = (IndexProxy)modelObjectSetEvent.getAffected();
                if (this.indexes.contains(indexProxy)) {
                    this.indexes.remove(modelObjectSetEvent.getAffected());
                }
                if (this.fkeys.contains(indexProxy)) {
                    this.fkeys.remove(modelObjectSetEvent.getAffected());
                }
            } else if (modelObjectSetEvent.getAffected() instanceof TriggerUDB) {
                TriggerUDB triggerUDB = (TriggerUDB)modelObjectSetEvent.getAffected();
                this.triggers.remove(triggerUDB);
                triggerUDB.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof StagingTableUDB) {
                StagingTableUDB stagingTableUDB = (StagingTableUDB)modelObjectSetEvent.getAffected();
                this.stagingTables.remove(stagingTableUDB);
                stagingTableUDB.removeObjectListener(this);
            }
        }
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof TriggerUDB) {
            TriggerUDB triggerUDB = (TriggerUDB)objectChangeEvent.getAffected();
            if (triggerUDB.getTable() != null && triggerUDB.getTable() == this) {
                triggerUDB.setParent(this.triggers);
                this.triggers.add(triggerUDB);
            } else {
                this.triggers.remove(triggerUDB);
            }
        } else if (objectChangeEvent.getAffected() instanceof StagingTableUDB) {
            StagingTableUDB stagingTableUDB = (StagingTableUDB)objectChangeEvent.getAffected();
            if (stagingTableUDB.getTable() != null && stagingTableUDB.getTable() == this) {
                stagingTableUDB.setParent(this.stagingTables);
                this.stagingTables.add(stagingTableUDB);
            } else {
                this.stagingTables.remove(stagingTableUDB);
            }
        } else if (objectChangeEvent.getAffected() instanceof TableCheckConstraintProxyUDB) {
            TableCheckConstraintProxyUDB tableCheckConstraintProxyUDB = (TableCheckConstraintProxyUDB)objectChangeEvent.getAffected();
            if (tableCheckConstraintProxyUDB.getTable() != null && tableCheckConstraintProxyUDB.getTable() == this) {
                this.removeExisting(tableCheckConstraintProxyUDB);
                tableCheckConstraintProxyUDB.setParent(this.tableCheckConstraints);
                this.tableCheckConstraints.add(tableCheckConstraintProxyUDB);
            } else {
                this.tableCheckConstraints.remove(tableCheckConstraintProxyUDB);
            }
        }
    }

    private void removeExisting(TableCheckConstraintProxyUDB tableCheckConstraintProxyUDB) {
        for (int i = this.tableCheckConstraints.size() - 1; i >= 0; --i) {
            TableCheckConstraintProxyUDB tableCheckConstraintProxyUDB2 = (TableCheckConstraintProxyUDB)this.tableCheckConstraints.getElement(i);
            if (tableCheckConstraintProxyUDB2 == tableCheckConstraintProxyUDB || !tableCheckConstraintProxyUDB2.getName().equalsIgnoreCase(tableCheckConstraintProxyUDB.getName())) continue;
            this.tableCheckConstraints.remove(tableCheckConstraintProxyUDB2);
        }
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof TriggerUDB) {
                TriggerUDB triggerUDB = (TriggerUDB)modelObjectSetEvent.getAffected();
                triggerUDB.addObjectListener(this);
                if (triggerUDB.getTable() != null && triggerUDB.getTable() == this) {
                    triggerUDB.setParent(this.triggers);
                    this.triggers.add(triggerUDB);
                } else {
                    this.triggers.remove(triggerUDB);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof StagingTableUDB) {
                StagingTableUDB stagingTableUDB = (StagingTableUDB)modelObjectSetEvent.getAffected();
                stagingTableUDB.addObjectListener(this);
                if (stagingTableUDB.getTable() != null && stagingTableUDB.getTable() == this) {
                    stagingTableUDB.setParent(this.stagingTables);
                    this.stagingTables.add(stagingTableUDB);
                } else {
                    this.stagingTables.remove(stagingTableUDB);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof TableCheckConstraintProxyUDB) {
                TableCheckConstraintProxyUDB tableCheckConstraintProxyUDB = (TableCheckConstraintProxyUDB)modelObjectSetEvent.getAffected();
                tableCheckConstraintProxyUDB.addObjectListener(this);
                if (tableCheckConstraintProxyUDB.getTable() != null && tableCheckConstraintProxyUDB.getTable() == this) {
                    tableCheckConstraintProxyUDB.setParent(this.tableCheckConstraints);
                    this.tableCheckConstraints.add(tableCheckConstraintProxyUDB);
                } else {
                    this.tableCheckConstraints.remove(tableCheckConstraintProxyUDB);
                }
            }
        } else if (modelObjectSetEvent.isType(0)) {
            if (modelObjectSetEvent.getAffected() instanceof TriggerUDB) {
                TriggerUDB triggerUDB = (TriggerUDB)modelObjectSetEvent.getAffected();
                this.triggers.remove(triggerUDB);
                triggerUDB.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof StagingTableUDB) {
                StagingTableUDB stagingTableUDB = (StagingTableUDB)modelObjectSetEvent.getAffected();
                this.stagingTables.remove(stagingTableUDB);
                stagingTableUDB.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof TableCheckConstraintProxyUDB) {
                TableCheckConstraintProxyUDB tableCheckConstraintProxyUDB = (TableCheckConstraintProxyUDB)modelObjectSetEvent.getAffected();
                this.tableCheckConstraints.remove(tableCheckConstraintProxyUDB);
                tableCheckConstraintProxyUDB.removeObjectListener(this);
            }
        }
    }

    @Override
    public void changed(TableLevelConstraint tableLevelConstraint, TableLevelConstraintEvent tableLevelConstraintEvent) {
        if (tableLevelConstraintEvent.isType(TableLevelConstraintEvent.TABLE_CHECK_CONSTRAINT_ADDED)) {
            StorageDesignUDBv81 storageDesignUDBv81 = (StorageDesignUDBv81)this.getStorageDesign();
            TableCheckConstraintProxySetUDBv81 tableCheckConstraintProxySetUDBv81 = (TableCheckConstraintProxySetUDBv81)storageDesignUDBv81.getTableCheckConstraintSet();
            tableCheckConstraintProxySetUDBv81.addTableCheckConstraint(this, tableLevelConstraint);
        } else if (tableLevelConstraintEvent.isType(TableLevelConstraintEvent.TABLE_CHECK_CONSTRAINT_REMOVED)) {
            StorageDesignUDBv81 storageDesignUDBv81 = (StorageDesignUDBv81)this.getStorageDesign();
            TableCheckConstraintProxySetUDBv81 tableCheckConstraintProxySetUDBv81 = (TableCheckConstraintProxySetUDBv81)storageDesignUDBv81.getTableCheckConstraintSet();
            tableCheckConstraintProxySetUDBv81.removeTableCheckConstraint(this, tableLevelConstraint);
        }
    }

    public StorageObjectCollection getStagingTables() {
        return this.stagingTables;
    }

    private void enableStagingTables() {
        this.stagingTables.setForbiddenCreateElement(false);
    }

    private void disableStagingTables() {
        this.stagingTables.setForbiddenCreateElement(true);
        this.stagingTables.removeAll();
    }

    @Override
    public void setSummaryQuery(String string) {
        if (this.checkYesNo(string)) {
            super.setSummaryQuery(string);
            if (string.equalsIgnoreCase("YES") && this.summaryRefreshOptions.equalsIgnoreCase(SUMMARY_REFRESH_OPTIONS_STATES[0])) {
                this.enableStagingTables();
            } else {
                this.disableStagingTables();
            }
        }
    }

    @Override
    public void setSummaryRefreshOptions(String string) {
        if (this.checkSummaryRefreshOptions(string)) {
            this.summaryRefreshOptions = string;
            if (this.summaryQuery.equalsIgnoreCase("YES") && string.equalsIgnoreCase(SUMMARY_REFRESH_OPTIONS_STATES[0])) {
                this.enableStagingTables();
            } else {
                this.disableStagingTables();
            }
            this.fireDataFieldChange();
        }
    }

    protected boolean checkValidation(String string) {
        if (validationSet == null) {
            validationSet = new HashSet();
            validationSet.addAll(Arrays.asList(validationChoices));
        }
        return validationSet.contains(string);
    }

    protected boolean checkQueryOptimization(String string) {
        if (queryOptimizationSet == null) {
            queryOptimizationSet = new HashSet();
            queryOptimizationSet.addAll(Arrays.asList(queryOptimizationChoices));
        }
        return queryOptimizationSet.contains(string);
    }

    public String getQueryOptimization() {
        return this.queryOptimization;
    }

    public void setQueryOptimization(String string) {
        if (this.checkQueryOptimization(string)) {
            this.queryOptimization = string;
            this.fireDataFieldChange();
        }
    }

    public String getValidation() {
        return this.validation;
    }

    public void setValidation(String string) {
        if (this.checkValidation(string)) {
            this.validation = string;
            this.fireDataFieldChange();
        }
    }

    private void addTableCheckConstraintFromDesign(TableCheckConstraintProxySetUDB tableCheckConstraintProxySetUDB) {
        ModelIDObject modelIDObject;
        Iterator iterator = tableCheckConstraintProxySetUDB.iterator();
        while (iterator.hasNext()) {
            modelIDObject = (TableCheckConstraintProxyUDB)iterator.next();
            if (((TableCheckConstraintProxyUDB)modelIDObject).getTable() == null || ((TableCheckConstraintProxyUDB)modelIDObject).getTable() != this || this.tableCheckConstraints.contains(modelIDObject)) continue;
            modelIDObject.setParent(this.tableCheckConstraints);
            this.tableCheckConstraints.add(modelIDObject);
        }
        modelIDObject = (Table)this.getObject();
        for (TableLevelConstraint tableLevelConstraint : ((Table)modelIDObject).getCheckConstraints()) {
            ((TableCheckConstraintProxySetUDBv81)tableCheckConstraintProxySetUDB).addTableCheckConstraint(this, tableLevelConstraint);
            this.fireDataFieldChange();
        }
        this.fireDataFieldChange();
    }

    public StorageObjectCollection getTableCheckConstraints() {
        return this.tableCheckConstraints;
    }

    @Override
    public int getMaxNameLength() {
        return 128;
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper("Schema", this, "getSchema", "setSchema", SchemaUDB.class));
            this.propertyWrapperList.add(new PropertyWrapper("Part. Key Hashing", this, "getPartKeyHashing", "setPartKeyHashing", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("TableSpace", this, "getTableSpace", "setTableSpace", TableSpaceUDB.class));
            this.propertyWrapperList.add(new PropertyWrapper("Index TableSpace", this, "getIndexInTableSpace", "setIndexInTableSpace", TableSpaceUDB.class));
            this.propertyWrapperList.add(new PropertyWrapper("Long TableSpace", this, "getLongInTableSpace", "setLongInTableSpace", TableSpaceUDB.class));
            this.propertyWrapperList.add(new PropertyWrapper("Initial Logging", this, "getInitialLogging", "setInitialLogging", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Data Capture", this, "getDataCapture", "setDataCapture", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Federated", this, "getFederated", "setFederated", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Summary Query", this, "getSummaryQuery", "setSummaryQuery", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Restrict On Drop", this, "getRestrictOnDrop", "setRestrictOnDrop", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Value Compression", this, "getValueCompression", "setValueCompression", String.class));
        }
        return this.propertyWrapperList;
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        Table table = (Table)storageDesign.getPhysicalDesign().getTableSet().getByName(this.getObject().getName());
        TableProxyUDBv81 tableProxyUDBv81 = null;
        RelationalObjectProxy relationalObjectProxy = ((StorageDesignUDBv81)storageDesign).getTableProxySet().getProxy(table.getObjectID());
        if (relationalObjectProxy != null && !this.isRawObject()) {
            tableProxyUDBv81 = (TableProxyUDBv81)relationalObjectProxy;
        }
        if (tableProxyUDBv81 != null) {
            StorageObject storageObject;
            StorageObject storageObject2;
            StorageObject storageObject3;
            tableProxyUDBv81.setName(this.getName());
            Iterator iterator = this.getTableCheckConstraints().iterator();
            while (iterator.hasNext()) {
                storageObject3 = (TableCheckConstraintProxyUDBv81)iterator.next();
                storageObject2 = (TableCheckConstraintProxyUDBv81)((StorageDesignUDBv81)storageDesign).getTableCheckConstraintSet().getByName(((TableCheckConstraintProxyUDB)storageObject3).getName());
                if (storageObject2 == null) {
                    storageObject = (TableCheckConstraintProxyUDBv81)((StorageDesignUDBv81)storageDesign).getTableCheckConstraintSet().createTableCheckConstraintProxy();
                    ((TableCheckConstraintProxyUDB)storageObject).setName(((TableCheckConstraintProxyUDB)storageObject3).getName());
                    storageObject.setRawObject(true);
                    ((TableCheckConstraintProxyUDB)storageObject).setTable(tableProxyUDBv81);
                    tableProxyUDBv81.addTableCheckConstraintFromDesign(((StorageDesignUDBv81)storageDesign).getTableCheckConstraintSet());
                    continue;
                }
                ((TableCheckConstraintProxyUDB)storageObject2).setTable(tableProxyUDBv81);
                tableProxyUDBv81.addTableCheckConstraintFromDesign(((StorageDesignUDBv81)storageDesign).getTableCheckConstraintSet());
            }
            iterator = this.getStagingTables().iterator();
            while (iterator.hasNext()) {
                storageObject3 = (StagingTableUDBv81)iterator.next();
                storageObject2 = (StagingTableUDBv81)((StorageDesignUDBv81)storageDesign).getStagingTableSet().getByName(storageObject3.getName());
                if (storageObject2 == null) {
                    storageObject = (StagingTableUDBv81)((StorageDesignUDBv81)storageDesign).getStagingTableSet().createStagingTable();
                    storageObject.setName(storageObject3.getName());
                    storageObject.setRawObject(true);
                    ((StagingTableUDB)storageObject).setTable(tableProxyUDBv81);
                    tableProxyUDBv81.addStagingTablesFromDesign(((StorageDesignUDBv81)storageDesign).getStagingTableSet());
                    continue;
                }
                ((StagingTableUDB)storageObject2).setTable(tableProxyUDBv81);
                tableProxyUDBv81.addStagingTablesFromDesign(((StorageDesignUDBv81)storageDesign).getStagingTableSet());
            }
            iterator = this.triggers.iterator();
            while (iterator.hasNext()) {
                storageObject3 = (TriggerUDBv81)iterator.next();
                storageObject2 = (TriggerUDBv81)((StorageDesignUDBv81)storageDesign).getTriggerSet().getByName(storageObject3.getName());
                if (storageObject2 == null) {
                    storageObject = (TriggerUDBv81)((StorageDesignUDBv81)storageDesign).getTriggerSet().createTrigger();
                    storageObject.setName(storageObject3.getName());
                    storageObject.setRawObject(true);
                    ((TriggerUDBv81)storageObject).setTable(tableProxyUDBv81);
                    tableProxyUDBv81.addTriggersFromDesign(((StorageDesignUDBv81)storageDesign).getTriggerSet());
                    continue;
                }
                ((TriggerUDBv81)storageObject2).setTable(tableProxyUDBv81);
                tableProxyUDBv81.addTriggersFromDesign(((StorageDesignUDBv81)storageDesign).getTriggerSet());
            }
            if (this.getSchema() != null) {
                storageObject3 = (SchemaUDBv81)((StorageDesignUDBv81)storageDesign).getSchemaSet().getByName(this.getSchema().getName());
                if (storageObject3 == null) {
                    storageObject2 = (SchemaUDBv81)((StorageDesignUDBv81)storageDesign).getSchemaSet().createSchema();
                    storageObject2.setName(this.getSchema().getName());
                    storageObject2.setRawObject(true);
                    tableProxyUDBv81.setSchema((SchemaUDB)storageObject2);
                } else {
                    tableProxyUDBv81.setSchema((SchemaUDB)storageObject3);
                }
            }
            tableProxyUDBv81.setPartKeyHashing(this.getPartKeyHashing());
            if (this.getTableSpace() != null) {
                storageObject3 = (TableSpaceUDBv81)((StorageDesignUDBv81)storageDesign).getTableSpaceSet().getByName(this.getTableSpace().getName());
                if (storageObject3 == null) {
                    storageObject2 = (TableSpaceUDBv81)((StorageDesignUDBv81)storageDesign).getTableSpaceSet().createTableSpace();
                    storageObject2.setName(this.getTableSpace().getName());
                    storageObject2.setRawObject(true);
                    tableProxyUDBv81.setTableSpace((TableSpaceUDB)storageObject2);
                } else {
                    tableProxyUDBv81.setTableSpace((TableSpaceUDB)storageObject3);
                }
            }
            if (this.getIndexInTableSpace() != null) {
                storageObject3 = (TableSpaceUDBv81)((StorageDesignUDBv81)storageDesign).getTableSpaceSet().getByName(this.getIndexInTableSpace().getName());
                if (storageObject3 == null) {
                    storageObject2 = (TableSpaceUDBv81)((StorageDesignUDBv81)storageDesign).getTableSpaceSet().createTableSpace();
                    storageObject2.setName(this.getIndexInTableSpace().getName());
                    storageObject2.setRawObject(true);
                    tableProxyUDBv81.setIndexInTableSpace((TableSpaceUDB)storageObject2);
                } else {
                    tableProxyUDBv81.setIndexInTableSpace((TableSpaceUDB)storageObject3);
                }
            }
            if (this.getLongInTableSpace() != null) {
                storageObject3 = (TableSpaceUDBv81)((StorageDesignUDBv81)storageDesign).getTableSpaceSet().getByName(this.getLongInTableSpace().getName());
                if (storageObject3 == null) {
                    storageObject2 = (TableSpaceUDBv81)((StorageDesignUDBv81)storageDesign).getTableSpaceSet().createTableSpace();
                    storageObject2.setName(this.getLongInTableSpace().getName());
                    storageObject2.setRawObject(true);
                    tableProxyUDBv81.setLongInTableSpace((TableSpaceUDB)storageObject2);
                } else {
                    tableProxyUDBv81.setLongInTableSpace((TableSpaceUDB)storageObject3);
                }
            }
            tableProxyUDBv81.setInitialLogging(this.getInitialLogging());
            tableProxyUDBv81.setDataCapture(this.getDataCapture());
            tableProxyUDBv81.setFederated(this.getFederated());
            tableProxyUDBv81.setSummaryQuery(this.getSummaryQuery());
            tableProxyUDBv81.setRestrictOnDrop(this.getRestrictOnDrop());
            tableProxyUDBv81.setValueCompression(this.getValueCompression());
            tableProxyUDBv81.recreateColumnListSet(this.getColumnSet().toString());
            tableProxyUDBv81.setSummaryQueryDefinition(this.getSummaryQueryDefinition());
            tableProxyUDBv81.setSummaryStatus(this.getSummaryStatus());
            tableProxyUDBv81.setSummaryMaintenance(this.getSummaryMaintenance());
            tableProxyUDBv81.setSummaryRefreshOptions(this.getSummaryRefreshOptions());
            tableProxyUDBv81.setSummaryQueryOptimization(this.getSummaryQueryOptimization());
            tableProxyUDBv81.setSummaryIdentityColumn(this.getSummaryIdentityColumn());
            tableProxyUDBv81.setSummaryCopyColumnDefaults(this.getSummaryCopyColumnDefaults());
            tableProxyUDBv81.setReplicated(this.getReplicated());
            tableProxyUDBv81.setUseRemoteOptions(this.getUseRemoteOptions());
            tableProxyUDBv81.setRoRemoteServer(this.getRoRemoteServer());
            tableProxyUDBv81.setRoRemoteSchema(this.getRoRemoteSchema());
            tableProxyUDBv81.setRoRemoteTabName(this.getRoRemoteTabName());
            tableProxyUDBv81.setOrganizeByDimensions(this.getOrganizeByDimensions());
            tableProxyUDBv81.setDimensions(this.getDimensions());
            tableProxyUDBv81.setComment(this.getComment());
            tableProxyUDBv81.setCommentInRDBMS(this.getCommentInRDBMS());
            tableProxyUDBv81.setRawObject(false);
        }
    }
}

