/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb.v81;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.SequenceUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.SchemaUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.udb.v81.SequencePropertyDialogUDBv81;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class SequenceUDBv81
extends SequenceUDB
implements PropertiesPropagator {
    private String usedByPublic = "NO";
    public static final String YES = "YES";
    public static final String NO = "NO";
    public static final String[] YES_NO_STATES = new String[]{"YES", "NO"};
    private static Set yesNoSet = null;
    private List propertyWrapperList = null;

    public static String[] getYesNoChoices() {
        return YES_NO_STATES;
    }

    @Override
    protected boolean checkYesNo(String string) {
        if (yesNoSet == null) {
            yesNoSet = new HashSet();
            yesNoSet.addAll(Arrays.asList(SequenceUDBv81.getYesNoChoices()));
        }
        return yesNoSet.contains(string);
    }

    public String getUsedByPublic() {
        return this.usedByPublic;
    }

    public void setUsedByPublic(String string) {
        if (this.checkYesNo(string)) {
            this.usedByPublic = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            SequencePropertyDialogUDBv81 sequencePropertyDialogUDBv81 = new SequencePropertyDialogUDBv81(this.getDesign().getAppView(), this.getStorageDesign(), this);
            sequencePropertyDialogUDBv81.show();
        }
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper("Schema", this, "getSchema", "setSchema", SchemaUDB.class));
            this.propertyWrapperList.add(new PropertyWrapper("DataType", this, "getDatatype", "setDatatype", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Start with", this, "getStartWith", "setStartWith", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Increment By", this, "getIncrementBy", "setIncrementBy", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Min Value", this, "getMinValue", "setMinValue", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Max Value", this, "getMaxValue", "setMaxValue", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Cycle", this, "getCycle", "setCycle", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Cache", this, "getCache", "setCache", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Order", this, "getOrder", "setOrder", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Used By Public", this, "getUsedByPublic", "setUsedByPublic", String.class));
        }
        return this.propertyWrapperList;
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        SequenceUDBv81 sequenceUDBv81 = null;
        StorageObject storageObject = (StorageObject)((StorageDesignUDBv81)storageDesign).getSequenceSet().getByName(this.getName());
        if (storageObject != null) {
            if (this.isRawObject()) {
                sequenceUDBv81 = (SequenceUDBv81)storageObject;
            }
        } else {
            sequenceUDBv81 = (SequenceUDBv81)((StorageDesignUDBv81)storageDesign).getSequenceSet().createSequence();
        }
        if (sequenceUDBv81 != null) {
            sequenceUDBv81.setName(this.getName());
            if (this.getSchema() != null) {
                SchemaUDBv81 schemaUDBv81 = (SchemaUDBv81)((StorageDesignUDBv81)storageDesign).getSchemaSet().getByName(this.getSchema().getName());
                if (schemaUDBv81 == null) {
                    SchemaUDBv81 schemaUDBv812 = (SchemaUDBv81)((StorageDesignUDBv81)storageDesign).getSchemaSet().createSchema();
                    schemaUDBv812.setName(this.getSchema().getName());
                    schemaUDBv812.setRawObject(true);
                    sequenceUDBv81.setSchema(schemaUDBv812);
                    sequenceUDBv81.setOwner(schemaUDBv812.getOwner());
                } else {
                    sequenceUDBv81.setSchema(schemaUDBv81);
                    sequenceUDBv81.setOwner(schemaUDBv81.getOwner());
                }
            }
            sequenceUDBv81.setDatatype(this.getDatatype());
            sequenceUDBv81.setStartWith(this.getStartWith());
            sequenceUDBv81.setIncrementBy(this.getIncrementBy());
            sequenceUDBv81.setMinValue(this.getMinValue());
            sequenceUDBv81.setMaxValue(this.getMaxValue());
            sequenceUDBv81.setCycle(this.getCycle());
            sequenceUDBv81.setCache(this.getCache());
            sequenceUDBv81.setOrder(this.getOrder());
            sequenceUDBv81.setUsedByPublic(this.getUsedByPublic());
            sequenceUDBv81.setComment(this.getComment());
        }
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("SEQUENCE_ICON", 16);
    }
}

