/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb.v81;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.IndexProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.SchemaUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.swingui.editor.storage.udb.v81.IndexPropertyDialogUDBv81;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class IndexProxyUDBv81
extends IndexProxyUDB
implements PropertiesPropagator {
    protected String collectStatistics = "NONE";
    public static final String NONE = "NONE";
    public static final String BASIC = "BASIC";
    public static final String DETAILED = "DETAILED";
    public static final String SAMPLED_DETAILED = "SAMPLED DETAILED";
    public static final String[] COLLECT_STATISTICS_STATES = new String[]{"NONE", "BASIC", "DETAILED", "SAMPLED DETAILED"};
    private static Set collectStatisticsSet = null;
    private List propertyWrapperList = null;

    public IndexProxyUDBv81(Index index, StorageDesign storageDesign) {
        super(index, storageDesign);
    }

    public IndexProxyUDBv81(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
    }

    protected boolean checkCollectStatistics(String string) {
        if (collectStatisticsSet == null) {
            collectStatisticsSet = new HashSet();
            collectStatisticsSet.addAll(Arrays.asList(COLLECT_STATISTICS_STATES));
        }
        return collectStatisticsSet.contains(string);
    }

    public String getCollectStatistics() {
        return this.collectStatistics;
    }

    public void setCollectStatistics(String string) {
        if (this.checkCollectStatistics(string)) {
            this.collectStatistics = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            IndexPropertyDialogUDBv81 indexPropertyDialogUDBv81 = new IndexPropertyDialogUDBv81(this.getDesign().getAppView(), this.getStorageDesign(), this);
            indexPropertyDialogUDBv81.show();
        }
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper("Schema", this, "getSchema", "setSchema", SchemaUDB.class));
            this.propertyWrapperList.add(new PropertyWrapper("Cluster", this, "getCluster", "setCluster", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("PCTFREE", this, "getPercentageFree", "setPercentageFree", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Min % Used", this, "getMinimumPercentageUsed", "setMinimumPercentageUsed", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Reverse Scan", this, "getReverseScanSupport", "setReverseScanSupport", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Collect Statistics", this, "getCollectStatistics", "setCollectStatistics", String.class));
        }
        return this.propertyWrapperList;
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        Index index = (Index)storageDesign.getPhysicalDesign().getTableSet().getGlobalIndexSet().getByName(this.getName());
        IndexProxyUDBv81 indexProxyUDBv81 = null;
        RelationalObjectProxy relationalObjectProxy = ((StorageDesignUDBv81)storageDesign).getIndexProxySet().getProxy(index.getObjectID());
        if (relationalObjectProxy != null && !this.isRawObject()) {
            indexProxyUDBv81 = (IndexProxyUDBv81)relationalObjectProxy;
        }
        if (indexProxyUDBv81 != null) {
            indexProxyUDBv81.setName(this.getName());
            if (this.getSchema() != null) {
                SchemaUDBv81 schemaUDBv81 = (SchemaUDBv81)((StorageDesignUDBv81)storageDesign).getSchemaSet().getByName(this.getSchema().getName());
                if (schemaUDBv81 == null) {
                    SchemaUDBv81 schemaUDBv812 = (SchemaUDBv81)((StorageDesignUDBv81)storageDesign).getSchemaSet().createSchema();
                    schemaUDBv812.setName(this.getSchema().getName());
                    schemaUDBv812.setRawObject(true);
                    indexProxyUDBv81.setSchema(schemaUDBv812);
                } else {
                    indexProxyUDBv81.setSchema(schemaUDBv81);
                }
            }
            indexProxyUDBv81.setCluster(this.getCluster());
            indexProxyUDBv81.setPercentageFree(this.getPercentageFree());
            indexProxyUDBv81.setMinimumPercentageUsed(this.getMinimumPercentageUsed());
            indexProxyUDBv81.setReverseScanSupport(this.getReverseScanSupport());
            indexProxyUDBv81.setCollectStatistics(this.getCollectStatistics());
            indexProxyUDBv81.recreateColumnListSet(this.getColumnSet().toString());
            indexProxyUDBv81.recreateUserGroupSet(this.getUserGroupSet().toString());
            indexProxyUDBv81.recreateUserSet(this.getUserSet().toString());
            indexProxyUDBv81.setComment(this.getComment());
            indexProxyUDBv81.setCommentInRDBMS(this.getCommentInRDBMS());
            indexProxyUDBv81.setRawObject(false);
        }
    }
}

