/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb.v81;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.DataBaseUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageObjectConstantsUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableSpaceUDBv81;
import oracle.dbtools.crest.swingui.editor.storage.udb.v81.DatabasePropertyDialogUDBv81;

public class DataBaseUDBv81
extends DataBaseUDB {
    public static final String NLSCHAR = "NLSCHAR";
    public static final String DB_ONLY = "DB ONLY";
    public static final String DB_AND_DBM = "DB AND DBM";
    public static final String NONE = "NONE";
    public static final String SIMPLE = "SIMPLE";
    public static final String MIXED = "MIXED";
    public static final String COMPLEX = "COMPLEX";
    public static final String PERFORMANCE = "PERFORMANCE";
    public static final String RECOVERY = "RECOVERY";
    public static final String BOTH = "BOTH";
    public static final String RR = "RR";
    public static final String RS = "RS";
    public static final String CS = "CS";
    public static final String UR = "UR";
    public static final String MEM_PERCENT = "mem_percent";
    public static final String WORKLOAD_TYPE = "workload_type";
    public static final String NUM_STMTS = "num_stmts";
    public static final String TPM = "tpm";
    public static final String ADMIN_PROPERTY = "admin_property";
    public static final String NUM_LOCAL_APPS = "num_local_apps";
    public static final String NUM_REMOTE_APPS = "num_remote_apps";
    public static final String ISOLATION = "isolation";
    public static final String BP_RESIZEABLE = "bp_resizeable";
    protected static String[] collatingSequencesChoices = new String[]{"", "COMPATIBILITY", "SYSTEM", "IDENTITY", "NLSCHAR"};
    protected static String[] applyChangesChoices = new String[]{"", "DB ONLY", "DB AND DBM", "NONE"};
    private static Set collatingSequencesSet = null;
    private static Set applyChangeSet = null;
    protected boolean autoConfigure = false;
    protected String applyChanges = "";
    protected int memPercent = 25;
    protected String workloadType = "MIXED";
    protected int numStmts = 25;
    protected int tpm = 60;
    protected String adminProperty = "BOTH";
    protected int numLocalApps = 0;
    protected int numRemoteApps = 100;
    protected String isolation = "RR";
    protected String bpResizeable = "YES";
    protected boolean useMemPercent = false;
    protected boolean useWorkloadType = false;
    protected boolean useNumStmts = false;
    protected boolean useTpm = false;
    protected boolean useAdminProperty = false;
    protected boolean useNumLocalApps = false;
    protected boolean useNumRemoteApps = false;
    protected boolean useIsolation = false;
    protected boolean useBpResizeable = false;
    protected static String[] workloadTypeChoices = new String[]{"SIMPLE", "MIXED", "COMPLEX"};
    protected static String[] adminPropertyChoices = new String[]{"PERFORMANCE", "RECOVERY", "BOTH"};
    protected static String[] isolationChoices = new String[]{"RR", "RS", "CS", "UR"};
    private static Set workloadTypeSet = null;
    private static Set adminPropertySet = null;
    private static Set isolationSet = null;

    public static String[] getAvailableCollatingSequences() {
        return collatingSequencesChoices;
    }

    public boolean getAutoConfigure() {
        return this.autoConfigure;
    }

    public void setAutoConfigure(boolean bl) {
        this.autoConfigure = bl;
    }

    protected boolean checkWorkloadType(String string) {
        if (workloadTypeSet == null) {
            workloadTypeSet = new HashSet();
            workloadTypeSet.addAll(Arrays.asList(workloadTypeChoices));
        }
        return workloadTypeSet.contains(string);
    }

    protected boolean checkAdminProperty(String string) {
        if (adminPropertySet == null) {
            adminPropertySet = new HashSet();
            adminPropertySet.addAll(Arrays.asList(adminPropertyChoices));
        }
        return adminPropertySet.contains(string);
    }

    protected boolean checkIsolationType(String string) {
        if (isolationSet == null) {
            isolationSet = new HashSet();
            isolationSet.addAll(Arrays.asList(isolationChoices));
        }
        return isolationSet.contains(string);
    }

    protected boolean checkCollatingSequences(String string) {
        if (collatingSequencesSet == null) {
            collatingSequencesSet = new HashSet();
            collatingSequencesSet.addAll(Arrays.asList(collatingSequencesChoices));
        }
        return collatingSequencesSet.contains(string);
    }

    protected boolean checkApplyChange(String string) {
        if (applyChangeSet == null) {
            applyChangeSet = new HashSet();
            applyChangeSet.addAll(Arrays.asList(applyChangesChoices));
        }
        return applyChangeSet.contains(string);
    }

    public String getAdminProperty() {
        return this.adminProperty;
    }

    public void setAdminProperty(String string) {
        if (this.checkAdminProperty(string)) {
            this.adminProperty = string;
            this.fireDataFieldChange();
        }
    }

    public String getBpResizeable() {
        return this.bpResizeable;
    }

    public void setBpResizeable(String string) {
        if (StorageObjectConstantsUDB.checkYesNo(string)) {
            this.bpResizeable = string;
            this.fireDataFieldChange();
        }
    }

    public String getIsolation() {
        return this.isolation;
    }

    public void setIsolation(String string) {
        if (this.checkIsolationType(string)) {
            this.isolation = string;
            this.fireDataFieldChange();
        }
    }

    public int getMemPercent() {
        return this.memPercent;
    }

    public void setMemPercent(int n) {
        if (n >= 1 && n <= 100) {
            this.memPercent = n;
        }
    }

    public int getNumLocalApps() {
        return this.numLocalApps;
    }

    public void setNumLocalApps(int n) {
        if (n >= 0 && n <= 5000) {
            this.numLocalApps = n;
        }
    }

    public int getNumRemoteApps() {
        return this.numRemoteApps;
    }

    public void setNumRemoteApps(int n) {
        if (n >= 0 && n <= 5000) {
            this.numRemoteApps = n;
        }
    }

    public int getNumStmts() {
        return this.numStmts;
    }

    public void setNumStmts(int n) {
        if (n >= 1 && n <= 1000000) {
            this.numStmts = n;
        }
    }

    public int getTpm() {
        return this.tpm;
    }

    public void setTpm(int n) {
        if (n >= 1 && n <= 50000) {
            this.tpm = n;
        }
    }

    public String getWorkloadType() {
        return this.workloadType;
    }

    public void setWorkloadType(String string) {
        if (this.checkWorkloadType(string)) {
            this.workloadType = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            DatabasePropertyDialogUDBv81 databasePropertyDialogUDBv81 = new DatabasePropertyDialogUDBv81(this.getDesign().getAppView(), this.getStorageDesign(), this);
            databasePropertyDialogUDBv81.show();
        }
    }

    public String getApplyChanges() {
        return this.applyChanges;
    }

    public void setApplyChanges(String string) {
        if (this.checkApplyChange(string)) {
            this.applyChanges = string;
            this.fireDataFieldChange();
        }
    }

    public static String[] getAdminPropertyChoices() {
        return adminPropertyChoices;
    }

    public static String[] getApplyChangesChoices() {
        return applyChangesChoices;
    }

    public static String[] getCollatingSequencesChoices() {
        return collatingSequencesChoices;
    }

    public static String[] getIsolationChoices() {
        return isolationChoices;
    }

    public static String[] getWorkloadTypeChoices() {
        return workloadTypeChoices;
    }

    public boolean getUseAdminProperty() {
        return this.useAdminProperty;
    }

    public void setUseAdminProperty(boolean bl) {
        this.useAdminProperty = bl;
    }

    public boolean getUseBpResizeable() {
        return this.useBpResizeable;
    }

    public void setUseBpResizeable(boolean bl) {
        this.useBpResizeable = bl;
    }

    public boolean getUseIsolation() {
        return this.useIsolation;
    }

    public void setUseIsolation(boolean bl) {
        this.useIsolation = bl;
    }

    public boolean getUseMemPercent() {
        return this.useMemPercent;
    }

    public void setUseMemPercent(boolean bl) {
        this.useMemPercent = bl;
    }

    public boolean getUseNumLocalApps() {
        return this.useNumLocalApps;
    }

    public void setUseNumLocalApps(boolean bl) {
        this.useNumLocalApps = bl;
    }

    public boolean getUseNumRemoteApps() {
        return this.useNumRemoteApps;
    }

    public void setUseNumRemoteApps(boolean bl) {
        this.useNumRemoteApps = bl;
    }

    public boolean getUseNumStmts() {
        return this.useNumStmts;
    }

    public void setUseNumStmts(boolean bl) {
        this.useNumStmts = bl;
    }

    public boolean getUseTpm() {
        return this.useTpm;
    }

    public void setUseTpm(boolean bl) {
        this.useTpm = bl;
    }

    public boolean getUseWorkloadType() {
        return this.useWorkloadType;
    }

    public void setUseWorkloadType(boolean bl) {
        this.useWorkloadType = bl;
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        DataBaseUDBv81 dataBaseUDBv81 = null;
        StorageObject storageObject = (StorageObject)((StorageDesignUDBv81)storageDesign).getDataBaseSet().getByName(this.getName());
        if (storageObject != null) {
            if (this.isRawObject()) {
                dataBaseUDBv81 = (DataBaseUDBv81)storageObject;
            }
        } else {
            dataBaseUDBv81 = (DataBaseUDBv81)((StorageDesignUDBv81)storageDesign).getDataBaseSet().createDataBase();
        }
        if (dataBaseUDBv81 != null) {
            TableSpaceUDBv81 tableSpaceUDBv81;
            TableSpaceUDBv81 tableSpaceUDBv812;
            dataBaseUDBv81.setName(this.getName());
            dataBaseUDBv81.setOnPath(this.getOnPath());
            dataBaseUDBv81.setAlias(this.getAlias());
            dataBaseUDBv81.setCodeSet(this.getCodeSet());
            dataBaseUDBv81.setTerritory(this.getTerritory());
            dataBaseUDBv81.setCollatingSequence(this.getCollatingSequence());
            dataBaseUDBv81.setSegmentNumber(this.getSegmentNumber());
            dataBaseUDBv81.setDefaultExtentSize(this.getDefaultExtentSize());
            if (this.getCatalogTableSpace() != null) {
                tableSpaceUDBv812 = (TableSpaceUDBv81)((StorageDesignUDBv81)storageDesign).getTableSpaceSet().getByName(this.getCatalogTableSpace().getName());
                if (tableSpaceUDBv812 == null) {
                    tableSpaceUDBv81 = (TableSpaceUDBv81)((StorageDesignUDBv81)storageDesign).getTableSpaceSet().createTableSpace();
                    tableSpaceUDBv81.setName(this.getCatalogTableSpace().getName());
                    tableSpaceUDBv81.setRawObject(true);
                    dataBaseUDBv81.setCatalogTableSpace(tableSpaceUDBv81);
                } else {
                    dataBaseUDBv81.setCatalogTableSpace(tableSpaceUDBv812);
                }
            }
            if (this.getUserTableSpace() != null) {
                tableSpaceUDBv812 = (TableSpaceUDBv81)((StorageDesignUDBv81)storageDesign).getTableSpaceSet().getByName(this.getUserTableSpace().getName());
                if (tableSpaceUDBv812 == null) {
                    tableSpaceUDBv81 = (TableSpaceUDBv81)((StorageDesignUDBv81)storageDesign).getTableSpaceSet().createTableSpace();
                    tableSpaceUDBv81.setName(this.getUserTableSpace().getName());
                    tableSpaceUDBv81.setRawObject(true);
                    dataBaseUDBv81.setUserTableSpace(tableSpaceUDBv81);
                } else {
                    dataBaseUDBv81.setUserTableSpace(tableSpaceUDBv812);
                }
            }
            if (this.getTemporaryTableSpace() != null) {
                tableSpaceUDBv812 = (TableSpaceUDBv81)((StorageDesignUDBv81)storageDesign).getTableSpaceSet().getByName(this.getTemporaryTableSpace().getName());
                if (tableSpaceUDBv812 == null) {
                    tableSpaceUDBv81 = (TableSpaceUDBv81)((StorageDesignUDBv81)storageDesign).getTableSpaceSet().createTableSpace();
                    tableSpaceUDBv81.setName(this.getTemporaryTableSpace().getName());
                    tableSpaceUDBv81.setRawObject(true);
                    dataBaseUDBv81.setTemporaryTableSpace(tableSpaceUDBv81);
                } else {
                    dataBaseUDBv81.setTemporaryTableSpace(tableSpaceUDBv812);
                }
            }
            dataBaseUDBv81.setAutoConfigure(this.getAutoConfigure());
            dataBaseUDBv81.setApplyChanges(this.getApplyChanges());
            if (this.getAutoConfigure()) {
                dataBaseUDBv81.setUseMemPercent(this.getUseMemPercent());
                dataBaseUDBv81.setUseWorkloadType(this.getUseWorkloadType());
                dataBaseUDBv81.setUseNumStmts(this.getUseNumStmts());
                dataBaseUDBv81.setUseTpm(this.getUseTpm());
                dataBaseUDBv81.setUseAdminProperty(this.getUseAdminProperty());
                dataBaseUDBv81.setUseNumLocalApps(this.getUseNumLocalApps());
                dataBaseUDBv81.setUseNumRemoteApps(this.getUseNumRemoteApps());
                dataBaseUDBv81.setUseIsolation(this.getUseIsolation());
                dataBaseUDBv81.setUseBpResizeable(this.getUseBpResizeable());
            }
            dataBaseUDBv81.setComment(this.getComment());
            dataBaseUDBv81.setRawObject(false);
        }
    }
}

