/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb.v81;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.ColumnProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageObjectConstantsUDB;
import oracle.dbtools.crest.swingui.editor.storage.udb.v81.ColumnPropertyDialogUDBv81;

public class ColumnProxyUDBv81
extends ColumnProxyUDB {
    protected String compressSystemDefault = "NO";
    protected String maxValue = "";
    protected String minValue = "";
    protected String cycle = "NO";
    protected String order = "NO";
    protected static final String[] WRITE_PERMISSION = new String[]{"FS", "BLOCKED", "ADMIN REQUIRING TOKEN FOR UPDATE", "ADMIN NOT REQUIRING TOKEN FOR UPDATE"};
    protected static List writePermissionList = Arrays.asList(WRITE_PERMISSION);
    protected static Set writePermissionSet = null;
    private String validation = "ENFORCED";
    private String queryOptimization = "ENABLE";
    public static final String ENFORCED = "ENFORCED";
    public static final String NOT_ENFORCED = "NOT ENFORCED";
    public static final String ENABLE = "ENABLE";
    public static final String DISABLE = "DISABLE";
    public static String[] validationChoices = new String[]{"ENFORCED", "NOT ENFORCED"};
    private static Set validationSet = null;
    public static String[] queryOptimizationChoices = new String[]{"ENABLE", "DISABLE"};
    private static Set queryOptimizationSet = null;
    private boolean orderChanged;

    public ColumnProxyUDBv81(Column column, StorageDesign storageDesign) {
        super(column, storageDesign);
    }

    public ColumnProxyUDBv81(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
    }

    public String getCompressSystemDefault() {
        return this.compressSystemDefault;
    }

    public void setCompressSystemDefault(String string) {
        if (StorageObjectConstantsUDB.checkYesNo(string)) {
            this.compressSystemDefault = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ColumnPropertyDialogUDBv81 columnPropertyDialogUDBv81 = new ColumnPropertyDialogUDBv81(this.getDesign().getAppView(), this.getStorageDesign(), this);
            columnPropertyDialogUDBv81.show();
        }
    }

    public String getCycle() {
        if (!this.isCycleChanged()) {
            boolean bl = this.getColumn().isAutoIncrementCycle();
            return bl ? "YES" : "NO";
        }
        return this.cycle;
    }

    public void setCycle(String string) {
        if (StorageObjectConstantsUDB.checkYesNo(string)) {
            this.cycle = string;
            this.fireDataFieldChange();
        }
    }

    public String getMaxValue() {
        if (!this.isMaxValueChanged()) {
            String string = this.getColumn().getAutoIncrementMaxValue();
            return string == null ? "" : string;
        }
        return this.maxValue;
    }

    public void setMaxValue(String string) {
        this.maxValue = string;
        this.fireDataFieldChange();
    }

    public String getMinValue() {
        if (!this.isMinValueChanged()) {
            String string = this.getColumn().getAutoIncrementMinValue();
            return string == null ? "" : string;
        }
        return this.minValue;
    }

    public void setMinValue(String string) {
        this.minValue = string;
        this.fireDataFieldChange();
    }

    public String getOrder() {
        if (!this.orderChanged) {
            boolean bl = this.getColumn().isAutoIncrementOrder();
            return bl ? "YES" : "NO";
        }
        return this.order;
    }

    public void setOrder(String string) {
        if (StorageObjectConstantsUDB.checkYesNo(string)) {
            this.order = string;
            this.fireDataFieldChange();
        }
    }

    public static String[] getWritePermissionChoices() {
        return WRITE_PERMISSION;
    }

    @Override
    protected boolean checkWritePermission(String string) {
        if (writePermissionSet == null) {
            writePermissionSet = new HashSet();
            writePermissionSet.addAll(Arrays.asList(ColumnProxyUDBv81.getWritePermissionChoices()));
        }
        return writePermissionSet.contains(string);
    }

    protected boolean checkValidation(String string) {
        if (validationSet == null) {
            validationSet = new HashSet();
            validationSet.addAll(Arrays.asList(validationChoices));
        }
        return validationSet.contains(string);
    }

    protected boolean checkQueryOptimization(String string) {
        if (queryOptimizationSet == null) {
            queryOptimizationSet = new HashSet();
            queryOptimizationSet.addAll(Arrays.asList(queryOptimizationChoices));
        }
        return queryOptimizationSet.contains(string);
    }

    public String getQueryOptimization() {
        return this.queryOptimization;
    }

    public void setQueryOptimization(String string) {
        if (this.checkQueryOptimization(string)) {
            this.queryOptimization = string;
            this.fireDataFieldChange();
        }
    }

    public String getValidation() {
        return this.validation;
    }

    public void setValidation(String string) {
        if (this.checkValidation(string)) {
            this.validation = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public int getMaxNameLength() {
        return 128;
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        Column column = (Column)storageDesign.getPhysicalDesign().getColumnSet().getByName(this.getObject().getName());
        ColumnProxyUDBv81 columnProxyUDBv81 = null;
        RelationalObjectProxy relationalObjectProxy = storageDesign.getColumnProxySet().getProxy(column.getObjectID());
        if (relationalObjectProxy != null && !this.isRawObject()) {
            columnProxyUDBv81 = (ColumnProxyUDBv81)relationalObjectProxy;
        }
        if (columnProxyUDBv81 != null) {
            columnProxyUDBv81.setName(this.getName());
            columnProxyUDBv81.setDefault(this.getDefault());
            columnProxyUDBv81.setDefaultValue(this.getDefaultValue());
            columnProxyUDBv81.setDefaultValueConstant(this.getDefaultValueConstant());
            columnProxyUDBv81.setForBitData(this.isForBitData());
            columnProxyUDBv81.setCompressSystemDefault(this.getCompressSystemDefault());
            columnProxyUDBv81.setLinkControl(this.getLinkControl());
            columnProxyUDBv81.setReadPermission(this.getReadPermission());
            columnProxyUDBv81.setWritePermission(this.getWritePermission());
            columnProxyUDBv81.setRecovery(this.getRecovery());
            columnProxyUDBv81.setOnUnlink(this.getOnUnlink());
            columnProxyUDBv81.setLogging(this.getLogging());
            columnProxyUDBv81.setCompact(this.getCompact());
            columnProxyUDBv81.setUseIdentity(this.getUseIdentity());
            columnProxyUDBv81.setUseIdentityChanged(this.isUseIdentityChanged());
            columnProxyUDBv81.setGenerate(this.getGenerate());
            columnProxyUDBv81.setStartWith(this.getStartWith());
            columnProxyUDBv81.setIncrementBy(this.getIncrementBy());
            columnProxyUDBv81.setMaxValue(this.getMaxValue());
            columnProxyUDBv81.setMinValue(this.getMinValue());
            columnProxyUDBv81.setCycle(this.getCycle());
            columnProxyUDBv81.setCache(this.getCache());
            columnProxyUDBv81.setOrder(this.getOrder());
            columnProxyUDBv81.setGenerationExpression(this.getGenerationExpression());
            columnProxyUDBv81.setGenerationExpressionChanged(this.isGenerationExpressionChanged());
            columnProxyUDBv81.setComment(this.getComment());
            columnProxyUDBv81.setCommentInRDBMS(this.getCommentInRDBMS());
            columnProxyUDBv81.setRawObject(false);
        }
    }

    public boolean isOrderChanged() {
        return this.orderChanged;
    }

    public void setOrderChanged(boolean bl) {
        this.orderChanged = bl;
    }
}

