/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageObjectDB2;
import oracle.dbtools.crest.model.design.storage.udb.BufferPoolUDB;
import oracle.dbtools.crest.model.design.storage.udb.ContainerSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.ContainerUDB;
import oracle.dbtools.crest.model.design.storage.udb.DataBaseUDB;
import oracle.dbtools.crest.model.design.storage.udb.NodeGroupUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.udb.TableSpacePropertyDialogUDB;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class TableSpaceUDB
extends AbstractStorageObjectDB2
implements StorageObjectListener,
ModelObjectSetListener,
PropertiesPropagator {
    public static final String SYSTEM = "SYSTEM";
    public static final String DATABASE = "DATABASE";
    public static final String DATATYPE_REGULAR = "REGULAR";
    public static final String DATATYPE_LONG = "LONG";
    public static final String DATATYPE_SYSTEM_TEMP = "SYSTEM TEMPORARY";
    public static final String DATATYPE_USER_TEMP = "USER TEMPORARY";
    private static String[] availableManagedByTypes = new String[]{"SYSTEM", "DATABASE"};
    protected static String[] availableDataTypes = new String[]{"REGULAR", "LONG", "SYSTEM TEMPORARY", "USER TEMPORARY"};
    private static Object[] availablePageSizes = new Object[]{new Integer(4), new Integer(8), new Integer(16), new Integer(32)};
    private boolean dbDefOnly = false;
    private String managedBy = "SYSTEM";
    private String dataType = "REGULAR";
    private NodeGroupUDB nodegroup = null;
    private int pageSize = 4;
    private String extentSize = "";
    protected String prefetchSize = "";
    private BufferPoolUDB bufferPool = null;
    private float overhead = 0.0f;
    private float tranferRate = 0.0f;
    private boolean droppedTableRecovery = false;
    private String users = "";
    private UserSet userSet = null;
    private String userGroups = "";
    private UserSet userGroupSet = null;
    private String grantOption = "NO";
    public static final String YES = "YES";
    public static final String NO = "NO";
    public static final String[] YES_NO_STATES = new String[]{"YES", "NO"};
    private static Set yesNoSet = null;
    private StorageObjectCollection containers;
    private List propertyWrapperList = null;
    public static final String TYPE_NAME = "TableSpace";

    public TableSpaceUDB(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
        this.containers = new StorageObjectCollection(((StorageDesignUDB)storageDesign).getContainerSet());
        this.containers.setParent(this);
        this.containers.setName(Messages.getString("TableSpaceUDB.Containers"));
        this.containers.setSetMethod("setTableSpace");
        this.containers.setClassForParent(TableSpaceUDB.class);
        this.containers.setIcon(GUIConfiguration.getInstance().getIcon("CONTAINER_ICON", 16));
        ((StorageDesignUDB)storageDesign).getContainerSet().addSetListener(this);
        this.addContainersFromDesign(((StorageDesignUDB)storageDesign).getContainerSet());
    }

    public void addContainersFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            ContainerUDB containerUDB = (ContainerUDB)iterator.next();
            if (containerUDB.getTableSpace() != null && containerUDB.getTableSpace() == this) {
                containerUDB.setParent(this.containers);
                if (this.containers.contains(containerUDB)) continue;
                this.containers.add(containerUDB);
                continue;
            }
            this.containers.remove(containerUDB);
        }
    }

    @Override
    public String getIDPrefix() {
        return "TS";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public void setDBDefOnly(boolean bl) {
        this.dbDefOnly = bl;
    }

    public boolean getDBDefOnly() {
        return this.dbDefOnly;
    }

    public static String[] getAvailableDataTypes() {
        return availableDataTypes;
    }

    public void setDataType(String string) {
        this.dataType = string;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setNodeGroup(NodeGroupUDB nodeGroupUDB) {
        this.nodegroup = nodeGroupUDB;
        this.fireDataFieldChange();
    }

    public NodeGroupUDB getNodeGroup() {
        return this.nodegroup;
    }

    public static Object[] getAvailablePageSizes() {
        return availablePageSizes;
    }

    public void setPageSize(int n) {
        this.pageSize = n;
    }

    public void setPageSize(Integer n) {
        this.setPageSize((int)n);
    }

    public Integer getPageSize() {
        return new Integer(this.pageSize);
    }

    public void setExtentSize(String string) {
        this.extentSize = string;
    }

    public String getExtentSize() {
        return this.extentSize;
    }

    public void setPrefetchSize(String string) {
        if (this.checkPrefetchSize(string)) {
            this.prefetchSize = string;
        }
    }

    public String getPrefetchSize() {
        return this.prefetchSize;
    }

    protected boolean checkPrefetchSize(String string) {
        if ("".equalsIgnoreCase(string)) {
            return true;
        }
        try {
            if (Integer.parseInt(string) > 1) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    public void setBufferPool(BufferPoolUDB bufferPoolUDB) {
        this.bufferPool = bufferPoolUDB;
        this.fireDataFieldChange();
    }

    public BufferPoolUDB getBufferPool() {
        return this.bufferPool;
    }

    public void setOverhead(float f) {
        this.overhead = f;
    }

    public float getOverhead() {
        return this.overhead;
    }

    public void setTransferRate(float f) {
        this.tranferRate = f;
    }

    public float getTransferRate() {
        return this.tranferRate;
    }

    public void setDroppedTableRecovery(boolean bl) {
        this.droppedTableRecovery = bl;
    }

    public boolean getDroppedTableRecovery() {
        return this.droppedTableRecovery;
    }

    public ContainerUDB[] getContainers() {
        ContainerSetUDB containerSetUDB = ((StorageDesignUDB)this.getStorageDesign()).getContainerSet();
        return containerSetUDB.getContainersFor(this);
    }

    public ContainerUDB[] getContainersForNode(String string) {
        ContainerUDB[] containerUDBArray = this.getContainers();
        ArrayList<ContainerUDB> arrayList = new ArrayList<ContainerUDB>();
        for (int i = 0; i < containerUDBArray.length; ++i) {
            if (!containerUDBArray[i].getOnNodes().equalsIgnoreCase(string)) continue;
            arrayList.add(containerUDBArray[i]);
        }
        return arrayList.toArray(new ContainerUDB[0]);
    }

    public List getAllNodes() {
        ContainerUDB[] containerUDBArray = this.getContainers();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < containerUDBArray.length; ++i) {
            if (arrayList.contains(containerUDBArray[i].getOnNodes())) continue;
            arrayList.add(containerUDBArray[i].getOnNodes());
        }
        return arrayList;
    }

    public TableProxyUDB[] getTableProxies() {
        ArrayList<TableProxyUDB> arrayList = new ArrayList<TableProxyUDB>();
        StorageDesignUDB storageDesignUDB = (StorageDesignUDB)this.getStorageDesign();
        RelationalObjectProxy[] relationalObjectProxyArray = (RelationalObjectProxy[])storageDesignUDB.getTableProxySet().toArray();
        for (int i = 0; i < relationalObjectProxyArray.length; ++i) {
            TableProxyUDB tableProxyUDB = (TableProxyUDB)relationalObjectProxyArray[i];
            if (tableProxyUDB.getTableSpace() == null || !tableProxyUDB.getTableSpace().equals(this)) continue;
            arrayList.add(tableProxyUDB);
        }
        return arrayList.toArray(new TableProxyUDB[0]);
    }

    public boolean usedForDataBaseCreation() {
        StorageDesignUDB storageDesignUDB = (StorageDesignUDB)this.getStorageDesign();
        DataBaseUDB[] dataBaseUDBArray = (DataBaseUDB[])storageDesignUDB.getDataBaseSet().toArray();
        for (int i = 0; i < dataBaseUDBArray.length; ++i) {
            if (dataBaseUDBArray[i].getCatalogTableSpace() != null && dataBaseUDBArray[i].getCatalogTableSpace().equals(this)) {
                return true;
            }
            if (dataBaseUDBArray[i].getTemporaryTableSpace() != null && dataBaseUDBArray[i].getTemporaryTableSpace().equals(this)) {
                return true;
            }
            if (dataBaseUDBArray[i].getUserTableSpace() == null || !dataBaseUDBArray[i].getUserTableSpace().equals(this)) continue;
            return true;
        }
        return false;
    }

    public void setManagedBy(String string) {
        this.managedBy = string;
    }

    public String getManagedBy() {
        return this.managedBy;
    }

    public static Object[] getAvailableManagedByTypes() {
        return availableManagedByTypes;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TableSpacePropertyDialogUDB tableSpacePropertyDialogUDB = new TableSpacePropertyDialogUDB(this.getDesign().getAppView(), this.getStorageDesign(), this);
            tableSpacePropertyDialogUDB.show();
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.containers;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.containers) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.containers) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof ContainerUDB) {
            ContainerUDB containerUDB = (ContainerUDB)objectChangeEvent.getAffected();
            if (containerUDB.getTableSpace() != null && containerUDB.getTableSpace() == this) {
                containerUDB.setParent(this.containers);
                this.containers.add(containerUDB);
            } else {
                this.containers.remove(containerUDB);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof ContainerUDB) {
                ContainerUDB containerUDB = (ContainerUDB)modelObjectSetEvent.getAffected();
                containerUDB.addObjectListener(this);
                if (containerUDB.getTableSpace() != null && containerUDB.getTableSpace() == this) {
                    containerUDB.setParent(this.containers);
                    this.containers.add(containerUDB);
                } else {
                    this.containers.remove(containerUDB);
                }
            }
        } else if (modelObjectSetEvent.isType(0) && modelObjectSetEvent.getAffected() instanceof ContainerUDB) {
            ContainerUDB containerUDB = (ContainerUDB)modelObjectSetEvent.getAffected();
            this.containers.remove(containerUDB);
            containerUDB.removeObjectListener(this);
        }
    }

    private void addUser(String string) {
        if (!this.getUserSet().contains(string)) {
            this.getUserSet().add(string);
        }
    }

    public void recreateUserSet(String string) {
        this.getUserSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getUserSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public void setUsers(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateUserSet(string);
        } else {
            this.addUser(string);
        }
        this.users = this.getUserSet().toString();
        this.fireDataFieldChange();
    }

    public String getUsers() {
        return this.users;
    }

    public UserSet getUserSet() {
        if (this.userSet == null) {
            this.userSet = new UserSet();
        }
        return this.userSet;
    }

    private void addUserGroup(String string) {
        if (!this.getUserGroupSet().contains(string)) {
            this.getUserGroupSet().add(string);
        }
    }

    public void recreateUserGroupSet(String string) {
        this.getUserGroupSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getUserGroupSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public void setGroups(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateUserGroupSet(string);
        } else {
            this.addUserGroup(string);
        }
        this.userGroups = this.getUserGroupSet().toString();
        this.fireDataFieldChange();
    }

    public String getGroups() {
        return this.userGroups;
    }

    public UserSet getUserGroupSet() {
        if (this.userGroupSet == null) {
            this.userGroupSet = new UserSet();
        }
        return this.userGroupSet;
    }

    public void clear() {
        this.getUserSet().removeAllElements();
        this.users = "";
        this.getUserGroupSet().removeAllElements();
        this.userGroups = "";
    }

    public static String[] getYesNoChoices() {
        return YES_NO_STATES;
    }

    protected boolean checkYesNo(String string) {
        if (yesNoSet == null) {
            yesNoSet = new HashSet();
            yesNoSet.addAll(Arrays.asList(TableSpaceUDB.getYesNoChoices()));
        }
        return yesNoSet.contains(string);
    }

    public String getGrantOption() {
        return this.grantOption;
    }

    public void setGrantOption(String string) {
        if (string != null && string.equals(this.grantOption)) {
            return;
        }
        if (this.checkYesNo(string)) {
            this.grantOption = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper("DB Definition Only", this, "getDBDefOnly", "setDBDefOnly", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Managed by", this, "getManagedBy", "setManagedBy", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("DataType", this, "getDataType", "setDataType", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Nodegroup", this, "getNodeGroup", "setNodeGroup", NodeGroupUDB.class));
            this.propertyWrapperList.add(new PropertyWrapper("Page Size", this, "getPageSize", "setPageSize", Integer.class));
            this.propertyWrapperList.add(new PropertyWrapper("Extent Size", this, "getExtentSize", "setExtentSize", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Prefetch Size", this, "getPrefetchSize", "setPrefetchSize", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("BufferPool", this, "getBufferPool", "setBufferPool", BufferPoolUDB.class));
            this.propertyWrapperList.add(new PropertyWrapper("Overhead", this, "getOverhead", "setOverhead", Float.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Transfer Rate", this, "getTransferRate", "setTransferRate", Float.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Dropped Table Rec", this, "getDroppedTableRecovery", "setDroppedTableRecovery", Boolean.TYPE));
        }
        return this.propertyWrapperList;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("TABLESPACE_ICON", 16);
    }

    public class UserSet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

