/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.udb.ColumnProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageObjectConstantsUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.model.design.storage.udb.TriggerUDB;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.udb.TablePropertyDialogUDB;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class TableProxyUDB
extends TableProxy
implements ModelObjectSetListener,
StorageObjectListener,
PropertiesPropagator {
    public static final String DATA_CAPTURE_NONE = "NONE";
    public static final String DATA_CAPTURE_CHANGES = "CHANGES";
    private static String[] availableDataCaptureValues = new String[]{"NONE", "CHANGES"};
    private OwnerUDB owner = null;
    private SchemaUDB schema = null;
    private String partitioningKey = "";
    private ColumnSet partitioningKeySet = null;
    private boolean partKeyHashing = false;
    private TableSpaceUDB tableSpace = null;
    private TableSpaceUDB indexInTableSpace = null;
    private TableSpaceUDB longInTableSpace = null;
    private boolean initialLogging = true;
    private String dataCapture = "NONE";
    private static Set dataCaptureSet = null;
    protected StorageObjectCollection fkeys;
    protected StorageObjectCollection triggers;
    private static Set yesNoSet = null;
    protected String summaryQuery = "NO";
    protected String summaryQueryDefinition = "";
    protected String summaryMaintenance = SUMMARY_MAINTENANCE_STATES[0];
    protected String summaryStatus = SUMMARY_STATUS_STATES[0];
    protected String summaryRefreshOptions = SUMMARY_REFRESH_OPTIONS_STATES[0];
    protected String summaryQueryOptimization = SUMMARY_QUERY_OPTIMIZATION_STATES[0];
    protected String summaryIdentityColumn = SUMMARY_IDENTITY_COLUMN_STATES[0];
    protected String summaryCopyColumnDefaults = SUMMARY_COPY_COLUMN_DEFAULTS_STATES[0];
    protected String replicated = "NO";
    protected String federated = FEDERATED_STATES[0];
    public static final String[] SUMMARY_STATUS_STATES = new String[]{"MATERIALIZED QUERY", "DEFINITION ONLY"};
    private static Set summaryStatusSet = null;
    public static final String[] SUMMARY_MAINTENANCE_STATES = new String[]{"BY SYSTEM", "BY USER"};
    private static Set summaryMaintenanceSet = null;
    public static final String[] SUMMARY_REFRESH_OPTIONS_STATES = new String[]{"DEFERRED", "IMMEDIATE"};
    private static Set summaryRefreshOptionsSet = null;
    public static final String[] SUMMARY_QUERY_OPTIMIZATION_STATES = new String[]{"ENABLE", "DISABLE"};
    private static Set summaryQueryOptimizationSet = null;
    public static final String[] SUMMARY_IDENTITY_COLUMN_STATES = new String[]{"EXCLUDING", "INCLUDING"};
    private static Set summaryIdentityColumnSet = null;
    public static final String[] SUMMARY_COPY_COLUMN_DEFAULTS_STATES = new String[]{"NONE", "EXCLUDING", "INCLUDING"};
    private static Set summaryCopyColumnDefaultsSet = null;
    public static final String[] FEDERATED_STATES = new String[]{"NONE", "FEDERATED", "NOT FEDERATED"};
    private static Set federatedSet = null;
    private String hierarchyName = "";
    private List propertyWrapperList = null;
    protected StorageObjectCollection stagingTables;
    protected StorageObjectCollection tableCheckConstraints;

    public TableProxyUDB(Table table, StorageDesign storageDesign) {
        super(table, storageDesign);
        this.fkeys = new StorageObjectCollection();
        this.fkeys.setParent(this);
        this.fkeys.setName(Messages.getString("TableProxyOracle.ForeignKeys"));
        this.fkeys.setIcon(GUIConfiguration.getInstance().getIcon("FK_ICON", 16));
        this.addFKProxyFromDesign(((StorageDesignUDB)storageDesign).getFKProxySet());
        ((StorageDesignUDB)storageDesign).getFKProxySet().addSetListener(this);
        this.triggers = new StorageObjectCollection(((StorageDesignUDB)storageDesign).getTriggerSet());
        this.triggers.setParent(this);
        this.triggers.setName(Messages.getString("TableProxyOracle.Triggers"));
        this.triggers.setClassForParent(TableProxyUDB.class);
        this.triggers.setSetMethod("setTable");
        this.triggers.setIcon(GUIConfiguration.getInstance().getIcon("TRIGGER_FOLDER_ICON", 16));
        ((StorageDesignUDB)storageDesign).getTriggerSet().addSetListener(this);
        this.addTriggersFromDesign(((StorageDesignUDB)storageDesign).getTriggerSet());
    }

    public TableProxyUDB(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
        this.fkeys = new StorageObjectCollection();
        this.fkeys.setParent(this);
        this.fkeys.setName(Messages.getString("TableProxyOracle.ForeignKeys"));
        this.fkeys.setIcon(GUIConfiguration.getInstance().getIcon("FK_ICON", 16));
        this.addFKProxyFromDesign(((StorageDesignUDB)storageDesign).getFKProxySet());
        ((StorageDesignUDB)storageDesign).getFKProxySet().addSetListener(this);
        this.triggers = new StorageObjectCollection(((StorageDesignUDB)storageDesign).getTriggerSet());
        this.triggers.setParent(this);
        this.triggers.setName(Messages.getString("TableProxyOracle.Triggers"));
        this.triggers.setClassForParent(TableProxyUDB.class);
        this.triggers.setSetMethod("setTable");
        this.triggers.setIcon(GUIConfiguration.getInstance().getIcon("TRIGGER_FOLDER_ICON", 16));
        ((StorageDesignUDB)storageDesign).getTriggerSet().addSetListener(this);
        this.addTriggersFromDesign(((StorageDesignUDB)storageDesign).getTriggerSet());
    }

    public void setOwner(OwnerUDB ownerUDB) {
        this.owner = ownerUDB;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    public OwnerUDB getOwner() {
        return this.owner;
    }

    public void setSchema(SchemaUDB schemaUDB) {
        this.schema = schemaUDB;
        this.fireDataFieldChange();
    }

    public SchemaUDB getSchema() {
        return this.schema;
    }

    private void addColumn(String string) {
        String string2 = string.substring(string.lastIndexOf(46) + 1, string.length());
        if (!this.getColumnSet().contains(string2)) {
            this.getColumnSet().add(string2);
        }
    }

    protected void recreateColumnListSet(String string) {
        this.getColumnSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getColumnSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public String getPartitioningKey() {
        return this.partitioningKey;
    }

    public void setPartitioningKey(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateColumnListSet(string);
        } else {
            this.addColumn(string);
        }
        this.partitioningKey = this.getColumnSet().toString();
        this.fireDataFieldChange();
    }

    public void setPartKeyHashing(boolean bl) {
        this.partKeyHashing = bl;
    }

    public boolean getPartKeyHashing() {
        return this.partKeyHashing;
    }

    public static String[] getAvailableDataCaptureValues() {
        return availableDataCaptureValues;
    }

    protected boolean checkDataCaptureValue(String string) {
        if (dataCaptureSet == null) {
            dataCaptureSet = new HashSet();
            dataCaptureSet.addAll(Arrays.asList(TableProxyUDB.getAvailableDataCaptureValues()));
        }
        return dataCaptureSet.contains(string);
    }

    public void setDataCapture(String string) {
        if (this.checkDataCaptureValue(string)) {
            this.dataCapture = string;
            this.fireDataFieldChange();
        }
    }

    public String getDataCapture() {
        return this.dataCapture;
    }

    public void setTableSpace(TableSpaceUDB tableSpaceUDB) {
        this.tableSpace = tableSpaceUDB;
        this.fireDataFieldChange();
    }

    public TableSpaceUDB getTableSpace() {
        return this.tableSpace;
    }

    public void setIndexInTableSpace(TableSpaceUDB tableSpaceUDB) {
        this.indexInTableSpace = tableSpaceUDB;
        this.fireDataFieldChange();
    }

    public TableSpaceUDB getIndexInTableSpace() {
        return this.indexInTableSpace;
    }

    public void setLongInTableSpace(TableSpaceUDB tableSpaceUDB) {
        this.longInTableSpace = tableSpaceUDB;
        this.fireDataFieldChange();
    }

    public TableSpaceUDB getLongInTableSpace() {
        return this.longInTableSpace;
    }

    public void setInitialLogging(boolean bl) {
        this.initialLogging = bl;
    }

    public boolean getInitialLogging() {
        return this.initialLogging;
    }

    @Override
    public String getLongName() {
        if (this.getSchema() != null) {
            return new StringBuffer(this.getSchema().getLongName()).append('.').append(this.getName()).toString();
        }
        Table table = (Table)this.getObject();
        SchemaObject schemaObject = table.getSchemaObject();
        if (schemaObject != null) {
            StorageObject storageObject = ((StorageDesignUDB)this.getStorageDesign()).getSchemaSet().getBySchemaObject(schemaObject);
            if (storageObject != null) {
                return new StringBuffer(storageObject.getLongName()).append('.').append(this.getName()).toString();
            }
            if (!this.getStorageDesign().isOpen()) {
                return new StringBuffer(schemaObject.getLongName()).append('.').append(this.getName()).toString();
            }
        }
        return super.getLongName();
    }

    public ColumnSet getColumnSet() {
        if (this.partitioningKeySet == null) {
            this.partitioningKeySet = new ColumnSet();
        }
        return this.partitioningKeySet;
    }

    public void clear() {
        this.getColumnSet().removeAllElements();
        this.partitioningKey = "";
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TablePropertyDialogUDB tablePropertyDialogUDB = new TablePropertyDialogUDB(this.getDesign().getAppView(), this.getStorageDesign(), this);
            tablePropertyDialogUDB.show();
        }
    }

    @Override
    public int getNumberOfChildren() {
        return super.getNumberOfChildren() + 2;
    }

    @Override
    public ModelObject getChild(int n) {
        if (n == this.getNumberOfChildren() - 1) {
            return this.fkeys;
        }
        if (n == this.getNumberOfChildren() - 2) {
            return this.triggers;
        }
        return super.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.fkeys) {
            return this.getNumberOfChildren() - 1;
        }
        if (modelObject == this.triggers) {
            return this.getNumberOfChildren() - 2;
        }
        return super.getIndexForChild(modelObject);
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.fkeys) {
            return this.getNumberOfChildren() - 1;
        }
        if (object == this.triggers) {
            return this.getNumberOfChildren() - 2;
        }
        return super.getIndexForChild(object);
    }

    protected void addTriggersFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            TriggerUDB triggerUDB = (TriggerUDB)iterator.next();
            triggerUDB.addObjectListener(this);
            if (triggerUDB.getTable() != null && triggerUDB.getTable() == this) {
                triggerUDB.setParent(this.triggers);
                this.triggers.add(triggerUDB);
                continue;
            }
            this.triggers.remove(triggerUDB);
        }
    }

    @Override
    public void changed(RelationalObjectProxySet relationalObjectProxySet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof ColumnProxy) {
                ColumnProxy columnProxy = (ColumnProxy)modelObjectSetEvent.getAffected();
                if (((Table)this.getObject()).getElementsCollection().contains(columnProxy.getObject()) && this.getObject() == ((Column)columnProxy.getObject()).getContainerWithKeyObject()) {
                    this.columns.add(modelObjectSetEvent.getAffected());
                }
            } else if (modelObjectSetEvent.getAffected() instanceof IndexProxy) {
                IndexProxy indexProxy = (IndexProxy)modelObjectSetEvent.getAffected();
                if (this.getObject() == ((Index)indexProxy.getObject()).getContainerWithKeyObject()) {
                    if (((Index)indexProxy.getObject()).isFK()) {
                        if (!this.fkeys.contains(indexProxy)) {
                            indexProxy.setParent(this.fkeys);
                            this.fkeys.add(modelObjectSetEvent.getAffected());
                        }
                    } else if (!this.indexes.contains(indexProxy)) {
                        indexProxy.setParent(this.indexes);
                        this.indexes.add(modelObjectSetEvent.getAffected());
                    }
                }
            } else if (modelObjectSetEvent.getAffected() instanceof TriggerUDB) {
                TriggerUDB triggerUDB = (TriggerUDB)modelObjectSetEvent.getAffected();
                triggerUDB.addObjectListener(this);
                if (triggerUDB.getTable() != null && triggerUDB.getTable() == this) {
                    triggerUDB.setParent(this.triggers);
                    this.triggers.add(triggerUDB);
                } else {
                    this.triggers.remove(triggerUDB);
                }
            }
        } else if (modelObjectSetEvent.isType(0)) {
            if (modelObjectSetEvent.getAffected() instanceof ColumnProxy) {
                this.columns.remove(((ColumnProxy)modelObjectSetEvent.getAffected()).getObject().getObjectID());
            } else if (modelObjectSetEvent.getAffected() instanceof IndexProxy) {
                IndexProxy indexProxy = (IndexProxy)modelObjectSetEvent.getAffected();
                if (this.indexes.contains(indexProxy)) {
                    this.indexes.remove(modelObjectSetEvent.getAffected());
                }
                if (this.fkeys.contains(indexProxy)) {
                    this.fkeys.remove(modelObjectSetEvent.getAffected());
                }
            } else if (modelObjectSetEvent.getAffected() instanceof TriggerUDB) {
                TriggerUDB triggerUDB = (TriggerUDB)modelObjectSetEvent.getAffected();
                this.triggers.remove(triggerUDB);
                triggerUDB.removeObjectListener(this);
            }
        }
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof TriggerUDB) {
            TriggerUDB triggerUDB = (TriggerUDB)objectChangeEvent.getAffected();
            if (triggerUDB.getTable() != null && triggerUDB.getTable() == this) {
                triggerUDB.setParent(this.triggers);
                this.triggers.add(triggerUDB);
            } else {
                this.triggers.remove(triggerUDB);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof TriggerUDB) {
                TriggerUDB triggerUDB = (TriggerUDB)modelObjectSetEvent.getAffected();
                triggerUDB.addObjectListener(this);
                if (triggerUDB.getTable() != null && triggerUDB.getTable() == this) {
                    triggerUDB.setParent(this.triggers);
                    this.triggers.add(triggerUDB);
                } else {
                    this.triggers.remove(triggerUDB);
                }
            }
        } else if (modelObjectSetEvent.isType(0) && modelObjectSetEvent.getAffected() instanceof TriggerUDB) {
            TriggerUDB triggerUDB = (TriggerUDB)modelObjectSetEvent.getAffected();
            this.triggers.remove(triggerUDB);
            triggerUDB.removeObjectListener(this);
        }
    }

    protected void addFKProxyFromDesign(RelationalObjectProxySet relationalObjectProxySet) {
        Iterator iterator = relationalObjectProxySet.iterator();
        while (iterator.hasNext()) {
            IndexProxy indexProxy = (IndexProxy)iterator.next();
            if (this.getObject() != ((Index)indexProxy.getObject()).getContainerWithKeyObject() || !((Index)indexProxy.getObject()).isFK()) continue;
            indexProxy.setParent(this.fkeys);
            this.fkeys.add(indexProxy);
        }
    }

    public static String[] getSummaryStatusChoices() {
        return SUMMARY_STATUS_STATES;
    }

    protected boolean checkSummaryStatus(String string) {
        if (summaryStatusSet == null) {
            summaryStatusSet = new HashSet();
            summaryStatusSet.addAll(Arrays.asList(TableProxyUDB.getSummaryStatusChoices()));
        }
        return summaryStatusSet.contains(string);
    }

    public static String[] getSummaryRefreshOptionsChoices() {
        return SUMMARY_REFRESH_OPTIONS_STATES;
    }

    protected boolean checkSummaryRefreshOptions(String string) {
        if (summaryRefreshOptionsSet == null) {
            summaryRefreshOptionsSet = new HashSet();
            summaryRefreshOptionsSet.addAll(Arrays.asList(TableProxyUDB.getSummaryRefreshOptionsChoices()));
        }
        return summaryRefreshOptionsSet.contains(string);
    }

    public static String[] getSummaryQueryOptimizationChoices() {
        return SUMMARY_QUERY_OPTIMIZATION_STATES;
    }

    protected boolean checkSummaryQueryOptimization(String string) {
        if (summaryQueryOptimizationSet == null) {
            summaryQueryOptimizationSet = new HashSet();
            summaryQueryOptimizationSet.addAll(Arrays.asList(TableProxyUDB.getSummaryQueryOptimizationChoices()));
        }
        return summaryQueryOptimizationSet.contains(string);
    }

    public static String[] getSummaryIdentityColumnChoices() {
        return SUMMARY_IDENTITY_COLUMN_STATES;
    }

    protected boolean checkSummaryIdentityColumn(String string) {
        if (summaryIdentityColumnSet == null) {
            summaryIdentityColumnSet = new HashSet();
            summaryIdentityColumnSet.addAll(Arrays.asList(TableProxyUDB.getSummaryIdentityColumnChoices()));
        }
        return summaryIdentityColumnSet.contains(string);
    }

    public static String[] getSummaryColumnDefaultsChoices() {
        return SUMMARY_COPY_COLUMN_DEFAULTS_STATES;
    }

    protected boolean checkSummaryColumnDefaults(String string) {
        if (summaryCopyColumnDefaultsSet == null) {
            summaryCopyColumnDefaultsSet = new HashSet();
            summaryCopyColumnDefaultsSet.addAll(Arrays.asList(TableProxyUDB.getSummaryColumnDefaultsChoices()));
        }
        return summaryCopyColumnDefaultsSet.contains(string);
    }

    public static String[] getFederatedChoices() {
        return FEDERATED_STATES;
    }

    protected boolean checkFederated(String string) {
        if (federatedSet == null) {
            federatedSet = new HashSet();
            federatedSet.addAll(Arrays.asList(TableProxyUDB.getFederatedChoices()));
        }
        return federatedSet.contains(string);
    }

    public String getSummaryCopyColumnDefaults() {
        return this.summaryCopyColumnDefaults;
    }

    public void setSummaryCopyColumnDefaults(String string) {
        if (this.checkSummaryColumnDefaults(string)) {
            this.summaryCopyColumnDefaults = string;
            this.fireDataFieldChange();
        }
    }

    public String getSummaryIdentityColumn() {
        return this.summaryIdentityColumn;
    }

    public void setSummaryIdentityColumn(String string) {
        if (this.checkSummaryIdentityColumn(string)) {
            this.summaryIdentityColumn = string;
            this.fireDataFieldChange();
        }
    }

    public String getSummaryQueryDefinition() {
        return this.summaryQueryDefinition;
    }

    public void setSummaryQueryDefinition(String string) {
        this.summaryQueryDefinition = string;
        this.fireDataFieldChange();
    }

    public String getSummaryRefreshOptions() {
        return this.summaryRefreshOptions;
    }

    public void setSummaryRefreshOptions(String string) {
        if (this.checkSummaryRefreshOptions(string)) {
            this.summaryRefreshOptions = string;
            this.fireDataFieldChange();
        }
    }

    public String getSummaryQueryOptimization() {
        return this.summaryQueryOptimization;
    }

    public void setSummaryQueryOptimization(String string) {
        if (this.checkSummaryQueryOptimization(string)) {
            this.summaryQueryOptimization = string;
            this.fireDataFieldChange();
        }
    }

    public String getSummaryStatus() {
        return this.summaryStatus;
    }

    public static String[] getSummaryMaintenanceChoices() {
        return SUMMARY_MAINTENANCE_STATES;
    }

    protected boolean checkSummaryMaintenance(String string) {
        if (summaryMaintenanceSet == null) {
            summaryMaintenanceSet = new HashSet();
            summaryMaintenanceSet.addAll(Arrays.asList(TableProxyUDB.getSummaryMaintenanceChoices()));
        }
        return summaryMaintenanceSet.contains(string);
    }

    public void setSummaryStatus(String string) {
        if (this.checkSummaryStatus(string)) {
            this.summaryStatus = string;
            this.fireDataFieldChange();
        }
    }

    public String getSummaryMaintenance() {
        return this.summaryMaintenance;
    }

    public void setSummaryMaintenance(String string) {
        if (this.checkSummaryMaintenance(string)) {
            this.summaryMaintenance = string;
            this.fireDataFieldChange();
        }
    }

    public String getSummaryQuery() {
        return this.summaryQuery;
    }

    public void setSummaryQuery(String string) {
        if (this.checkYesNo(string)) {
            this.summaryQuery = string;
            this.fireDataFieldChange();
        }
    }

    protected boolean checkYesNo(String string) {
        if (yesNoSet == null) {
            yesNoSet = new HashSet();
            yesNoSet.addAll(Arrays.asList(StorageObjectConstantsUDB.YES_NO));
        }
        return yesNoSet.contains(string);
    }

    public String getReplicated() {
        return this.replicated;
    }

    public void setReplicated(String string) {
        if (this.checkYesNo(string)) {
            this.replicated = string;
            this.fireDataFieldChange();
        }
    }

    public String getFederated() {
        return this.federated;
    }

    public void setFederated(String string) {
        this.federated = string;
        this.fireDataFieldChange();
    }

    public ColumnProxyUDB getColumn(String string) {
        for (int i = 0; i < this.getColumnProxies().length; ++i) {
            if (!string.equalsIgnoreCase(this.getColumnProxies()[i].getName())) continue;
            return (ColumnProxyUDB)this.getColumnProxies()[i];
        }
        return null;
    }

    @Override
    public StorageObject getUserSchema() {
        if (this.getSchema() != null) {
            return this.getSchema();
        }
        return this.getOwner();
    }

    public String getHierarchyName() {
        return this.hierarchyName;
    }

    public void setHierarchyName(String string) {
        this.hierarchyName = string;
    }

    public String getSuperTableName() {
        Table table = (Table)this.getObject();
        if (!table.isRoot() && table.getTypeSubstitution() != null) {
            return table.getTypeSubstitution().getParentContainerObject().getName();
        }
        return "";
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper("Schema", this, "getSchema", "setSchema", SchemaUDB.class));
            this.propertyWrapperList.add(new PropertyWrapper("Part. Key Hashing", this, "getPartKeyHashing", "setPartKeyHashing", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("TableSpace", this, "getTableSpace", "setTableSpace", TableSpaceUDB.class));
            this.propertyWrapperList.add(new PropertyWrapper("Index TableSpace", this, "getIndexInTableSpace", "setIndexInTableSpace", TableSpaceUDB.class));
            this.propertyWrapperList.add(new PropertyWrapper("Long TableSpace", this, "getLongInTableSpace", "setLongInTableSpace", TableSpaceUDB.class));
            this.propertyWrapperList.add(new PropertyWrapper("Initial Logging", this, "getInitialLogging", "setInitialLogging", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Data Capture", this, "getDataCapture", "setDataCapture", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Federated", this, "getFederated", "setFederated", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Summary Query", this, "getSummaryQuery", "setSummaryQuery", String.class));
        }
        return this.propertyWrapperList;
    }

    @Override
    public void remove() {
        Object[] objectArray = this.triggers.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            TriggerUDB triggerUDB = (TriggerUDB)objectArray[i];
            triggerUDB.remove();
            triggerUDB.setTable(null);
            this.triggers.remove(triggerUDB);
        }
        super.remove();
    }

    @Override
    public void clearMergableStructure(Map map) {
        if (map != null) {
            ArrayList arrayList = new ArrayList();
            this.triggers.addAllElementsTo(arrayList);
            if (this.tableCheckConstraints != null) {
                this.tableCheckConstraints.addAllElementsTo(arrayList);
            }
            if (this.stagingTables != null) {
                this.stagingTables.addAllElementsTo(arrayList);
            }
            for (StorageObject storageObject : arrayList) {
                if (map.get(storageObject.getObjectID()) != null) continue;
                storageObject.remove(true);
            }
        }
    }

    public StorageObjectCollection getFKeys() {
        return this.fkeys;
    }

    @Override
    public StorageObjectCollection getTriggers() {
        return this.triggers;
    }

    public class ColumnSet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

