/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import javax.swing.Icon;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StoredProcedure;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.udb.StoredProcedurePropertyDialogUDB;

public class StoredProcedureUDB
extends StoredProcedure {
    protected OwnerUDB owner;
    protected SchemaUDB schema;
    protected String specificName = "";

    public StoredProcedureUDB(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            StoredProcedurePropertyDialogUDB storedProcedurePropertyDialogUDB = new StoredProcedurePropertyDialogUDB(this.getDesign().getAppView(), this.getStorageDesign(), this);
            storedProcedurePropertyDialogUDB.show();
        }
    }

    public OwnerUDB getOwner() {
        return this.owner;
    }

    public void setOwner(OwnerUDB ownerUDB) {
        this.owner = ownerUDB;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    public void setSchema(SchemaUDB schemaUDB) {
        this.schema = schemaUDB;
        this.fireDataFieldChange();
    }

    public SchemaUDB getSchema() {
        return this.schema;
    }

    @Override
    public String getLongName() {
        if (this.getSchema() != null) {
            return new StringBuffer(this.getSchema().getName()).append('.').append(this.getName()).toString();
        }
        return super.getLongName();
    }

    @Override
    public boolean allowName(String string, boolean bl) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet modelObjectSet = this.getObjectSet();
        if (modelObjectSet == null) {
            return true;
        }
        if (!bl && this.getSchema() != null) {
            string = this.getSchema().getName() + '.' + string;
        }
        return !modelObjectSet.containsLongName(this, string);
    }

    public String getSpecificName() {
        return this.specificName;
    }

    public void setSpecificName(String string) {
        this.specificName = string;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("PROCEDURE_ICON", 16);
    }
}

