/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageObjectDB2;
import oracle.dbtools.crest.model.design.storage.udb.StorageObjectConstantsUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;

public class StagingTableUDB
extends AbstractStorageObjectDB2 {
    protected TableProxyUDB table;
    protected boolean defineColumnNames = false;
    protected String generateSIC = "YES";
    protected String columns = "";
    protected ColumnSet columnSet = null;
    protected static final String GLOBALTRANSID = "GLOBALTRANSID";
    protected static final String GLOBALTRANSTIME = "GLOBALTRANSTIME";
    protected static final String OPERATIONTYPE = "OPERATIONTYPE";
    public static final String TYPE_NAME = "StagingTable";

    @Override
    public void showPropertyDialog() {
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    public TableProxyUDB getTable() {
        return this.table;
    }

    public void setTable(TableProxyUDB tableProxyUDB) {
        this.table = tableProxyUDB;
        this.fireDataFieldChange();
    }

    private void addColumn(String string) {
        String string2 = string.substring(string.lastIndexOf(46) + 1, string.length());
        if (!this.getColumnSet().contains(string2)) {
            this.getColumnSet().add(string2);
        }
    }

    private void recreateColumnSet(String string) {
        this.getColumnSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getColumnSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public void setColumns(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateColumnSet(string);
        } else {
            this.addColumn(string);
        }
        this.columns = this.getColumnSet().toString();
        this.fireDataFieldChange();
    }

    public String getColumns() {
        return this.columns;
    }

    public ColumnSet getColumnSet() {
        if (this.columnSet == null) {
            this.columnSet = new ColumnSet();
        }
        return this.columnSet;
    }

    public void clear() {
        this.getColumnSet().removeAllElements();
        this.columns = "";
    }

    public boolean getDefineColumnNames() {
        return this.defineColumnNames;
    }

    public void setDefineColumnNames(boolean bl) {
        this.defineColumnNames = bl;
    }

    public String getGenerateSIC() {
        return this.generateSIC;
    }

    public void setGenerateSIC(String string) {
        if (StorageObjectConstantsUDB.checkYesNo(string)) {
            this.generateSIC = string;
            this.fireDataFieldChange();
        }
    }

    public ArrayList getTableColumnNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.table.getColumnProxies().length; ++i) {
            arrayList.add(this.table.getColumnProxies()[i].getName());
        }
        if (this.table.getSummaryQuery().toUpperCase().indexOf("GROUP BY") > -1) {
            arrayList.add(GLOBALTRANSID);
            arrayList.add(GLOBALTRANSTIME);
        } else {
            arrayList.add(GLOBALTRANSID);
            arrayList.add(GLOBALTRANSTIME);
            arrayList.add(OPERATIONTYPE);
        }
        return arrayList;
    }

    public class ColumnSet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

