/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageObjectDB2;
import oracle.dbtools.crest.model.design.storage.udb.ColumnProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.UserGroupUDB;

public class PermissionsUDB
extends AbstractStorageObjectDB2 {
    public static final String UPDATE = "UPDATE";
    public static final String REFERENCES = "REFERENCES";
    public static final String ALL_PRIVILEGES = "ALL PRIVILEGES";
    public static final String ALTER = "ALTER";
    public static final String DELETE = "DELETE";
    public static final String INDEX = "INDEX";
    public static final String INSERT = "INSERT";
    public static final String SELECT = "SELECT";
    public static final String CONTROL = "CONTROL";
    public static final String EMPTY_STRING = "";
    private static final String[] COLUMNS_PRIVILEGES = new String[]{"UPDATE", "REFERENCES"};
    private static final String[] TABLE_PRIVILEGES = new String[]{"ALL PRIVILEGES", "ALTER", "CONTROL", "DELETE", "INDEX", "INSERT", "REFERENCES", "SELECT", "UPDATE"};
    private static final String[] VIEW_PRIVILEGES = new String[]{"ALL PRIVILEGES", "DELETE", "INSERT", "SELECT", "UPDATE", "CONTROL"};
    private TableProxyUDB table = null;
    private TableViewProxyUDB view = null;
    private InlineList privilegesSet = null;
    private InlineList privilegesWithGrantOptionSet = null;
    private OwnerUDB user = null;
    private UserGroupUDB group = null;
    private String privileges = "";
    private String privilegesWithGrantOption = "";
    private String columnList = "";
    public static final String TYPE_NAME = "Permissions";

    public static List getColumnPermissionsValues() {
        List<String> list = Arrays.asList(COLUMNS_PRIVILEGES);
        Collections.sort(list, new StringComparator());
        return list;
    }

    public static List getTablePermissionsValues() {
        List<String> list = Arrays.asList(TABLE_PRIVILEGES);
        Collections.sort(list, new StringComparator());
        return list;
    }

    public static List getViewPermissionsValues() {
        List<String> list = Arrays.asList(VIEW_PRIVILEGES);
        Collections.sort(list, new StringComparator());
        return list;
    }

    public static String[] getColumnPrivilegesValues() {
        return COLUMNS_PRIVILEGES;
    }

    public static String[] getTablePrivilegesValues() {
        return TABLE_PRIVILEGES;
    }

    public static String[] getViewPrivilegesValues() {
        return VIEW_PRIVILEGES;
    }

    private void recreatePrivilegesSet(String string) {
        this.getPrivilegesSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.privilegesSet = new InlineList();
        while (stringTokenizer.hasMoreTokens()) {
            this.getPrivilegesSet().add(stringTokenizer.nextToken().trim());
        }
    }

    private void addPrivileges(String string) {
        if (!this.getPrivilegesSet().contains(string)) {
            this.getPrivilegesSet().add(string);
            this.getPrivilegesWithGrantOptionSet().remove(string);
        }
    }

    private void recreatePrivilegesWithGrantOptionSet(String string) {
        this.getPrivilegesWithGrantOptionSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.privilegesWithGrantOptionSet = new InlineList();
        while (stringTokenizer.hasMoreTokens()) {
            this.getPrivilegesWithGrantOptionSet().add(stringTokenizer.nextToken().trim());
        }
    }

    private void addPrivilegesWithGrantOption(String string) {
        if (!this.getPrivilegesWithGrantOptionSet().contains(string)) {
            this.getPrivilegesWithGrantOptionSet().add(string);
            this.getPrivilegesSet().remove(string);
        }
    }

    private void addColumn(String string) {
        if (!this.columnList.trim().equalsIgnoreCase(EMPTY_STRING)) {
            this.columnList = this.columnList + "|";
        }
        this.columnList = this.columnList + string;
    }

    @Override
    public String getIDPrefix() {
        return "Prm";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public String getPrivileges() {
        return this.privileges;
    }

    public InlineList getPrivilegesSet() {
        if (this.privilegesSet == null) {
            this.privilegesSet = new InlineList();
        }
        return this.privilegesSet;
    }

    public String getPrivilegesWithGrantOption() {
        return this.privilegesWithGrantOption;
    }

    public InlineList getPrivilegesWithGrantOptionSet() {
        if (this.privilegesWithGrantOptionSet == null) {
            this.privilegesWithGrantOptionSet = new InlineList();
        }
        return this.privilegesWithGrantOptionSet;
    }

    public TableProxyUDB getTable() {
        return this.table;
    }

    public OwnerUDB getUser() {
        return this.user;
    }

    public void setUser(OwnerUDB ownerUDB) {
        if (this.user != ownerUDB) {
            this.user = ownerUDB;
            this.group = null;
            this.setPAC_Element(ownerUDB);
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    public UserGroupUDB getGroup() {
        return this.group;
    }

    public void setGroup(UserGroupUDB userGroupUDB) {
        if (this.group != userGroupUDB) {
            this.group = userGroupUDB;
            this.user = null;
            this.fireDataFieldChange();
        }
    }

    public TableViewProxyUDB getView() {
        return this.view;
    }

    public void setPrivileges(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreatePrivilegesSet(string);
        } else {
            this.addPrivileges(string);
        }
        this.privileges = this.getPrivilegesSet().toString();
        this.fireDataFieldChange();
    }

    public void setPrivilegesWithGrantOption(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreatePrivilegesWithGrantOptionSet(string);
        } else {
            this.addPrivilegesWithGrantOption(string);
        }
        this.privilegesWithGrantOption = this.getPrivilegesWithGrantOptionSet().toString();
        this.fireDataFieldChange();
    }

    public void setTable(TableProxyUDB tableProxyUDB) {
        this.table = tableProxyUDB;
        if (tableProxyUDB != null) {
            this.setView(null);
        }
        this.fireDataFieldChange();
    }

    public void setView(TableViewProxyUDB tableViewProxyUDB) {
        this.view = tableViewProxyUDB;
        if (tableViewProxyUDB != null) {
            this.setTable(null);
        }
        this.fireDataFieldChange();
    }

    @Override
    public void showPropertyDialog() {
    }

    public String getColumnList() {
        return this.columnList;
    }

    public void setColumnList(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateColumnList(string);
        } else {
            this.addColumn(string);
        }
        this.fireDataFieldChange();
    }

    public void clearColPermissions() {
        this.columnList = EMPTY_STRING;
    }

    private void recreateColumnList(String string) {
        this.columnList = string;
    }

    public ArrayList getColumns() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.getColumnList(), "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.indexOf(44) > -1) {
                string = string.substring(0, string.indexOf(44));
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    public String getPrivs(ColumnProxyUDB columnProxyUDB) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.getColumnList(), "|");
        String string = EMPTY_STRING;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.indexOf(44) <= -1 || !(string = string2.substring(0, string2.indexOf(44)).trim()).equalsIgnoreCase(columnProxyUDB.getName())) continue;
            return string2.substring(string2.indexOf(44) + 1);
        }
        return string;
    }

    public String getPrivs(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.getColumnList(), "|");
        String string2 = EMPTY_STRING;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.indexOf(44) <= -1 || !(string2 = string3.substring(0, string3.indexOf(44)).trim()).equalsIgnoreCase(string)) continue;
            return string3.substring(string3.indexOf(44) + 1);
        }
        return string2;
    }

    public boolean hasColPrivilege(String string) {
        ArrayList arrayList = this.getColumns();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (this.getPrivs((String)arrayList.get(i)).indexOf(string) <= -1) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.getPrivilegesSet().removeAllElements();
        this.getPrivilegesWithGrantOptionSet().removeAllElements();
        this.privileges = EMPTY_STRING;
        this.privilegesWithGrantOption = EMPTY_STRING;
    }

    static class StringComparator
    implements Comparator {
        StringComparator() {
        }

        public int compare(Object object, Object object2) {
            return String.valueOf(object).compareTo(String.valueOf(object2));
        }
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

