/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.Constants;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.swingui.editor.storage.udb.IndexPropertyDialogUDB;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class IndexProxyUDB
extends IndexProxy
implements Constants,
PropertiesPropagator {
    private SchemaUDB schema = null;
    private OwnerUDB owner = null;
    private String includeColumns = "";
    private ColumnSet columnListSet = null;
    private boolean cluster = false;
    private int percentageFree = 10;
    private int minimumPercentageUsed = 0;
    private boolean reverseScan = false;
    private String users = "";
    private UserSet userSet = null;
    private String userGroups = "";
    private UserSet userGroupSet = null;
    public static final String YES = "YES";
    public static final String NO = "NO";
    public static final String[] YES_NO_STATES = new String[]{"YES", "NO"};
    private static Set yesNoSet = null;
    private List propertyWrapperList = null;

    public IndexProxyUDB(Index index, StorageDesign storageDesign) {
        super(index, storageDesign);
    }

    public IndexProxyUDB(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        super.changed(designObject, objectChangeEvent);
        if (objectChangeEvent.isType(ObjectChangeEvent.KEY_CHANGED_TO_PK)) {
            this.setIsNullInstance(true);
        } else if (objectChangeEvent.isType(ObjectChangeEvent.KEY_CHANGED_NO_PK)) {
            if (!this.isUniqueConstraint()) {
                this.setIsNullInstance(false);
            }
        } else if (objectChangeEvent.isType(ObjectChangeEvent.ADD_FK)) {
            this.getStorageDesign().getIndexProxySet().remove(this);
            ((StorageDesignUDB)this.getStorageDesign()).getFKProxySet().add(designObject);
        } else if (objectChangeEvent.isType(ObjectChangeEvent.KEY_CHANGED_TO_UNIQUE)) {
            this.setIsNullInstance(true);
        } else if (objectChangeEvent.isType(ObjectChangeEvent.KEY_CHANGED_NO_UNIQUE) && !this.isUniqueConstraint()) {
            this.setIsNullInstance(false);
        }
        this.fireChangeNoDirty(objectChangeEvent);
    }

    private void addColumn(String string) {
        String string2 = string.substring(string.lastIndexOf(46) + 1, string.length());
        if (!this.getColumnSet().contains(string2)) {
            this.getColumnSet().add(string2);
        }
    }

    protected void recreateColumnListSet(String string) {
        this.getColumnSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getColumnSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public String getColumnList() {
        return this.includeColumns;
    }

    public void setColumnList(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateColumnListSet(string);
        } else {
            this.addColumn(string);
        }
        this.includeColumns = this.getColumnSet().toString();
        this.fireDataFieldChange();
    }

    public void setPercentageFree(int n) {
        this.percentageFree = n;
    }

    public int getPercentageFree() {
        return this.percentageFree;
    }

    public void setMinimumPercentageUsed(int n) {
        this.minimumPercentageUsed = n;
    }

    public int getMinimumPercentageUsed() {
        return this.minimumPercentageUsed;
    }

    public void setReverseScanSupport(boolean bl) {
        this.reverseScan = bl;
    }

    public boolean getReverseScanSupport() {
        return this.reverseScan;
    }

    public void setUnique(boolean bl) {
        this.getIndex().setUnique(bl);
    }

    public SchemaUDB getSchema() {
        return this.schema;
    }

    public void setSchema(SchemaUDB schemaUDB) {
        this.schema = schemaUDB;
        this.fireDataFieldChange();
    }

    public OwnerUDB getOwner() {
        return this.owner;
    }

    public void setOwner(OwnerUDB ownerUDB) {
        if (ownerUDB != null) {
            this.owner = ownerUDB;
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    public boolean getCluster() {
        return this.cluster;
    }

    public void setCluster(boolean bl) {
        this.cluster = bl;
    }

    @Override
    public boolean isUnique() {
        return this.getIndex().getIndexState().equalsIgnoreCase("Unique Plain Index");
    }

    public boolean isUniqueConstraint() {
        return this.getIndex().getIndexState().equalsIgnoreCase("Unique Constraint");
    }

    @Override
    public String getLongName() {
        if (this.getSchema() != null) {
            return new StringBuffer(this.getSchema().getLongName()).append('.').append(this.getName()).toString();
        }
        Index index = (Index)this.getObject();
        SchemaObject schemaObject = index.getSchemaObject();
        if (schemaObject != null) {
            StorageObject storageObject = ((StorageDesignUDB)this.getStorageDesign()).getSchemaSet().getBySchemaObject(schemaObject);
            if (storageObject != null) {
                return new StringBuffer(storageObject.getLongName()).append('.').append(this.getName()).toString();
            }
            if (!this.getStorageDesign().isOpen()) {
                return new StringBuffer(schemaObject.getLongName()).append('.').append(this.getName()).toString();
            }
        }
        return super.getLongName();
    }

    public ColumnSet getColumnSet() {
        if (this.columnListSet == null) {
            this.columnListSet = new ColumnSet();
        }
        return this.columnListSet;
    }

    public void clear() {
        this.getColumnSet().removeAllElements();
        this.includeColumns = "";
    }

    private void addUser(String string) {
        if (!this.getUserSet().contains(string)) {
            this.getUserSet().add(string);
        }
    }

    protected void recreateUserSet(String string) {
        this.getUserSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getUserSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public void setUsers(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateUserSet(string);
        } else {
            this.addUser(string);
        }
        this.users = this.getUserSet().toString();
        this.fireDataFieldChange();
    }

    public String getUsers() {
        return this.users;
    }

    public UserSet getUserSet() {
        if (this.userSet == null) {
            this.userSet = new UserSet();
        }
        return this.userSet;
    }

    private void addUserGroup(String string) {
        if (!this.getUserGroupSet().contains(string)) {
            this.getUserGroupSet().add(string);
        }
    }

    protected void recreateUserGroupSet(String string) {
        this.getUserGroupSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getUserGroupSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public void setGroups(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateUserGroupSet(string);
        } else {
            this.addUserGroup(string);
        }
        this.userGroups = this.getUserGroupSet().toString();
        this.fireDataFieldChange();
    }

    public String getGroups() {
        return this.userGroups;
    }

    public UserSet getUserGroupSet() {
        if (this.userGroupSet == null) {
            this.userGroupSet = new UserSet();
        }
        return this.userGroupSet;
    }

    public void clearUsers() {
        this.getUserSet().removeAllElements();
        this.users = "";
        this.getUserGroupSet().removeAllElements();
        this.userGroups = "";
    }

    public static String[] getYesNoChoices() {
        return YES_NO_STATES;
    }

    protected boolean checkYesNo(String string) {
        if (yesNoSet == null) {
            yesNoSet = new HashSet();
            yesNoSet.addAll(Arrays.asList(IndexProxyUDB.getYesNoChoices()));
        }
        return yesNoSet.contains(string);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            IndexPropertyDialogUDB indexPropertyDialogUDB = new IndexPropertyDialogUDB(this.getDesign().getAppView(), this.getStorageDesign(), this);
            indexPropertyDialogUDB.show();
        }
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper("Schema", this, "getSchema", "setSchema", SchemaUDB.class));
            this.propertyWrapperList.add(new PropertyWrapper("Cluster", this, "getCluster", "setCluster", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("PCTFREE", this, "getPercentageFree", "setPercentageFree", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Min % Used", this, "getMinimumPercentageUsed", "setMinimumPercentageUsed", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Reverse Scan", this, "getReverseScanSupport", "setReverseScanSupport", Boolean.TYPE));
        }
        return this.propertyWrapperList;
    }

    @Override
    public String getName() {
        if (this.isNameChanged()) {
            return super.getName();
        }
        Index index = (Index)this.getObject();
        String string = index.getName();
        if (index.isFK() && index.getFKAssociation() != null) {
            string = index.getFKAssociation().getName();
        }
        string = this.applyNameSubstitution(string);
        return string;
    }

    public class UserSet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }

    public class ColumnSet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

