/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver.v2k5;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SynonymSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TriggerSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.ColumnProxySetSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.ColumnProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.FileGroupSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PartitionSchemeSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TriggerSqlServerv2k5;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5.TablePropertyDialogSqlServerv2k5;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class TableProxySqlServerv2k5
extends TableProxySqlServer {
    private PartitionSchemeSqlServerv2k5 partitionScheme;
    private ColumnProxy partitioningColumn;
    private List propertyWrapperList = null;

    public TableProxySqlServerv2k5(Table table, StorageDesign storageDesign) {
        super(table, storageDesign);
        this.synonyms = new StorageObjectCollection(((StorageDesignSqlServerv2k5)storageDesign).getSynonymSet());
        this.synonyms.setParent(this);
        this.synonyms.setName(Messages.getString("StorageDesignOracle.Synonyms"));
        this.synonyms.setClassForParent(TableProxySqlServer.class);
        this.synonyms.setSetMethod("setTable");
        this.synonyms.setIcon(GUIConfiguration.getInstance().getIcon("SYNONYM_FOLDER_ICON", 16));
        ((StorageDesignSqlServerv2k5)storageDesign).getSynonymSet().addSetListener(this);
        this.addSynonymsFromDesign(((StorageDesignSqlServerv2k5)storageDesign).getSynonymSet());
    }

    public TableProxySqlServerv2k5(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TablePropertyDialogSqlServerv2k5 tablePropertyDialogSqlServerv2k5 = new TablePropertyDialogSqlServerv2k5(this.getDesign().getAppView(), this.getStorageDesign(), this);
            tablePropertyDialogSqlServerv2k5.show();
        }
    }

    private void addSynonymsFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            SynonymSqlServer synonymSqlServer = (SynonymSqlServer)iterator.next();
            if (synonymSqlServer.getTable() == this) {
                synonymSqlServer.setParent(this.synonyms);
                this.synonyms.add(synonymSqlServer);
                continue;
            }
            this.synonyms.remove(synonymSqlServer);
        }
    }

    public StorageObjectCollection getSynonyms() {
        return this.synonyms;
    }

    public SynonymSqlServer createSynonym() {
        if (this.synonyms.getStorageObjectSet() != null) {
            return (SynonymSqlServer)this.synonyms.createElement(null);
        }
        return null;
    }

    @Override
    public int getNumberOfChildren() {
        return super.getNumberOfChildren() + 1;
    }

    @Override
    public ModelObject getChild(int n) {
        if (n == this.getNumberOfChildren() - 5) {
            return this.synonyms;
        }
        return super.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.synonyms) {
            return this.getNumberOfChildren() - 5;
        }
        return super.getIndexForChild(modelObject);
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.synonyms) {
            return this.getNumberOfChildren() - 5;
        }
        return super.getIndexForChild(object);
    }

    @Override
    public void changed(RelationalObjectProxySet relationalObjectProxySet, ModelObjectSetEvent modelObjectSetEvent) {
        super.changed(relationalObjectProxySet, modelObjectSetEvent);
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof SynonymSqlServer) {
                SynonymSqlServer synonymSqlServer = (SynonymSqlServer)modelObjectSetEvent.getAffected();
                synonymSqlServer.addObjectListener(this);
                if (synonymSqlServer.getTable() == this) {
                    synonymSqlServer.setParent(this.synonyms);
                    this.synonyms.add(synonymSqlServer);
                } else {
                    this.synonyms.remove(synonymSqlServer);
                }
            }
        } else if (modelObjectSetEvent.isType(0)) {
            StorageObject storageObject;
            if (modelObjectSetEvent.getAffected() instanceof SynonymSqlServer) {
                storageObject = (SynonymSqlServer)modelObjectSetEvent.getAffected();
                this.synonyms.remove(storageObject);
                storageObject.removeObjectListener(this);
            }
            if (modelObjectSetEvent.getAffected() instanceof ColumnProxySqlServerv2k5) {
                storageObject = (ColumnProxySqlServerv2k5)modelObjectSetEvent.getAffected();
                if (this.getPartitioningColumn() == storageObject) {
                    this.setPartitioningColumn(null);
                }
            }
        }
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        super.changed(storageObject, objectChangeEvent);
        if (objectChangeEvent.getAffected() instanceof SynonymSqlServer) {
            SynonymSqlServer synonymSqlServer = (SynonymSqlServer)objectChangeEvent.getAffected();
            if (synonymSqlServer.getTable() == this) {
                synonymSqlServer.setParent(this.synonyms);
                this.synonyms.add(synonymSqlServer);
            } else {
                this.synonyms.remove(synonymSqlServer);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        super.changed(modelObjectSet, modelObjectSetEvent);
        if (modelObjectSetEvent.getAffected() instanceof SynonymSqlServer) {
            SynonymSqlServer synonymSqlServer = (SynonymSqlServer)modelObjectSetEvent.getAffected();
            synonymSqlServer.addObjectListener(this);
            if (synonymSqlServer.getTable() == this) {
                synonymSqlServer.setParent(this.synonyms);
                this.synonyms.add(synonymSqlServer);
            } else {
                this.synonyms.remove(synonymSqlServer);
            }
        } else if (modelObjectSetEvent.isType(0) && modelObjectSetEvent.getAffected() instanceof SynonymSqlServer) {
            SynonymSqlServer synonymSqlServer = (SynonymSqlServer)modelObjectSetEvent.getAffected();
            synonymSqlServer.removeObjectListener(this);
        }
    }

    public ColumnProxy getPartitioningColumn() {
        return this.partitioningColumn;
    }

    public void setPartitioningColumn(ColumnProxy columnProxy) {
        this.partitioningColumn = columnProxy;
    }

    public PartitionSchemeSqlServerv2k5 getPartitionScheme() {
        return this.partitionScheme;
    }

    public void setPartitionScheme(PartitionSchemeSqlServerv2k5 partitionSchemeSqlServerv2k5) {
        this.partitionScheme = partitionSchemeSqlServerv2k5;
    }

    @Override
    public String getLongName() {
        if (this.getSchema() != null) {
            return new StringBuffer(this.getSchema().getLongName()).append('.').append(this.getName()).toString();
        }
        ContainerObject containerObject = (ContainerObject)this.getObject();
        SchemaObject schemaObject = containerObject.getSchemaObject();
        if (schemaObject != null) {
            StorageObject storageObject = ((StorageDesignSqlServer)this.getStorageDesign()).getSchemaSet().getBySchemaObject(schemaObject);
            if (storageObject != null) {
                return new StringBuffer(storageObject.getLongName()).append('.').append(this.getName()).toString();
            }
            if (!this.getStorageDesign().isOpen()) {
                return new StringBuffer(schemaObject.getLongName()).append('.').append(this.getName()).toString();
            }
        }
        return super.getLongName();
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper("Database", this, "getDatabase", "setDatabase", DataBaseSqlServer.class));
            this.propertyWrapperList.add(new PropertyWrapper("Schema", this, "getSchema", "setSchema", SchemaSqlServer.class));
            this.propertyWrapperList.add(new PropertyWrapper("Filegroup", this, "getFilegroup", "setFilegroup", FileGroupSqlServer.class));
            this.propertyWrapperList.add(new PropertyWrapper("Partition Scheme", this, "getPartitionScheme", "setPartitionScheme", PartitionSchemeSqlServerv2k5.class));
            this.propertyWrapperList.add(new PropertyWrapper("Partition Column", this, "getPartitioningColumn", "setPartitioningColumn", ColumnProxy.class));
            this.propertyWrapperList.add(new PropertyWrapper("TEXTIMAGE group", this, "getTextImageFG", "setTextImageFG", FileGroupSqlServer.class));
        }
        return this.propertyWrapperList;
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        Table table = (Table)storageDesign.getPhysicalDesign().getTableSet().getByName(this.getObject().getName());
        TableProxySqlServerv2k5 tableProxySqlServerv2k5 = null;
        RelationalObjectProxy relationalObjectProxy = ((StorageDesignSqlServerv2k5)storageDesign).getTableProxySet().getProxy(table.getObjectID());
        if (relationalObjectProxy != null && !this.isRawObject()) {
            tableProxySqlServerv2k5 = (TableProxySqlServerv2k5)relationalObjectProxy;
        }
        if (tableProxySqlServerv2k5 != null) {
            ModelIDObject modelIDObject;
            ModelIDObject modelIDObject2;
            ModelIDObject modelIDObject32;
            tableProxySqlServerv2k5.setName(this.getName());
            Iterator iterator = this.synonyms.iterator();
            while (iterator.hasNext()) {
                modelIDObject32 = (SynonymSqlServer)iterator.next();
                modelIDObject2 = (SynonymSqlServer)((StorageDesignSqlServerv2k5)storageDesign).getSynonymSet().getByName(((StorageObject)modelIDObject32).getName());
                if (modelIDObject2 == null) {
                    modelIDObject = ((StorageDesignSqlServerv2k5)storageDesign).getSynonymSet().createSynonym();
                    modelIDObject.setName(((StorageObject)modelIDObject32).getName());
                    modelIDObject.setRawObject(true);
                    modelIDObject.setTable(tableProxySqlServerv2k5);
                    tableProxySqlServerv2k5.addSynonymsFromDesign(((StorageDesignSqlServerv2k5)storageDesign).getSynonymSet());
                    continue;
                }
                tableProxySqlServerv2k5.addSynonymsFromDesign(((StorageDesignSqlServerv2k5)storageDesign).getSynonymSet());
            }
            iterator = this.getTriggers().iterator();
            while (iterator.hasNext()) {
                modelIDObject32 = (TriggerSqlServerv2k5)iterator.next();
                modelIDObject2 = (TriggerSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getTriggerSet().getByName(((StorageObject)modelIDObject32).getName());
                if (modelIDObject2 == null) {
                    modelIDObject = (TriggerSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getTriggerSet().createTrigger();
                    modelIDObject.setName(((StorageObject)modelIDObject32).getName());
                    modelIDObject.setRawObject(true);
                    ((TriggerSqlServer)modelIDObject).setTable(tableProxySqlServerv2k5);
                    tableProxySqlServerv2k5.addTriggersFromDesign(((StorageDesignSqlServerv2k5)storageDesign).getTriggerSet());
                    continue;
                }
                tableProxySqlServerv2k5.addTriggersFromDesign(((StorageDesignSqlServerv2k5)storageDesign).getTriggerSet());
            }
            if (this.getDatabase() != null) {
                modelIDObject32 = (DataBaseSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getDataBaseSet().getByName(this.getDatabase().getName());
                if (modelIDObject32 == null) {
                    modelIDObject2 = (DataBaseSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getDataBaseSet().createDataBase();
                    ((StorageObject)modelIDObject2).setName(this.getDatabase().getName());
                    ((StorageObject)modelIDObject2).setRawObject(true);
                    tableProxySqlServerv2k5.setDatabase((DataBaseSqlServer)modelIDObject2);
                } else {
                    tableProxySqlServerv2k5.setDatabase((DataBaseSqlServer)modelIDObject32);
                }
            }
            if (this.getSchema() != null) {
                modelIDObject32 = (SchemaSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getSchemaSet().getByName(this.getSchema().getName());
                if (modelIDObject32 == null) {
                    modelIDObject2 = (SchemaSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getSchemaSet().createSchema();
                    ((StorageObject)modelIDObject2).setName(this.getSchema().getName());
                    ((StorageObject)modelIDObject2).setRawObject(true);
                    tableProxySqlServerv2k5.setSchema((SchemaSqlServer)modelIDObject2);
                } else {
                    tableProxySqlServerv2k5.setSchema((SchemaSqlServer)modelIDObject32);
                }
            }
            if (this.getFilegroup() != null) {
                modelIDObject32 = (FileGroupSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getFileGroupSet().getByName(this.getFilegroup().getName());
                if (modelIDObject32 == null) {
                    modelIDObject2 = (FileGroupSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getFileGroupSet().createFileGroup();
                    ((StorageObject)modelIDObject2).setName(this.getFilegroup().getName());
                    ((StorageObject)modelIDObject2).setRawObject(true);
                    tableProxySqlServerv2k5.setFilegroup((FileGroupSqlServer)modelIDObject2);
                } else {
                    tableProxySqlServerv2k5.setFilegroup((FileGroupSqlServer)modelIDObject32);
                }
            }
            if (this.getPartitionScheme() != null) {
                modelIDObject32 = (PartitionSchemeSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getPartitionSchemeSet().getByName(this.getPartitionScheme().getName());
                if (modelIDObject32 == null) {
                    modelIDObject2 = (PartitionSchemeSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getPartitionSchemeSet().createPartitionScheme();
                    ((StorageObject)modelIDObject2).setName(this.getPartitionScheme().getName());
                    ((StorageObject)modelIDObject2).setRawObject(true);
                    tableProxySqlServerv2k5.setPartitionScheme((PartitionSchemeSqlServerv2k5)modelIDObject2);
                } else {
                    tableProxySqlServerv2k5.setPartitionScheme((PartitionSchemeSqlServerv2k5)modelIDObject32);
                }
            }
            if (this.getPartitioningColumn() != null) {
                modelIDObject32 = (ColumnProxySqlServerv2k5)((ColumnProxySetSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getColumnProxySet()).getByName(this.getPartitioningColumn().getName());
                if (modelIDObject32 == null) {
                    modelIDObject2 = (ColumnProxySqlServerv2k5)((ColumnProxySetSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getColumnProxySet()).createProxy(this.getPartitioningColumn().getObject());
                    ((RelationalObjectProxy)modelIDObject2).setName(this.getPartitioningColumn().getName());
                    ((StorageObject)modelIDObject2).setRawObject(true);
                    tableProxySqlServerv2k5.setPartitioningColumn((ColumnProxy)modelIDObject2);
                } else {
                    tableProxySqlServerv2k5.setPartitioningColumn((ColumnProxy)modelIDObject32);
                }
            }
            if (this.getTextImageFG() != null) {
                modelIDObject32 = (FileGroupSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getFileGroupSet().getByName(this.getTextImageFG().getName());
                if (modelIDObject32 == null) {
                    modelIDObject2 = (FileGroupSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getFileGroupSet().createFileGroup();
                    ((StorageObject)modelIDObject2).setName(this.getTextImageFG().getName());
                    ((StorageObject)modelIDObject2).setRawObject(true);
                    tableProxySqlServerv2k5.setTextImageFG((FileGroupSqlServer)modelIDObject2);
                } else {
                    tableProxySqlServerv2k5.setTextImageFG((FileGroupSqlServer)modelIDObject32);
                }
            }
            for (ModelIDObject modelIDObject32 : ((Table)this.getObject()).getCheckConstraints()) {
                modelIDObject2 = (Table)tableProxySqlServerv2k5.getObject();
                modelIDObject = ((Table)modelIDObject2).createCheckConstraint(((DesignObject)modelIDObject32).getName(), ((TableLevelConstraint)modelIDObject32).getRule());
                ((Table)modelIDObject2).getCheckConstraints().add(modelIDObject);
            }
            tableProxySqlServerv2k5.recreateExtPropertiesSet(this.getExtPropsSet().toString());
            tableProxySqlServerv2k5.setComment(this.getComment());
            tableProxySqlServerv2k5.setCommentInRDBMS(this.getCommentInRDBMS());
            tableProxySqlServerv2k5.setRawObject(false);
        }
    }

    @Override
    public StorageObject getUserSchema() {
        return this.getSchema();
    }
}

