/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver.v2k5;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.RelationalObjectProxySetListener;
import oracle.dbtools.crest.model.datatype.sqlserver.MDXMLTypeSqlServer;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerObjectEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.IndexProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PartitionSchemeSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SecondaryXmlIndexSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.ColumnProxySetSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.ColumnProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.FileGroupSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PartitionSchemeSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SecondaryXmlIndexSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.XMLIndexCollection;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5.IndexPropertyDialogSqlServerv2k5;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class IndexProxySqlServerv2k5
extends IndexProxySqlServer
implements ModelObjectSetListener,
StorageObjectListener,
RelationalObjectProxySetListener {
    public static final String[] ON_OFF_CHOICES = new String[]{"ON", "OFF"};
    private String allowRowLocks = "ON";
    private String allowPageLocks = "ON";
    private String onlineChoise = "ON";
    private int maxdop = 0;
    private PartitionSchemeSqlServer partitionScheme = null;
    private StorageObjectCollection secondaryXmlIndex = null;
    public static final String REGULAR = "Regular";
    public static final String PRIMARY_XML = "Primary XML";
    public static final String SECONDARY_XML = "Secondary XML";
    private ColumnProxy partitioningColumn = null;
    private IncludeColumns includeColumnsSet = null;
    private String includeColumns = "";
    private String dropExisting = "ON";
    private String recomputeStatistics = "ON";
    private List propertyWrapperList = null;

    public IndexProxySqlServerv2k5(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
    }

    public IndexProxySqlServerv2k5(Index index, StorageDesign storageDesign) {
        super(index, storageDesign);
        this.secondaryXmlIndex = new XMLIndexCollection(((StorageDesignSqlServerv2k5)storageDesign).getSecondaryXmlIndexSetv2k5());
        this.secondaryXmlIndex.setParent(this);
        this.secondaryXmlIndex.setName(Messages.getString("IndexProxySqlServerv2k5.SecondaryXmlIndex"));
        this.secondaryXmlIndex.setClassForParent(IndexProxySqlServer.class);
        this.secondaryXmlIndex.setSetMethod("setPrimaryXmlIndex");
        this.secondaryXmlIndex.setForbiddenCreateElement(!this.isPrimaryXmlIndex());
        ((StorageDesignSqlServerv2k5)storageDesign).getSecondaryXmlIndexSetv2k5().addSetListener(this);
        ((StorageDesignSqlServerv2k5)storageDesign).getColumnProxySet().addSetListener(this);
        index.getContainerObject().addObjectListener(this);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            IndexPropertyDialogSqlServerv2k5 indexPropertyDialogSqlServerv2k5 = new IndexPropertyDialogSqlServerv2k5(this.getDesign().getAppView(), this.getStorageDesign(), this);
            indexPropertyDialogSqlServerv2k5.show();
        }
    }

    public String getAllowPageLocks() {
        return this.allowPageLocks;
    }

    public void setAllowPageLocks(String string) {
        this.allowPageLocks = string;
    }

    public String getAllowRowLocks() {
        return this.allowRowLocks;
    }

    public void setAllowRowLocks(String string) {
        this.allowRowLocks = string;
    }

    public int getMaxdop() {
        return this.maxdop;
    }

    public void setMaxdop(int n) {
        if (n >= 0 && n <= 64) {
            this.maxdop = n;
        }
    }

    public String getOnlineChoise() {
        return this.onlineChoise;
    }

    public void setOnlineChoise(String string) {
        this.onlineChoise = string;
    }

    public PartitionSchemeSqlServer getPartitionScheme() {
        return this.partitionScheme;
    }

    public void setPartitionScheme(PartitionSchemeSqlServer partitionSchemeSqlServer) {
        this.partitionScheme = partitionSchemeSqlServer;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.secondaryXmlIndex) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.secondaryXmlIndex) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.secondaryXmlIndex;
            }
        }
        return null;
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof SecondaryXmlIndexSqlServer) {
            SecondaryXmlIndexSqlServer secondaryXmlIndexSqlServer = (SecondaryXmlIndexSqlServer)objectChangeEvent.getAffected();
            this.secondaryXmlIndex.setForbiddenCreateElement(!this.isPrimaryXmlIndex());
            if (secondaryXmlIndexSqlServer.getPrimaryXmlIndex() != null && secondaryXmlIndexSqlServer.getPrimaryXmlIndex() == this) {
                secondaryXmlIndexSqlServer.setParent(this.partitionScheme);
                this.secondaryXmlIndex.add(secondaryXmlIndexSqlServer);
            } else {
                this.secondaryXmlIndex.remove(secondaryXmlIndexSqlServer);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof SecondaryXmlIndexSqlServer) {
                SecondaryXmlIndexSqlServer secondaryXmlIndexSqlServer = (SecondaryXmlIndexSqlServer)modelObjectSetEvent.getAffected();
                secondaryXmlIndexSqlServer.addObjectListener(this);
                if (secondaryXmlIndexSqlServer.getPrimaryXmlIndex() != null && secondaryXmlIndexSqlServer.getPrimaryXmlIndex() == this) {
                    secondaryXmlIndexSqlServer.setParent(this.partitionScheme);
                    this.secondaryXmlIndex.add(secondaryXmlIndexSqlServer);
                } else {
                    this.secondaryXmlIndex.remove(secondaryXmlIndexSqlServer);
                }
            }
        } else if (modelObjectSetEvent.isType(0) && modelObjectSetEvent.getAffected() instanceof SecondaryXmlIndexSqlServer) {
            SecondaryXmlIndexSqlServer secondaryXmlIndexSqlServer = (SecondaryXmlIndexSqlServer)modelObjectSetEvent.getAffected();
            this.secondaryXmlIndex.remove(secondaryXmlIndexSqlServer);
            secondaryXmlIndexSqlServer.removeObjectListener(this);
        }
    }

    @Override
    public void clearChildren() {
        this.secondaryXmlIndex.removeAll();
    }

    public boolean isPrimaryXmlIndex() {
        if (this.getColumnProxies().length == 1) {
            ColumnProxySqlServerv2k5 columnProxySqlServerv2k5 = (ColumnProxySqlServerv2k5)this.getColumnProxies()[0];
            return columnProxySqlServerv2k5 != null && columnProxySqlServerv2k5.getDataType() instanceof MDXMLTypeSqlServer && !columnProxySqlServerv2k5.getComputed();
        }
        return false;
    }

    public boolean isSecondaryXmlIndex() {
        if (this.isPrimaryXmlIndex()) {
            return this.secondaryXmlIndex.size() > 0;
        }
        return false;
    }

    public boolean isRegularIndex() {
        return !this.isPrimaryXmlIndex() && !this.isSecondaryXmlIndex();
    }

    public String getIndexType() {
        if (this.isPrimaryXmlIndex()) {
            if (this.isSecondaryXmlIndex()) {
                return SECONDARY_XML;
            }
            return PRIMARY_XML;
        }
        return REGULAR;
    }

    public ColumnProxy getPartitioningColumn() {
        return this.partitioningColumn;
    }

    public void setPartitioningColumn(ColumnProxy columnProxy) {
        this.partitioningColumn = columnProxy;
    }

    public String getIncludeColumns() {
        return this.includeColumns;
    }

    public void setIncludeColumns(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateIncludeColumnsSet(string);
        } else {
            this.addIncludeColumnsValue(string);
        }
        this.includeColumns = this.getIncludeColumnsSet().toString();
        this.fireDataFieldChange();
    }

    private void addIncludeColumnsValue(String string) {
        this.getIncludeColumnsSet().add(string);
    }

    private void recreateIncludeColumnsSet(String string) {
        this.getIncludeColumnsSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.includeColumnsSet = new IncludeColumns();
        while (stringTokenizer.hasMoreTokens()) {
            this.getIncludeColumnsSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public IncludeColumns getIncludeColumnsSet() {
        if (this.includeColumnsSet == null) {
            this.includeColumnsSet = new IncludeColumns();
        }
        return this.includeColumnsSet;
    }

    @Override
    public void clear() {
        if (this.includeColumnsSet != null) {
            this.includeColumnsSet.removeAllElements();
            this.includeColumns = "";
        }
    }

    @Override
    public void changed(RelationalObjectProxySet relationalObjectProxySet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(0) && modelObjectSetEvent.getAffected() instanceof ColumnProxySqlServerv2k5) {
            ColumnProxySqlServerv2k5 columnProxySqlServerv2k5 = (ColumnProxySqlServerv2k5)modelObjectSetEvent.getAffected();
            if (this.getIncludeColumnsSet().contains(columnProxySqlServerv2k5.getObjectID())) {
                this.getIncludeColumnsSet().remove(columnProxySqlServerv2k5.getObjectID());
                this.includeColumns = this.getIncludeColumnsSet().toString();
            }
            if (this.getPartitioningColumn() == columnProxySqlServerv2k5) {
                this.setPartitioningColumn(null);
            }
        }
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        if (this.getObject() == designObject && objectChangeEvent.isType(ObjectChangeEvent.NAME_CHANGED) && !this.isNameChanged()) {
            this.setName(designObject.getName());
        }
        if (objectChangeEvent.getAffected() instanceof Table) {
            Table table = (Table)objectChangeEvent.getAffected();
            if (this.getTable() == table) {
                if (!this.isPrimaryXmlIndex()) {
                    this.secondaryXmlIndex.removeAll();
                    this.secondaryXmlIndex.setForbiddenCreateElement(true);
                } else {
                    this.secondaryXmlIndex.setForbiddenCreateElement(false);
                }
            }
        }
        if (objectChangeEvent.isType(ObjectChangeEvent.KEY_CHANGED_TO_PK)) {
            this.getStorageDesign().getIndexProxySet().remove(this);
            ((StorageDesignSqlServer)this.getStorageDesign()).getPKProxySet().add(designObject);
            this.fireChangeNoDirty(objectChangeEvent);
        } else if (objectChangeEvent.isType(ObjectChangeEvent.ADD_FK)) {
            this.getStorageDesign().getIndexProxySet().remove(this);
            ((StorageDesignSqlServer)this.getStorageDesign()).getFKProxySet().add(designObject);
            this.fireChangeNoDirty(objectChangeEvent);
        } else if (objectChangeEvent.isType(ObjectChangeEvent.KEY_CHANGED_TO_UNIQUE)) {
            this.getStorageDesign().getIndexProxySet().remove(this);
            ((StorageDesignSqlServer)this.getStorageDesign()).getUniqueProxySet().add(designObject);
            this.fireChangeNoDirty(objectChangeEvent);
        }
    }

    public void changed(ContainerObject containerObject, ContainerObjectEvent containerObjectEvent) {
        if (containerObject == this.getObject()) {
            if (!this.isPrimaryXmlIndex()) {
                this.secondaryXmlIndex.removeAll();
                this.secondaryXmlIndex.setForbiddenCreateElement(true);
            } else {
                this.secondaryXmlIndex.setForbiddenCreateElement(false);
            }
        }
    }

    public StorageObjectCollection getSecondaryXMLIndexs() {
        return this.secondaryXmlIndex;
    }

    public SecondaryXmlIndexSqlServer createSecondaryXMLIndex() {
        if (this.secondaryXmlIndex.getStorageObjectSet() != null) {
            return (SecondaryXmlIndexSqlServer)this.secondaryXmlIndex.createElement(null);
        }
        return null;
    }

    public String getDropExisting() {
        return this.dropExisting;
    }

    public void setDropExisting(String string) {
        this.dropExisting = string;
    }

    @Override
    public String getRecomputeStatistics() {
        return this.recomputeStatistics;
    }

    @Override
    public void setRecomputeStatistics(String string) {
        this.recomputeStatistics = string;
        this.fireDataFieldChange();
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper("Clustered", this, "isClustered", "setClustered", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Filegroup", this, "getFilegroup", "setFilegroup", FileGroupSqlServer.class));
            this.propertyWrapperList.add(new PropertyWrapper("Partition Scheme", this, "getPartitionScheme", "setPartitionScheme", PartitionSchemeSqlServer.class));
            this.propertyWrapperList.add(new PropertyWrapper("Partitioning Column", this, "getPartitioningColumn", "setPartitioningColumn", ColumnProxy.class));
            this.propertyWrapperList.add(new PropertyWrapper("Pad Index", this, "getPadIndex", "setPadIndex", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Fill Factor[0,100]", this, "getFillFactor", "setFillFactor", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Recompute Stat", this, "getRecomputeStatistics", "setRecomputeStatistics", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Sort in temp DB", this, "getSortInTempDB", "setSortInTempDB", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Allow Row Locks", this, "getAllowRowLocks", "setAllowRowLocks", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Allow Page Locks", this, "getAllowPageLocks", "setAllowPageLocks", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("MaxDop[0,64]", this, "getMaxdop", "setMaxdop", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Online", this, "getOnlineChoise", "setOnlineChoise", String.class));
        }
        return this.propertyWrapperList;
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        Index index = (Index)storageDesign.getPhysicalDesign().getTableSet().getGlobalIndexSet().getByName(this.getObject().getName());
        IndexProxySqlServerv2k5 indexProxySqlServerv2k5 = null;
        RelationalObjectProxy relationalObjectProxy = ((StorageDesignSqlServerv2k5)storageDesign).getIndexProxySet().getProxy(index.getObjectID());
        if (relationalObjectProxy != null && !this.isRawObject()) {
            indexProxySqlServerv2k5 = (IndexProxySqlServerv2k5)relationalObjectProxy;
        }
        if (indexProxySqlServerv2k5 != null) {
            StorageObject storageObject;
            StorageObject storageObject2;
            indexProxySqlServerv2k5.setName(this.getName());
            Iterator iterator = this.getSecondaryXMLIndexs().iterator();
            while (iterator.hasNext()) {
                storageObject2 = (SecondaryXmlIndexSqlServerv2k5)iterator.next();
                storageObject = (SecondaryXmlIndexSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getSecondaryXmlIndexSetv2k5().getByName(storageObject2.getName());
                if (storageObject == null) {
                    SecondaryXmlIndexSqlServerv2k5 secondaryXmlIndexSqlServerv2k5 = (SecondaryXmlIndexSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getSecondaryXmlIndexSetv2k5().createXmlIndex();
                    secondaryXmlIndexSqlServerv2k5.setName(storageObject2.getName());
                    secondaryXmlIndexSqlServerv2k5.setRawObject(true);
                    indexProxySqlServerv2k5.getSecondaryXMLIndexs().add(secondaryXmlIndexSqlServerv2k5);
                    continue;
                }
                indexProxySqlServerv2k5.getSecondaryXMLIndexs().add(storageObject);
            }
            indexProxySqlServerv2k5.setClustered(this.isClustered());
            if (this.getFilegroup() != null) {
                storageObject2 = (FileGroupSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getFileGroupSet().getByName(this.getFilegroup().getName());
                if (storageObject2 == null) {
                    storageObject = (FileGroupSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getFileGroupSet().createFileGroup();
                    storageObject.setName(this.getFilegroup().getName());
                    storageObject.setRawObject(true);
                    indexProxySqlServerv2k5.setFilegroup((FileGroupSqlServer)storageObject);
                } else {
                    indexProxySqlServerv2k5.setFilegroup((FileGroupSqlServer)storageObject2);
                }
            }
            if (this.getPartitionScheme() != null) {
                storageObject2 = (PartitionSchemeSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getPartitionSchemeSet().getByName(this.getPartitionScheme().getName());
                if (storageObject2 == null) {
                    storageObject = (PartitionSchemeSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getPartitionSchemeSet().createPartitionScheme();
                    storageObject.setName(this.getPartitionScheme().getName());
                    storageObject.setRawObject(true);
                    indexProxySqlServerv2k5.setPartitionScheme((PartitionSchemeSqlServer)storageObject);
                } else {
                    indexProxySqlServerv2k5.setPartitionScheme((PartitionSchemeSqlServer)storageObject2);
                }
            }
            if (this.getPartitioningColumn() != null) {
                storageObject2 = (ColumnProxySqlServerv2k5)((ColumnProxySetSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getColumnProxySet()).getByName(this.getPartitioningColumn().getName());
                if (storageObject2 == null) {
                    storageObject = (ColumnProxySqlServerv2k5)((ColumnProxySetSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getColumnProxySet()).createProxy(this.getPartitioningColumn().getObject());
                    ((RelationalObjectProxy)storageObject).setName(this.getPartitioningColumn().getName());
                    storageObject.setRawObject(true);
                    indexProxySqlServerv2k5.setPartitioningColumn((ColumnProxy)storageObject);
                } else {
                    indexProxySqlServerv2k5.setPartitioningColumn((ColumnProxy)storageObject2);
                }
            }
            indexProxySqlServerv2k5.setPadIndex(this.getPadIndex());
            indexProxySqlServerv2k5.setFillFactor(this.getFillFactor());
            indexProxySqlServerv2k5.setRecomputeStatistics(this.getRecomputeStatistics());
            indexProxySqlServerv2k5.setSortInTempDB(this.getSortInTempDB());
            indexProxySqlServerv2k5.setIgnoreDupKey(this.getIgnoreDupKey());
            indexProxySqlServerv2k5.setAllowRowLocks(this.getAllowRowLocks());
            indexProxySqlServerv2k5.setAllowPageLocks(this.getAllowPageLocks());
            indexProxySqlServerv2k5.setMaxdop(this.getMaxdop());
            indexProxySqlServerv2k5.setOnlineChoise(this.getOnlineChoise());
            indexProxySqlServerv2k5.setDropExisting(this.getDropExisting());
            indexProxySqlServerv2k5.recreateExtPropertiesSet(this.getExtPropsSet().toString());
            indexProxySqlServerv2k5.recreateIncludeColumnsSet(this.getIncludeColumnsSet().toString());
            indexProxySqlServerv2k5.setComment(this.getComment());
            indexProxySqlServerv2k5.setCommentInRDBMS(this.getCommentInRDBMS());
            indexProxySqlServerv2k5.setRawObject(false);
        }
    }

    @Override
    public void clearMergableStructure(Map map) {
        if (map != null) {
            ArrayList arrayList = new ArrayList();
            this.secondaryXmlIndex.addAllElementsTo(arrayList);
            for (StorageObject storageObject : arrayList) {
                if (map.get(storageObject.getObjectID()) != null) continue;
                storageObject.remove(true);
            }
        }
    }

    @Override
    public String getLongName() {
        return this.getName();
    }

    public void resetSecXMLIndexStatus() {
        this.secondaryXmlIndex.setForbiddenCreateElement(!this.isPrimaryXmlIndex());
    }

    public class IncludeColumns
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

