/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver.v2k5;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectPlaceHolder;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataFileSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DefaultSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DistinctTypeProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PartitionFunctionSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RuleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StoredProcedureSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UsedUserDefinedData;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.XMLSchemaCollectionSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataFileSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DefaultSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DistinctTypeProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.FileGroupSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PartitionFunctionSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.RoleSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.RuleSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StoredProcedureSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableProxySetSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableViewProxySetSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableViewProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UsedUserDefinedDatav2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UserDefinedTypeSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UserSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.XMLSchemaCollectionSqlServerv2k5;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5.DataBasePropertyDialogSqlServerv2k5;

public class DataBaseSqlServerv2k5
extends DataBaseSqlServer {
    private StorageObjectCollection transactionLogs;
    private StorageObjectCollection filegroups;
    private StorageObjectCollection defaults;
    private StorageObjectCollection users;
    private StorageObjectCollection schemas;
    private StorageObjectCollection roles;
    private StorageObjectCollection rules;
    private StorageObjectCollection procedures;
    private StorageObjectCollection tables;
    private StorageObjectCollection views;
    private StorageObjectCollection distinctTypes;
    private StorageObjectCollection userDefinedDomains;
    private StorageObjectCollection partitionFunction;
    private StorageObjectCollection xmlSchemaCollections;
    private static final String[] USER_STATES = new String[]{"SINGLE_USER", "RESTRICTED_USER", "MULTI_USER"};
    private static Set userSet = null;
    private static final String[] ON_OFF_STATES = new String[]{"ON", "OFF"};
    private static Set onOffSet = null;
    private static final String[] CURSOR_DEFAULT_STATES = new String[]{"LOCAL", "GLOBAL"};
    private static Set cursorDefaultSet = null;
    private static final String[] RECOVERY_STATES = new String[]{"FULL", "BULK_LOGGED", "SIMPLE"};
    private static Set recoverySet = null;
    private String userState = "MULTI_USER";
    private String collationName = " ";
    private String cursorCloseOnCommit = "ON";
    private String cursorDefault = "GLOBAL";
    private String autoClose = "ON";
    private String autoCreateStatistics = "ON";
    private String autoUpdateStatistics = "ON";
    private String autoShrink = "ON";
    private String recovery = "FULL";
    private String tornPageDetection = "ON";
    private String ansiNulls = "OFF";
    private String ansiPadding = "";
    private String ansiWarnings = "";
    private String arithabort = "";
    private String concatNullYieldsNull = "";
    private String numericRoundabort = "";
    private String quotedIdentifier = "OFF";
    private String recursiveTriggers = "";

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            DataBasePropertyDialogSqlServerv2k5 dataBasePropertyDialogSqlServerv2k5 = new DataBasePropertyDialogSqlServerv2k5(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dataBasePropertyDialogSqlServerv2k5.show();
        }
    }

    public DataBaseSqlServerv2k5(StorageDesign storageDesign) {
        super(storageDesign);
        StorageDesignSqlServerv2k5 storageDesignSqlServerv2k5 = (StorageDesignSqlServerv2k5)storageDesign;
        this.filegroups = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getFileGroupSet());
        this.filegroups.setParent(this);
        this.filegroups.setName(Messages.getString("DataBaseSqlServer.FileGroups"));
        this.filegroups.setSetMethod("setDataBase");
        this.filegroups.setClassForParent(DataBaseSqlServer.class);
        this.filegroups.setIcon(GUIConfiguration.getInstance().getIcon("GROUP_ICON", 16));
        this.transactionLogs = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getDataFileSet());
        this.transactionLogs.setParent(this);
        this.transactionLogs.setName(Messages.getString("DataBaseSqlServer.LogsFiles"));
        this.transactionLogs.setSetMethod("setDataBase");
        this.transactionLogs.setClassForParent(DataBaseSqlServer.class);
        this.transactionLogs.setIcon(GUIConfiguration.getInstance().getIcon("DATAFILE_ICON", 16));
        this.defaults = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getDefaultSet());
        this.defaults.setParent(this);
        this.defaults.setName(Messages.getString("DataBaseSqlServer.Defaults"));
        this.defaults.setSetMethod("setDataBase");
        this.defaults.setClassForParent(DataBaseSqlServer.class);
        this.defaults.setIcon(GUIConfiguration.getInstance().getIcon("DEFAULT_ICON", 16));
        this.users = new StorageObjectCollection();
        this.users.setParent(this);
        this.users.setName(Messages.getString("StorageDesignOracle.Users"));
        this.users.setSetMethod("setDatabase");
        this.users.setClassForParent(DataBaseSqlServer.class);
        this.users.setIcon(GUIConfiguration.getInstance().getIcon("USER_FOLDER_ICON", 16));
        this.schemas = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getSchemaSet());
        this.schemas.setParent(this);
        this.schemas.setName(Messages.getString("RelationalDesign.Schemas"));
        this.schemas.setSetMethod("setDatabase");
        this.schemas.setClassForParent(DataBaseSqlServer.class);
        this.schemas.setIcon(GUIConfiguration.getInstance().getIcon("SCHEMA_FOLDER_ICON", 16));
        this.roles = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getRoleSet());
        this.roles.setParent(this);
        this.roles.setName(Messages.getString("StorageDesignOracle.Roles"));
        this.roles.setSetMethod("setDatabase");
        this.roles.setClassForParent(DataBaseSqlServer.class);
        this.roles.setIcon(GUIConfiguration.getInstance().getIcon("ROLE_ICON", 16));
        this.rules = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getRuleSet());
        this.rules.setParent(this);
        this.rules.setName(Messages.getString("DataBaseSqlServer.Rules"));
        this.rules.setSetMethod("setDatabase");
        this.rules.setClassForParent(DataBaseSqlServer.class);
        this.rules.setIcon(GUIConfiguration.getInstance().getIcon("RULE_ICON", 16));
        this.partitionFunction = new StorageObjectCollection(storageDesignSqlServerv2k5.getPartitionFunctionSet());
        this.partitionFunction.setParent(this);
        this.partitionFunction.setName(Messages.getString("DataBaseSqlServerv2k5.PartitionFunctions"));
        this.partitionFunction.setSetMethod("setDatabase");
        this.partitionFunction.setClassForParent(DataBaseSqlServer.class);
        this.partitionFunction.setIcon(GUIConfiguration.getInstance().getIcon("FUNCTION_FOLDER_ICON", 16));
        this.tables = new StorageObjectCollection();
        this.tables.setParent(this);
        this.tables.setName(Messages.getString("StorageDesignOracle.Tables"));
        this.tables.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON", 16));
        this.registerToTableProxyFromDesign(storageDesign.getTableProxySet());
        storageDesign.getTableProxySet().addSetListener(this);
        this.views = new StorageObjectCollection();
        this.views.setParent(this);
        this.views.setName(Messages.getString("StorageDesignOracle.Views"));
        this.views.setIcon(GUIConfiguration.getInstance().getIcon("VIEW_FOLDER_ICON", 16));
        this.registerToViewProxyFromDesign(storageDesign.getTableViewProxySet());
        storageDesign.getTableViewProxySet().addSetListener(this);
        this.procedures = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getStoredProcedureSet());
        this.procedures.setParent(this);
        this.procedures.setName(Messages.getString("StorageDesignOracle.StoredProcedures"));
        this.procedures.setSetMethod("setDatabase");
        this.procedures.setClassForParent(DataBaseSqlServer.class);
        this.procedures.setIcon(GUIConfiguration.getInstance().getIcon("PROCEDURE_FOLDER_ICON", 16));
        this.distinctTypes = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getUsedUserDefinedDataSet());
        this.distinctTypes.setForbiddenCreateElement(true);
        this.distinctTypes.setParent(this);
        this.distinctTypes.setName(Messages.getString("StorageDesignSqlServerv2k5.UDDTDistinctTypes"));
        this.distinctTypes.setSetMethod("setDatabase");
        this.distinctTypes.setClassForParent(DataBaseSqlServer.class);
        this.distinctTypes.setIcon(GUIConfiguration.getInstance().getIcon("STRUCTURED_TYPE_ICON", 16));
        this.userDefinedDomains = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getUsedUserDefinedDataSet());
        this.userDefinedDomains.setForbiddenCreateElement(true);
        this.userDefinedDomains.setParent(this);
        this.userDefinedDomains.setName(Messages.getString("StorageDesignSqlServerv2k5.UDDTDomains"));
        this.userDefinedDomains.setSetMethod("setDatabase");
        this.userDefinedDomains.setClassForParent(DataBaseSqlServer.class);
        this.userDefinedDomains.setIcon(GUIConfiguration.getInstance().getIcon("DOMAIN_ICON", 16));
        this.xmlSchemaCollections = new StorageObjectCollection(storageDesignSqlServerv2k5.getXmlSchemaCollectionSet());
        this.xmlSchemaCollections.setParent(this);
        this.xmlSchemaCollections.setName(Messages.getString("DataBaseSqlServerv2k5.XMLSchemaCollections"));
        this.xmlSchemaCollections.setSetMethod("setDatabase");
        this.xmlSchemaCollections.setClassForParent(DataBaseSqlServer.class);
        this.xmlSchemaCollections.setIcon(GUIConfiguration.getInstance().getIcon("XML_FILE_ICON", 16));
        storageDesignSqlServerv2k5.getDataFileSet().addSetListener(this);
        storageDesignSqlServerv2k5.getFileGroupSet().addSetListener(this);
        storageDesignSqlServerv2k5.getDefaultSet().addSetListener(this);
        storageDesignSqlServerv2k5.getUserSet().addSetListener(this);
        storageDesignSqlServerv2k5.getSchemaSet().addSetListener(this);
        storageDesignSqlServerv2k5.getRoleSet().addSetListener(this);
        storageDesignSqlServerv2k5.getRuleSet().addSetListener(this);
        storageDesignSqlServerv2k5.getStoredProcedureSet().addSetListener(this);
        storageDesignSqlServerv2k5.getDistinctTypeProxySet().addSetListener(this);
        storageDesignSqlServerv2k5.getUserDefinedTypeSet().addSetListener(this);
        storageDesignSqlServerv2k5.getUsedUserDefinedDataSet().addSetListener(this);
        storageDesignSqlServerv2k5.getPartitionFunctionSet().addSetListener(this);
        storageDesignSqlServerv2k5.getXmlSchemaCollectionSet().addSetListener(this);
    }

    @Override
    public String getObjectTypeName() {
        return "DataBase";
    }

    @Override
    public String getIDPrefix() {
        return "DB";
    }

    @Override
    public int getNumberOfChildren() {
        return 14;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.filegroups;
            }
            case 1: {
                return this.transactionLogs;
            }
            case 2: {
                return this.defaults;
            }
            case 3: {
                return this.users;
            }
            case 4: {
                return this.schemas;
            }
            case 5: {
                return this.roles;
            }
            case 6: {
                return this.rules;
            }
            case 7: {
                return this.tables;
            }
            case 8: {
                return this.views;
            }
            case 9: {
                return this.partitionFunction;
            }
            case 10: {
                return this.procedures;
            }
            case 11: {
                return this.distinctTypes;
            }
            case 12: {
                return this.userDefinedDomains;
            }
            case 13: {
                return this.xmlSchemaCollections;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.filegroups) {
            return 0;
        }
        if (modelObject == this.transactionLogs) {
            return 1;
        }
        if (modelObject == this.defaults) {
            return 2;
        }
        if (modelObject == this.users) {
            return 3;
        }
        if (modelObject == this.schemas) {
            return 4;
        }
        if (modelObject == this.roles) {
            return 5;
        }
        if (modelObject == this.rules) {
            return 6;
        }
        if (modelObject == this.tables) {
            return 7;
        }
        if (modelObject == this.views) {
            return 8;
        }
        if (modelObject == this.partitionFunction) {
            return 9;
        }
        if (modelObject == this.procedures) {
            return 10;
        }
        if (modelObject == this.distinctTypes) {
            return 11;
        }
        if (modelObject == this.userDefinedDomains) {
            return 12;
        }
        if (modelObject == this.xmlSchemaCollections) {
            return 13;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.filegroups) {
            return 0;
        }
        if (object == this.transactionLogs) {
            return 1;
        }
        if (object == this.defaults) {
            return 2;
        }
        if (object == this.users) {
            return 3;
        }
        if (object == this.schemas) {
            return 4;
        }
        if (object == this.roles) {
            return 5;
        }
        if (object == this.rules) {
            return 6;
        }
        if (object == this.tables) {
            return 7;
        }
        if (object == this.views) {
            return 8;
        }
        if (object == this.partitionFunction) {
            return 9;
        }
        if (object == this.procedures) {
            return 10;
        }
        if (object == this.distinctTypes) {
            return 11;
        }
        if (object == this.userDefinedDomains) {
            return 12;
        }
        if (object == this.xmlSchemaCollections) {
            return 13;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void clearChildren() {
        this.filegroups.removeAll();
        this.transactionLogs.removeAll();
        this.defaults.removeAll();
        this.users.removeAll();
        this.schemas.removeAll();
        this.roles.removeAll();
        this.rules.removeAll();
        this.tables.removeAll();
        this.views.removeAll();
        this.procedures.removeAll();
        this.distinctTypes.removeAll();
        this.userDefinedDomains.removeAll();
        this.partitionFunction.removeAll();
        this.xmlSchemaCollections.removeAll();
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof DataFileSqlServer) {
                DataFileSqlServer dataFileSqlServer = (DataFileSqlServer)modelObjectSetEvent.getAffected();
                dataFileSqlServer.addObjectListener(this);
                if (dataFileSqlServer.getDataBase() != null && dataFileSqlServer.getDataBase() == this) {
                    dataFileSqlServer.setParent(this.transactionLogs);
                    this.transactionLogs.add(dataFileSqlServer);
                } else {
                    this.transactionLogs.remove(dataFileSqlServer);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof FileGroupSqlServer) {
                FileGroupSqlServer fileGroupSqlServer = (FileGroupSqlServer)modelObjectSetEvent.getAffected();
                fileGroupSqlServer.addObjectListener(this);
                if (fileGroupSqlServer.getDataBase() != null && fileGroupSqlServer.getDataBase() == this) {
                    fileGroupSqlServer.setParent(this.filegroups);
                    this.filegroups.add(fileGroupSqlServer);
                } else {
                    this.filegroups.remove(fileGroupSqlServer);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof DefaultSqlServer) {
                DefaultSqlServer defaultSqlServer = (DefaultSqlServer)modelObjectSetEvent.getAffected();
                defaultSqlServer.addObjectListener(this);
                if (defaultSqlServer.getDataBase() != null && defaultSqlServer.getDataBase() == this) {
                    defaultSqlServer.setParent(this.defaults);
                    this.defaults.add(defaultSqlServer);
                } else {
                    this.defaults.remove(defaultSqlServer);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof UserSqlServer) {
                UserSqlServer userSqlServer = (UserSqlServer)modelObjectSetEvent.getAffected();
                userSqlServer.addObjectListener(this);
                if (userSqlServer.getDatabase() != null && userSqlServer.getDatabase() == this) {
                    userSqlServer.setParent(this.users);
                    this.users.add(userSqlServer);
                } else {
                    this.users.remove(userSqlServer);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof SchemaSqlServer) {
                SchemaSqlServer schemaSqlServer = (SchemaSqlServer)modelObjectSetEvent.getAffected();
                schemaSqlServer.addObjectListener(this);
                if (schemaSqlServer.getDatabase() != null && schemaSqlServer.getDatabase() == this) {
                    schemaSqlServer.setParent(this.schemas);
                    this.schemas.add(schemaSqlServer);
                } else {
                    this.schemas.remove(schemaSqlServer);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof RoleSqlServer) {
                RoleSqlServer roleSqlServer = (RoleSqlServer)modelObjectSetEvent.getAffected();
                roleSqlServer.addObjectListener(this);
                if (roleSqlServer.getDatabase() != null && roleSqlServer.getDatabase() == this) {
                    roleSqlServer.setParent(this.roles);
                    this.roles.add(roleSqlServer);
                } else {
                    this.roles.remove(roleSqlServer);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof RuleSqlServer) {
                RuleSqlServer ruleSqlServer = (RuleSqlServer)modelObjectSetEvent.getAffected();
                ruleSqlServer.addObjectListener(this);
                if (ruleSqlServer.getDatabase() != null && ruleSqlServer.getDatabase() == this) {
                    ruleSqlServer.setParent(this.rules);
                    this.rules.add(ruleSqlServer);
                } else {
                    this.rules.remove(ruleSqlServer);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof StoredProcedureSqlServer) {
                StoredProcedureSqlServer storedProcedureSqlServer = (StoredProcedureSqlServer)modelObjectSetEvent.getAffected();
                storedProcedureSqlServer.addObjectListener(this);
                if (storedProcedureSqlServer.getDatabase() != null && storedProcedureSqlServer.getDatabase() == this) {
                    storedProcedureSqlServer.setParent(this.procedures);
                    this.procedures.add(storedProcedureSqlServer);
                } else {
                    this.procedures.remove(storedProcedureSqlServer);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof UserDefinedTypeSqlServerv2k5) {
                UserDefinedTypeSqlServerv2k5 userDefinedTypeSqlServerv2k5 = (UserDefinedTypeSqlServerv2k5)modelObjectSetEvent.getAffected();
                userDefinedTypeSqlServerv2k5.addObjectListener(this);
                if (userDefinedTypeSqlServerv2k5.getDatabase() != null && userDefinedTypeSqlServerv2k5.getDatabase() == this) {
                    userDefinedTypeSqlServerv2k5.setParent(this.userDefinedDomains);
                    this.userDefinedDomains.add(userDefinedTypeSqlServerv2k5);
                } else {
                    this.userDefinedDomains.remove(userDefinedTypeSqlServerv2k5);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof UsedUserDefinedDatav2k5) {
                UsedUserDefinedDatav2k5 usedUserDefinedDatav2k5 = (UsedUserDefinedDatav2k5)modelObjectSetEvent.getAffected();
                usedUserDefinedDatav2k5.addObjectListener(this);
                if (usedUserDefinedDatav2k5.isBaseOnDistinctType()) {
                    if (usedUserDefinedDatav2k5.getDatabase() == this) {
                        usedUserDefinedDatav2k5.setParent(this.distinctTypes);
                        this.distinctTypes.add(usedUserDefinedDatav2k5);
                    } else {
                        this.distinctTypes.remove(usedUserDefinedDatav2k5);
                    }
                } else if (usedUserDefinedDatav2k5.getUserDefinedType() != null) {
                    if (usedUserDefinedDatav2k5.getDatabase() == this) {
                        usedUserDefinedDatav2k5.setParent(this.userDefinedDomains);
                        this.userDefinedDomains.add(usedUserDefinedDatav2k5);
                    } else {
                        this.userDefinedDomains.remove(usedUserDefinedDatav2k5);
                    }
                }
            } else if (modelObjectSetEvent.getAffected() instanceof PartitionFunctionSqlServer) {
                PartitionFunctionSqlServer partitionFunctionSqlServer = (PartitionFunctionSqlServer)modelObjectSetEvent.getAffected();
                partitionFunctionSqlServer.addObjectListener(this);
                if (partitionFunctionSqlServer.getDatabase() != null && partitionFunctionSqlServer.getDatabase() == this) {
                    partitionFunctionSqlServer.setParent(this.partitionFunction);
                    this.partitionFunction.add(partitionFunctionSqlServer);
                } else {
                    this.partitionFunction.remove(partitionFunctionSqlServer);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof XMLSchemaCollectionSqlServerv2k5) {
                XMLSchemaCollectionSqlServerv2k5 xMLSchemaCollectionSqlServerv2k5 = (XMLSchemaCollectionSqlServerv2k5)modelObjectSetEvent.getAffected();
                xMLSchemaCollectionSqlServerv2k5.addObjectListener(this);
                if (xMLSchemaCollectionSqlServerv2k5.getDatabase() != null && xMLSchemaCollectionSqlServerv2k5.getDatabase() == this) {
                    xMLSchemaCollectionSqlServerv2k5.setParent(this.xmlSchemaCollections);
                    this.xmlSchemaCollections.add(xMLSchemaCollectionSqlServerv2k5);
                } else {
                    this.xmlSchemaCollections.remove(xMLSchemaCollectionSqlServerv2k5);
                }
            }
        } else if (modelObjectSetEvent.isType(0)) {
            if (modelObjectSetEvent.getAffected() instanceof DataFileSqlServer) {
                DataFileSqlServer dataFileSqlServer = (DataFileSqlServer)modelObjectSetEvent.getAffected();
                this.transactionLogs.remove(dataFileSqlServer);
                dataFileSqlServer.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof FileGroupSqlServer) {
                FileGroupSqlServer fileGroupSqlServer = (FileGroupSqlServer)modelObjectSetEvent.getAffected();
                this.filegroups.remove(fileGroupSqlServer);
                fileGroupSqlServer.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof DefaultSqlServer) {
                DefaultSqlServer defaultSqlServer = (DefaultSqlServer)modelObjectSetEvent.getAffected();
                this.defaults.remove(defaultSqlServer);
                defaultSqlServer.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof UserSqlServer) {
                UserSqlServer userSqlServer = (UserSqlServer)modelObjectSetEvent.getAffected();
                this.users.remove(userSqlServer);
                userSqlServer.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof SchemaSqlServer) {
                SchemaSqlServer schemaSqlServer = (SchemaSqlServer)modelObjectSetEvent.getAffected();
                this.schemas.remove(schemaSqlServer);
                schemaSqlServer.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof RoleSqlServer) {
                RoleSqlServer roleSqlServer = (RoleSqlServer)modelObjectSetEvent.getAffected();
                this.roles.remove(roleSqlServer);
                roleSqlServer.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof RuleSqlServer) {
                RuleSqlServer ruleSqlServer = (RuleSqlServer)modelObjectSetEvent.getAffected();
                this.rules.remove(ruleSqlServer);
                ruleSqlServer.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof StoredProcedureSqlServer) {
                StoredProcedureSqlServer storedProcedureSqlServer = (StoredProcedureSqlServer)modelObjectSetEvent.getAffected();
                this.procedures.remove(storedProcedureSqlServer);
                storedProcedureSqlServer.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof UserDefinedTypeSqlServerv2k5) {
                UserDefinedTypeSqlServerv2k5 userDefinedTypeSqlServerv2k5 = (UserDefinedTypeSqlServerv2k5)modelObjectSetEvent.getAffected();
                this.userDefinedDomains.remove(userDefinedTypeSqlServerv2k5);
                userDefinedTypeSqlServerv2k5.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof PartitionFunctionSqlServer) {
                PartitionFunctionSqlServer partitionFunctionSqlServer = (PartitionFunctionSqlServer)modelObjectSetEvent.getAffected();
                this.partitionFunction.remove(partitionFunctionSqlServer);
                partitionFunctionSqlServer.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof UsedUserDefinedData) {
                UsedUserDefinedDatav2k5 usedUserDefinedDatav2k5 = (UsedUserDefinedDatav2k5)modelObjectSetEvent.getAffected();
                if (usedUserDefinedDatav2k5.isBaseOnDistinctType()) {
                    this.distinctTypes.remove(usedUserDefinedDatav2k5);
                    usedUserDefinedDatav2k5.removeObjectListener(this);
                } else if (usedUserDefinedDatav2k5.getUserDefinedType() != null) {
                    this.userDefinedDomains.remove(usedUserDefinedDatav2k5);
                    usedUserDefinedDatav2k5.removeObjectListener(this);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof XMLSchemaCollectionSqlServerv2k5) {
                XMLSchemaCollectionSqlServerv2k5 xMLSchemaCollectionSqlServerv2k5 = (XMLSchemaCollectionSqlServerv2k5)modelObjectSetEvent.getAffected();
                this.xmlSchemaCollections.remove(xMLSchemaCollectionSqlServerv2k5);
                xMLSchemaCollectionSqlServerv2k5.removeObjectListener(this);
            }
        }
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof DataFileSqlServer) {
            DataFileSqlServer dataFileSqlServer = (DataFileSqlServer)objectChangeEvent.getAffected();
            if (dataFileSqlServer.getDataBase() != null && dataFileSqlServer.getDataBase() == this) {
                dataFileSqlServer.setParent(this.transactionLogs);
                this.transactionLogs.add(dataFileSqlServer);
            } else {
                this.transactionLogs.remove(dataFileSqlServer);
            }
        } else if (objectChangeEvent.getAffected() instanceof FileGroupSqlServer) {
            FileGroupSqlServer fileGroupSqlServer = (FileGroupSqlServer)objectChangeEvent.getAffected();
            if (fileGroupSqlServer.getDataBase() != null && fileGroupSqlServer.getDataBase() == this) {
                fileGroupSqlServer.setParent(this.filegroups);
                this.filegroups.add(fileGroupSqlServer);
            } else {
                this.filegroups.remove(fileGroupSqlServer);
            }
        } else if (objectChangeEvent.getAffected() instanceof DefaultSqlServer) {
            DefaultSqlServer defaultSqlServer = (DefaultSqlServer)objectChangeEvent.getAffected();
            if (defaultSqlServer.getDataBase() != null && defaultSqlServer.getDataBase() == this) {
                defaultSqlServer.setParent(this.defaults);
                this.defaults.add(defaultSqlServer);
            } else {
                this.defaults.remove(defaultSqlServer);
            }
        } else if (objectChangeEvent.getAffected() instanceof UserSqlServer) {
            UserSqlServer userSqlServer = (UserSqlServer)objectChangeEvent.getAffected();
            if (userSqlServer.getDatabase() != null && userSqlServer.getDatabase() == this) {
                userSqlServer.setParent(this.users);
                this.users.add(userSqlServer);
            } else {
                this.users.remove(userSqlServer);
            }
        } else if (objectChangeEvent.getAffected() instanceof SchemaSqlServer) {
            SchemaSqlServer schemaSqlServer = (SchemaSqlServer)objectChangeEvent.getAffected();
            if (schemaSqlServer.getDatabase() != null && schemaSqlServer.getDatabase() == this) {
                schemaSqlServer.setParent(this.schemas);
                this.schemas.add(schemaSqlServer);
            } else {
                this.schemas.remove(schemaSqlServer);
            }
        } else if (objectChangeEvent.getAffected() instanceof RoleSqlServer) {
            RoleSqlServer roleSqlServer = (RoleSqlServer)objectChangeEvent.getAffected();
            if (roleSqlServer.getDatabase() != null && roleSqlServer.getDatabase() == this) {
                roleSqlServer.setParent(this.roles);
                this.roles.add(roleSqlServer);
            } else {
                this.roles.remove(roleSqlServer);
            }
        } else if (objectChangeEvent.getAffected() instanceof RuleSqlServer) {
            RuleSqlServer ruleSqlServer = (RuleSqlServer)objectChangeEvent.getAffected();
            if (ruleSqlServer.getDatabase() != null && ruleSqlServer.getDatabase() == this) {
                ruleSqlServer.setParent(this.rules);
                this.rules.add(ruleSqlServer);
            } else {
                this.rules.remove(ruleSqlServer);
            }
        } else if (objectChangeEvent.getAffected() instanceof StoredProcedureSqlServer) {
            StoredProcedureSqlServer storedProcedureSqlServer = (StoredProcedureSqlServer)objectChangeEvent.getAffected();
            if (storedProcedureSqlServer.getDatabase() != null && storedProcedureSqlServer.getDatabase() == this) {
                storedProcedureSqlServer.setParent(this.procedures);
                this.procedures.add(storedProcedureSqlServer);
            } else {
                this.procedures.remove(storedProcedureSqlServer);
            }
        } else if (objectChangeEvent.getAffected() instanceof TableProxy) {
            TableProxySqlServer tableProxySqlServer = (TableProxySqlServer)objectChangeEvent.getAffected();
            if (tableProxySqlServer.getDatabase() != null && tableProxySqlServer.getDatabase() == this) {
                StorageObjectPlaceHolder storageObjectPlaceHolder = new StorageObjectPlaceHolder(tableProxySqlServer);
                storageObjectPlaceHolder.setParent(this.tables);
                storageObjectPlaceHolder.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_ICON", 16));
                this.tables.add(storageObjectPlaceHolder);
            } else if (tableProxySqlServer.getDatabase() == null || tableProxySqlServer.getDatabase() != null && tableProxySqlServer.getDatabase() != this) {
                this.tables.removePlaceHolderFor(tableProxySqlServer);
            }
        } else if (objectChangeEvent.getAffected() instanceof TableViewProxy) {
            TableViewProxySqlServer tableViewProxySqlServer = (TableViewProxySqlServer)objectChangeEvent.getAffected();
            if (tableViewProxySqlServer.getDataBase() != null && tableViewProxySqlServer.getDataBase() == this) {
                StorageObjectPlaceHolder storageObjectPlaceHolder = new StorageObjectPlaceHolder(tableViewProxySqlServer);
                storageObjectPlaceHolder.setParent(this.views);
                storageObjectPlaceHolder.setIcon(GUIConfiguration.getInstance().getIcon("VIEW_ICON", 16));
                this.views.add(storageObjectPlaceHolder);
            } else if (tableViewProxySqlServer.getDataBase() == null || tableViewProxySqlServer.getDataBase() != null && tableViewProxySqlServer.getDataBase() != this) {
                this.views.removePlaceHolderFor(tableViewProxySqlServer);
            }
        } else if (objectChangeEvent.getAffected() instanceof UsedUserDefinedDatav2k5) {
            UsedUserDefinedDatav2k5 usedUserDefinedDatav2k5 = (UsedUserDefinedDatav2k5)objectChangeEvent.getAffected();
            if (usedUserDefinedDatav2k5.isBaseOnDistinctType()) {
                if (usedUserDefinedDatav2k5.getDatabase() == this) {
                    usedUserDefinedDatav2k5.setParent(this.distinctTypes);
                    this.distinctTypes.add(usedUserDefinedDatav2k5);
                } else {
                    this.distinctTypes.remove(usedUserDefinedDatav2k5);
                }
            } else if (usedUserDefinedDatav2k5.getUserDefinedType() != null) {
                if (usedUserDefinedDatav2k5.getDatabase() == this) {
                    usedUserDefinedDatav2k5.setParent(this.userDefinedDomains);
                    this.userDefinedDomains.add(usedUserDefinedDatav2k5);
                } else {
                    this.userDefinedDomains.remove(usedUserDefinedDatav2k5);
                }
            }
        } else if (objectChangeEvent.getAffected() instanceof PartitionFunctionSqlServer) {
            PartitionFunctionSqlServer partitionFunctionSqlServer = (PartitionFunctionSqlServer)objectChangeEvent.getAffected();
            if (partitionFunctionSqlServer.getDatabase() != null && partitionFunctionSqlServer.getDatabase() == this) {
                partitionFunctionSqlServer.setParent(this.partitionFunction);
                this.partitionFunction.add(partitionFunctionSqlServer);
            } else {
                this.partitionFunction.remove(partitionFunctionSqlServer);
            }
        } else if (objectChangeEvent.getAffected() instanceof XMLSchemaCollectionSqlServerv2k5) {
            XMLSchemaCollectionSqlServerv2k5 xMLSchemaCollectionSqlServerv2k5 = (XMLSchemaCollectionSqlServerv2k5)objectChangeEvent.getAffected();
            if (xMLSchemaCollectionSqlServerv2k5.getDatabase() != null && xMLSchemaCollectionSqlServerv2k5.getDatabase() == this) {
                xMLSchemaCollectionSqlServerv2k5.setParent(this.xmlSchemaCollections);
                this.xmlSchemaCollections.add(xMLSchemaCollectionSqlServerv2k5);
            } else {
                this.xmlSchemaCollections.remove(xMLSchemaCollectionSqlServerv2k5);
            }
        }
    }

    @Override
    public void changed(RelationalObjectProxySet relationalObjectProxySet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof TableProxy) {
                TableProxySqlServer tableProxySqlServer = (TableProxySqlServer)modelObjectSetEvent.getAffected();
                tableProxySqlServer.addObjectListener(this);
                if (this == tableProxySqlServer.getDatabase()) {
                    StorageObjectPlaceHolder storageObjectPlaceHolder = new StorageObjectPlaceHolder(tableProxySqlServer);
                    storageObjectPlaceHolder.setParent(this.tables);
                    storageObjectPlaceHolder.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_ICON", 16));
                    this.tables.add(storageObjectPlaceHolder);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof TableViewProxy) {
                TableViewProxySqlServer tableViewProxySqlServer = (TableViewProxySqlServer)modelObjectSetEvent.getAffected();
                tableViewProxySqlServer.addObjectListener(this);
                if (this == tableViewProxySqlServer.getDataBase()) {
                    StorageObjectPlaceHolder storageObjectPlaceHolder = new StorageObjectPlaceHolder(tableViewProxySqlServer);
                    storageObjectPlaceHolder.setParent(this.views);
                    storageObjectPlaceHolder.setIcon(GUIConfiguration.getInstance().getIcon("VIEW_ICON", 16));
                    this.views.add(storageObjectPlaceHolder);
                }
            }
        } else if (modelObjectSetEvent.isType(0)) {
            if (modelObjectSetEvent.getAffected() instanceof TableProxy) {
                TableProxySqlServer tableProxySqlServer = (TableProxySqlServer)modelObjectSetEvent.getAffected();
                tableProxySqlServer.removeObjectListener(this);
                this.tables.removePlaceHolderFor(tableProxySqlServer);
            } else if (modelObjectSetEvent.getAffected() instanceof TableViewProxy) {
                TableViewProxySqlServer tableViewProxySqlServer = (TableViewProxySqlServer)modelObjectSetEvent.getAffected();
                tableViewProxySqlServer.removeObjectListener(this);
                this.views.removePlaceHolderFor(tableViewProxySqlServer);
            } else if (modelObjectSetEvent.getAffected() instanceof DistinctTypeProxySqlServerv2k5) {
                DistinctTypeProxySqlServer distinctTypeProxySqlServer = (DistinctTypeProxySqlServer)modelObjectSetEvent.getAffected();
                distinctTypeProxySqlServer.removeObjectListener(this);
            }
        }
    }

    @Override
    public void registerToTableProxyFromDesign(RelationalObjectProxySet relationalObjectProxySet) {
        Iterator iterator = relationalObjectProxySet.iterator();
        while (iterator.hasNext()) {
            TableProxySqlServer tableProxySqlServer = (TableProxySqlServer)iterator.next();
            tableProxySqlServer.addObjectListener(this);
        }
    }

    @Override
    public void registerToViewProxyFromDesign(RelationalObjectProxySet relationalObjectProxySet) {
        Iterator iterator = relationalObjectProxySet.iterator();
        while (iterator.hasNext()) {
            TableViewProxySqlServer tableViewProxySqlServer = (TableViewProxySqlServer)iterator.next();
            tableViewProxySqlServer.addObjectListener(this);
        }
    }

    public static String[] getUserChoices() {
        return USER_STATES;
    }

    @Override
    protected boolean checkUser(String string) {
        if (userSet == null) {
            userSet = new HashSet();
            userSet.addAll(Arrays.asList(DataBaseSqlServerv2k5.getUserChoices()));
        }
        return userSet.contains(string);
    }

    public static String[] getOnOffChoices() {
        return ON_OFF_STATES;
    }

    @Override
    protected boolean checkOnOff(String string) {
        if (onOffSet == null) {
            onOffSet = new HashSet();
            onOffSet.addAll(Arrays.asList(DataBaseSqlServerv2k5.getOnOffChoices()));
        }
        return onOffSet.contains(string);
    }

    public static String[] getCursorDefaultChoices() {
        return CURSOR_DEFAULT_STATES;
    }

    @Override
    protected boolean checkCursorDefault(String string) {
        if (cursorDefaultSet == null) {
            cursorDefaultSet = new HashSet();
            cursorDefaultSet.addAll(Arrays.asList(DataBaseSqlServerv2k5.getCursorDefaultChoices()));
        }
        return cursorDefaultSet.contains(string);
    }

    public static String[] getRecoveryChoices() {
        return RECOVERY_STATES;
    }

    @Override
    protected boolean checkRecovery(String string) {
        if (recoverySet == null) {
            recoverySet = new HashSet();
            recoverySet.addAll(Arrays.asList(DataBaseSqlServerv2k5.getRecoveryChoices()));
        }
        return recoverySet.contains(string);
    }

    @Override
    public String getUserState() {
        return this.userState;
    }

    @Override
    public String getAnsiNulls() {
        return this.ansiNulls;
    }

    @Override
    public String getAnsiPadding() {
        return this.ansiPadding;
    }

    @Override
    public String getAnsiWarnings() {
        return this.ansiWarnings;
    }

    @Override
    public String getArithabort() {
        return this.arithabort;
    }

    @Override
    public String getAutoClose() {
        return this.autoClose;
    }

    @Override
    public String getAutoCreateStatistics() {
        return this.autoCreateStatistics;
    }

    @Override
    public String getAutoUpdateStatistics() {
        return this.autoUpdateStatistics;
    }

    @Override
    public String getAutoShrink() {
        return this.autoShrink;
    }

    @Override
    public String getConcatNullYieldsNull() {
        return this.concatNullYieldsNull;
    }

    @Override
    public String getCursorCloseOnCommit() {
        return this.cursorCloseOnCommit;
    }

    @Override
    public String getCursorDefault() {
        return this.cursorDefault;
    }

    @Override
    public String getRecovery() {
        return this.recovery;
    }

    @Override
    public String getRecursiveTriggers() {
        return this.recursiveTriggers;
    }

    @Override
    public String getTornPageDetection() {
        return this.tornPageDetection;
    }

    @Override
    public String getNumericRoundabort() {
        return this.numericRoundabort;
    }

    @Override
    public String getQuotedIdentifier() {
        return this.quotedIdentifier;
    }

    @Override
    public void setAnsiNulls(String string) {
        if (this.checkOnOff(string)) {
            this.ansiNulls = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setAnsiPadding(String string) {
        if (this.checkOnOff(string)) {
            this.ansiPadding = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setAnsiWarnings(String string) {
        if (this.checkOnOff(string)) {
            this.ansiWarnings = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setArithabort(String string) {
        if (this.checkOnOff(string)) {
            this.arithabort = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setAutoClose(String string) {
        if (this.checkOnOff(string)) {
            this.autoClose = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setAutoCreateStatistics(String string) {
        if (this.checkOnOff(string)) {
            this.autoCreateStatistics = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setAutoUpdateStatistics(String string) {
        if (this.checkOnOff(string)) {
            this.autoUpdateStatistics = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setAutoShrink(String string) {
        if (this.checkOnOff(string)) {
            this.autoShrink = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setConcatNullYieldsNull(String string) {
        if (this.checkOnOff(string)) {
            this.concatNullYieldsNull = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setCursorCloseOnCommit(String string) {
        if (this.checkOnOff(string)) {
            this.cursorCloseOnCommit = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setCursorDefault(String string) {
        if (this.checkCursorDefault(string)) {
            this.cursorDefault = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setNumericRoundabort(String string) {
        if (this.checkOnOff(string)) {
            this.numericRoundabort = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setQuotedIdentifier(String string) {
        if (this.checkOnOff(string)) {
            this.quotedIdentifier = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setRecovery(String string) {
        if (this.checkRecovery(string)) {
            this.recovery = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setRecursiveTriggers(String string) {
        if (this.checkOnOff(string)) {
            this.recursiveTriggers = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setUserState(String string) {
        if (this.checkUser(string)) {
            this.userState = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setTornPageDetection(String string) {
        if (this.checkOnOff(string)) {
            this.tornPageDetection = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public String getCollationName() {
        return this.collationName;
    }

    @Override
    public void setCollationName(String string) {
        if (string != null) {
            this.collationName = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public StorageObjectCollection getDefaults() {
        return this.defaults;
    }

    @Override
    public StorageObjectCollection getFilegroups() {
        return this.filegroups;
    }

    @Override
    public StorageObjectCollection getProcedures() {
        return this.procedures;
    }

    @Override
    public StorageObjectCollection getRoles() {
        return this.roles;
    }

    @Override
    public StorageObjectCollection getRules() {
        return this.rules;
    }

    @Override
    public StorageObjectCollection getTables() {
        return this.tables;
    }

    public List getTablesList() {
        ArrayList arrayList = new ArrayList();
        this.tables.addAllElementsTo(arrayList);
        return arrayList;
    }

    @Override
    public StorageObjectCollection getTransactionLogs() {
        return this.transactionLogs;
    }

    @Override
    public StorageObjectCollection getUsers() {
        return this.users;
    }

    @Override
    public StorageObjectCollection getViews() {
        return this.views;
    }

    @Override
    public StorageObjectCollection getSchemas() {
        return this.schemas;
    }

    public StorageObjectCollection getUsedDistinctTypes() {
        return this.distinctTypes;
    }

    public StorageObjectCollection getUserDefinedDomains() {
        return this.userDefinedDomains;
    }

    public StorageObjectCollection getPartitionFunction() {
        return this.partitionFunction;
    }

    public StorageObjectCollection getXmlSchemaCollection() {
        return this.xmlSchemaCollections;
    }

    @Override
    public FileGroupSqlServer createFilegroup() {
        if (this.filegroups.getStorageObjectSet() != null) {
            return (FileGroupSqlServer)this.filegroups.createElement(null);
        }
        return null;
    }

    @Override
    public DataFileSqlServer createTransactionLog() {
        if (this.transactionLogs.getStorageObjectSet() != null) {
            return (DataFileSqlServer)this.transactionLogs.createElement(null);
        }
        return null;
    }

    public UsedUserDefinedData createUsedDistinctType() {
        if (this.distinctTypes.getStorageObjectSet() != null) {
            return (UsedUserDefinedData)this.distinctTypes.createElement(null);
        }
        return null;
    }

    public UsedUserDefinedData createUserDefinedDomain() {
        if (this.userDefinedDomains.getStorageObjectSet() != null) {
            return (UsedUserDefinedData)this.userDefinedDomains.createElement(null);
        }
        return null;
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        DataBaseSqlServerv2k5 dataBaseSqlServerv2k5 = null;
        StorageObject storageObject = (StorageObject)((StorageDesignSqlServerv2k5)storageDesign).getDataBaseSet().getByName(this.getName());
        if (storageObject != null) {
            if (this.isRawObject()) {
                dataBaseSqlServerv2k5 = (DataBaseSqlServerv2k5)storageObject;
            }
        } else {
            dataBaseSqlServerv2k5 = (DataBaseSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getDataBaseSet().createDataBase();
        }
        if (dataBaseSqlServerv2k5 != null) {
            StorageObject storageObject2;
            StorageObject storageObject3;
            StorageObject storageObject4;
            dataBaseSqlServerv2k5.setName(this.getName());
            dataBaseSqlServerv2k5.setUserState(this.getUserState());
            dataBaseSqlServerv2k5.setCollationName(this.getCollationName());
            dataBaseSqlServerv2k5.setCursorCloseOnCommit(this.getCursorCloseOnCommit());
            dataBaseSqlServerv2k5.setCursorDefault(this.getCursorDefault());
            dataBaseSqlServerv2k5.setAutoClose(this.getAutoClose());
            dataBaseSqlServerv2k5.setAutoCreateStatistics(this.getAutoCreateStatistics());
            dataBaseSqlServerv2k5.setAutoUpdateStatistics(this.getAutoUpdateStatistics());
            dataBaseSqlServerv2k5.setAutoShrink(this.getAutoShrink());
            dataBaseSqlServerv2k5.setRecovery(this.getRecovery());
            dataBaseSqlServerv2k5.setTornPageDetection(this.getTornPageDetection());
            dataBaseSqlServerv2k5.setAnsiPadding(this.getAnsiPadding());
            dataBaseSqlServerv2k5.setAnsiNulls(this.getAnsiNulls());
            dataBaseSqlServerv2k5.setAnsiWarnings(this.getAnsiWarnings());
            dataBaseSqlServerv2k5.setArithabort(this.getArithabort());
            dataBaseSqlServerv2k5.setConcatNullYieldsNull(this.getConcatNullYieldsNull());
            dataBaseSqlServerv2k5.setNumericRoundabort(this.getNumericRoundabort());
            dataBaseSqlServerv2k5.setQuotedIdentifier(this.getQuotedIdentifier());
            dataBaseSqlServerv2k5.setRecursiveTriggers(this.getRecursiveTriggers());
            dataBaseSqlServerv2k5.setComment(this.getComment());
            dataBaseSqlServerv2k5.setRawObject(false);
            Iterator iterator = this.getFilegroups().iterator();
            while (iterator.hasNext()) {
                storageObject4 = (FileGroupSqlServerv2k5)iterator.next();
                storageObject3 = (FileGroupSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getFileGroupSet().getByName(storageObject4.getName());
                if (storageObject3 == null) {
                    storageObject2 = (FileGroupSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getFileGroupSet().createFileGroup();
                    storageObject2.setName(storageObject4.getName());
                    ((FileGroupSqlServer)storageObject2).setDataBase(dataBaseSqlServerv2k5);
                    storageObject2.setRawObject(true);
                    dataBaseSqlServerv2k5.getFilegroups().add(storageObject2);
                    continue;
                }
                ((FileGroupSqlServer)storageObject3).setDataBase(dataBaseSqlServerv2k5);
                dataBaseSqlServerv2k5.getFilegroups().add(storageObject3);
            }
            iterator = this.getTransactionLogs().iterator();
            while (iterator.hasNext()) {
                storageObject4 = (DataFileSqlServerv2k5)iterator.next();
                storageObject3 = (DataFileSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getDataFileSet().getByName(storageObject4.getName());
                if (storageObject3 == null) {
                    storageObject2 = (DataFileSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getDataFileSet().createDataFile();
                    storageObject2.setName(storageObject4.getName());
                    ((DataFileSqlServer)storageObject2).setDataBase(dataBaseSqlServerv2k5);
                    storageObject2.setRawObject(true);
                    dataBaseSqlServerv2k5.getTransactionLogs().add(storageObject2);
                    continue;
                }
                ((DataFileSqlServer)storageObject3).setDataBase(dataBaseSqlServerv2k5);
                dataBaseSqlServerv2k5.getTransactionLogs().add(storageObject3);
            }
            iterator = this.getDefaults().iterator();
            while (iterator.hasNext()) {
                storageObject4 = (DefaultSqlServerv2k5)iterator.next();
                storageObject3 = (DefaultSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getDefaultSet().getByName(storageObject4.getName());
                if (storageObject3 == null) {
                    storageObject2 = (DefaultSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getDefaultSet().createDefault();
                    storageObject2.setName(storageObject4.getName());
                    ((DefaultSqlServer)storageObject2).setDataBase(dataBaseSqlServerv2k5);
                    storageObject2.setRawObject(true);
                    dataBaseSqlServerv2k5.getDefaults().add(storageObject2);
                    continue;
                }
                ((DefaultSqlServer)storageObject3).setDataBase(dataBaseSqlServerv2k5);
                dataBaseSqlServerv2k5.getDefaults().add(storageObject3);
            }
            iterator = this.getUsers().iterator();
            while (iterator.hasNext()) {
                storageObject4 = (UserSqlServerv2k5)iterator.next();
                storageObject3 = (UserSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getUserSet().getByName(storageObject4.getName());
                if (storageObject3 == null) {
                    storageObject2 = (UserSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getUserSet().createUser();
                    storageObject2.setName(storageObject4.getName());
                    ((UserSqlServer)storageObject2).setDatabase(dataBaseSqlServerv2k5);
                    storageObject2.setRawObject(true);
                    continue;
                }
                ((UserSqlServer)storageObject3).setDatabase(dataBaseSqlServerv2k5);
            }
            iterator = this.getSchemas().iterator();
            while (iterator.hasNext()) {
                storageObject4 = (SchemaSqlServerv2k5)iterator.next();
                storageObject3 = (SchemaSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getSchemaSet().getByName(storageObject4.getName());
                if (storageObject3 == null) {
                    storageObject2 = (SchemaSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getSchemaSet().createSchema();
                    storageObject2.setName(storageObject4.getName());
                    ((SchemaSqlServer)storageObject2).setDatabase(dataBaseSqlServerv2k5);
                    storageObject2.setRawObject(true);
                    dataBaseSqlServerv2k5.getSchemas().add(storageObject2);
                    continue;
                }
                ((SchemaSqlServer)storageObject3).setDatabase(dataBaseSqlServerv2k5);
                dataBaseSqlServerv2k5.getSchemas().add(storageObject3);
            }
            iterator = this.getRoles().iterator();
            while (iterator.hasNext()) {
                storageObject4 = (RoleSqlServerv2k5)iterator.next();
                storageObject3 = (RoleSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getRoleSet().getByName(storageObject4.getName());
                if (storageObject3 == null) {
                    storageObject2 = (RoleSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getRoleSet().createRole();
                    storageObject2.setName(storageObject4.getName());
                    ((RoleSqlServer)storageObject2).setDatabase(dataBaseSqlServerv2k5);
                    storageObject2.setRawObject(true);
                    continue;
                }
                ((RoleSqlServer)storageObject3).setDatabase(dataBaseSqlServerv2k5);
            }
            iterator = this.getRules().iterator();
            while (iterator.hasNext()) {
                storageObject4 = (RuleSqlServerv2k5)iterator.next();
                storageObject3 = (RuleSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getRuleSet().getByName(storageObject4.getName());
                if (storageObject3 == null) {
                    storageObject2 = (RuleSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getRuleSet().createRule();
                    storageObject2.setName(storageObject4.getName());
                    ((RuleSqlServer)storageObject2).setDatabase(dataBaseSqlServerv2k5);
                    storageObject2.setRawObject(true);
                    dataBaseSqlServerv2k5.getRules().add(storageObject2);
                    continue;
                }
                ((RuleSqlServer)storageObject3).setDatabase(dataBaseSqlServerv2k5);
                dataBaseSqlServerv2k5.getRules().add(storageObject3);
            }
            iterator = this.getPartitionFunction().iterator();
            while (iterator.hasNext()) {
                storageObject4 = (PartitionFunctionSqlServerv2k5)iterator.next();
                storageObject3 = (PartitionFunctionSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getPartitionFunctionSet().getByName(storageObject4.getName());
                if (storageObject3 == null) {
                    storageObject2 = (PartitionFunctionSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getPartitionFunctionSet().createPartitionFunction();
                    storageObject2.setName(storageObject4.getName());
                    ((PartitionFunctionSqlServer)storageObject2).setDatabase(dataBaseSqlServerv2k5);
                    storageObject2.setRawObject(true);
                    dataBaseSqlServerv2k5.getPartitionFunction().add(storageObject2);
                    continue;
                }
                ((PartitionFunctionSqlServer)storageObject3).setDatabase(dataBaseSqlServerv2k5);
                dataBaseSqlServerv2k5.getPartitionFunction().add(storageObject3);
            }
            iterator = this.getTables().iterator();
            while (iterator.hasNext()) {
                storageObject4 = (StorageObjectPlaceHolder)iterator.next();
                storageObject3 = (TableProxySqlServerv2k5)((TableProxySetSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getTableProxySet()).getByName(((StorageObjectPlaceHolder)storageObject4).getName());
                if (storageObject3 == null) {
                    storageObject2 = (TableProxySqlServerv2k5)((TableProxySetSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getTableProxySet()).createProxy(storageObject4.getGenerator());
                    ((RelationalObjectProxy)storageObject2).setName(((StorageObjectPlaceHolder)storageObject4).getName());
                    ((TableProxySqlServer)storageObject2).setDatabase(dataBaseSqlServerv2k5);
                    storageObject2.setRawObject(true);
                    ((StorageDesignSqlServerv2k5)storageDesign).getTableProxySet().add((RelationalObjectProxy)storageObject2);
                    dataBaseSqlServerv2k5.registerToTableProxyFromDesign(((StorageDesignSqlServerv2k5)storageDesign).getTableProxySet());
                    continue;
                }
                ((TableProxySqlServer)storageObject3).setDatabase(dataBaseSqlServerv2k5);
                ((StorageDesignSqlServerv2k5)storageDesign).getTableProxySet().add((RelationalObjectProxy)storageObject3);
                dataBaseSqlServerv2k5.registerToTableProxyFromDesign(((StorageDesignSqlServerv2k5)storageDesign).getTableProxySet());
            }
            iterator = this.getViews().iterator();
            while (iterator.hasNext()) {
                storageObject4 = (StorageObjectPlaceHolder)iterator.next();
                storageObject3 = (TableViewProxySqlServerv2k5)((TableViewProxySetSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getTableViewProxySet()).getByName(((StorageObjectPlaceHolder)storageObject4).getName());
                if (storageObject3 == null) {
                    storageObject2 = (TableViewProxySqlServerv2k5)((TableViewProxySetSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getTableViewProxySet()).createProxy(storageObject4.getGenerator());
                    ((RelationalObjectProxy)storageObject2).setName(((StorageObjectPlaceHolder)storageObject4).getName());
                    ((TableViewProxySqlServer)storageObject2).setDataBase(dataBaseSqlServerv2k5);
                    storageObject2.setRawObject(true);
                    ((StorageDesignSqlServerv2k5)storageDesign).getTableViewProxySet().add((RelationalObjectProxy)storageObject2);
                    dataBaseSqlServerv2k5.registerToViewProxyFromDesign(((StorageDesignSqlServerv2k5)storageDesign).getTableViewProxySet());
                    continue;
                }
                ((TableViewProxySqlServer)storageObject3).setDataBase(dataBaseSqlServerv2k5);
                ((StorageDesignSqlServerv2k5)storageDesign).getTableViewProxySet().add((RelationalObjectProxy)storageObject3);
                dataBaseSqlServerv2k5.registerToViewProxyFromDesign(((StorageDesignSqlServerv2k5)storageDesign).getTableViewProxySet());
            }
            iterator = this.getProcedures().iterator();
            while (iterator.hasNext()) {
                storageObject4 = (StoredProcedureSqlServerv2k5)iterator.next();
                storageObject3 = (StoredProcedureSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getStoredProcedureSet().getByName(storageObject4.getName());
                if (storageObject3 == null) {
                    storageObject2 = (StoredProcedureSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getStoredProcedureSet().createStoredProcedure();
                    storageObject2.setName(storageObject4.getName());
                    ((StoredProcedureSqlServer)storageObject2).setDatabase(dataBaseSqlServerv2k5);
                    storageObject2.setRawObject(true);
                    dataBaseSqlServerv2k5.getProcedures().add(storageObject2);
                    continue;
                }
                ((StoredProcedureSqlServer)storageObject3).setDatabase(dataBaseSqlServerv2k5);
                dataBaseSqlServerv2k5.getProcedures().add(storageObject3);
            }
            iterator = this.getUsedDistinctTypes().iterator();
            while (iterator.hasNext()) {
                storageObject4 = (UsedUserDefinedDatav2k5)iterator.next();
                storageObject3 = (UsedUserDefinedDatav2k5)((StorageDesignSqlServerv2k5)storageDesign).getUsedUserDefinedDataSet().getByName(storageObject4.getName());
                if (storageObject3 == null) {
                    storageObject2 = (UsedUserDefinedDatav2k5)((StorageDesignSqlServerv2k5)storageDesign).getUsedUserDefinedDataSet().createUsedUserDefinedData();
                    storageObject2.setName(storageObject4.getName());
                    ((UsedUserDefinedData)storageObject2).setDatabase(dataBaseSqlServerv2k5);
                    storageObject2.setRawObject(true);
                    dataBaseSqlServerv2k5.getUsedDistinctTypes().add(storageObject2);
                    continue;
                }
                ((UsedUserDefinedData)storageObject3).setDatabase(dataBaseSqlServerv2k5);
                dataBaseSqlServerv2k5.getUsedDistinctTypes().add(storageObject3);
            }
            iterator = this.getUserDefinedDomains().iterator();
            while (iterator.hasNext()) {
                storageObject4 = (UsedUserDefinedDatav2k5)iterator.next();
                storageObject3 = (UsedUserDefinedDatav2k5)((StorageDesignSqlServerv2k5)storageDesign).getUsedUserDefinedDataSet().getByName(storageObject4.getName());
                if (storageObject3 == null) {
                    storageObject2 = (UsedUserDefinedDatav2k5)((StorageDesignSqlServerv2k5)storageDesign).getUsedUserDefinedDataSet().createUsedUserDefinedData();
                    storageObject2.setName(storageObject4.getName());
                    ((UsedUserDefinedData)storageObject2).setDatabase(dataBaseSqlServerv2k5);
                    storageObject2.setRawObject(true);
                    dataBaseSqlServerv2k5.getUserDefinedDomains().add(storageObject2);
                    continue;
                }
                ((UsedUserDefinedData)storageObject3).setDatabase(dataBaseSqlServerv2k5);
                dataBaseSqlServerv2k5.getUserDefinedDomains().add(storageObject3);
            }
            iterator = this.getXmlSchemaCollection().iterator();
            while (iterator.hasNext()) {
                storageObject4 = (XMLSchemaCollectionSqlServerv2k5)iterator.next();
                storageObject3 = (XMLSchemaCollectionSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getXmlSchemaCollectionSet().getByName(storageObject4.getName());
                if (storageObject3 == null) {
                    storageObject2 = (XMLSchemaCollectionSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getXmlSchemaCollectionSet().createType();
                    storageObject2.setName(storageObject4.getName());
                    ((XMLSchemaCollectionSqlServer)storageObject2).setDatabase(dataBaseSqlServerv2k5);
                    storageObject2.setRawObject(true);
                    dataBaseSqlServerv2k5.getXmlSchemaCollection().add(storageObject2);
                    continue;
                }
                ((XMLSchemaCollectionSqlServer)storageObject3).setDatabase(dataBaseSqlServerv2k5);
                dataBaseSqlServerv2k5.getXmlSchemaCollection().add(storageObject3);
            }
        }
    }

    @Override
    public void clearMergableStructure(Map map) {
        if (map != null) {
            ArrayList arrayList = new ArrayList();
            this.transactionLogs.addAllElementsTo(arrayList);
            this.filegroups.addAllElementsTo(arrayList);
            this.defaults.addAllElementsTo(arrayList);
            this.users.addAllElementsTo(arrayList);
            this.roles.addAllElementsTo(arrayList);
            this.rules.addAllElementsTo(arrayList);
            this.procedures.addAllElementsTo(arrayList);
            this.distinctTypes.addAllElementsTo(arrayList);
            this.userDefinedDomains.addAllElementsTo(arrayList);
            this.partitionFunction.addAllElementsTo(arrayList);
            this.xmlSchemaCollections.addAllElementsTo(arrayList);
            for (StorageObject storageObject : arrayList) {
                if (map.get(storageObject.getObjectID()) != null) continue;
                storageObject.remove(true);
            }
        }
    }

    @Override
    public void setIsNullInstance(boolean bl) {
        super.setIsNullInstance(bl);
        this.filegroups.setForbiddenCreateElement(bl);
        this.transactionLogs.setForbiddenCreateElement(bl);
    }
}

