/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDUnknown;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.storage.sqlserver.AbstractStorageObjectSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UsedUserDefinedData;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.UserDefinedTypesPropertyDialog;

public class UserDefinedTypeSqlServer
extends AbstractStorageObjectSqlServer {
    protected String domain = "";
    protected String nullType;
    protected UserSqlServer owner;
    protected DataBaseSqlServer database;
    protected Domain domainObj;
    protected UsedUDDTSet usedUDDTSet;
    protected String usedUDDT = "";
    public static final String[] NULL_STATES = new String[]{"NULL", "NOT NULL"};
    private static Set nullSet = null;
    public static final String TYPE_NAME = "UDType";
    public static final String OLD_TYPE_NAME = "UserDefinedType";

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            UserDefinedTypesPropertyDialog userDefinedTypesPropertyDialog = new UserDefinedTypesPropertyDialog(this.getDesign().getAppView(), this.getStorageDesign(), this);
            userDefinedTypesPropertyDialog.show();
        }
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "Type";
    }

    protected boolean checkNullType(String string) {
        if (nullSet == null) {
            nullSet = new HashSet();
            nullSet.addAll(Arrays.asList(NULL_STATES));
        }
        return nullSet.contains(string);
    }

    public MDDataType getDataType() {
        Domain domain = (Domain)this.getStorageDesign().getDesign().getDomainSet().getByName(this.domain);
        if (domain != null) {
            return domain.getDataType();
        }
        return new MDUnknown();
    }

    public String getDomain() {
        if (this.domain.equals("")) {
            this.domain = "BigNumber";
        }
        return this.domain;
    }

    public void setDomain(String string) {
        this.domain = string;
        this.fireDataFieldChange();
    }

    public Domain getDomainObj() {
        Domain domain = (Domain)this.getStorageDesign().getDesign().getDomainSet().getByName(this.getDomain());
        return domain;
    }

    public String getNullType() {
        return this.nullType;
    }

    public void setNullType(String string) {
        if (this.checkNullType(string)) {
            this.nullType = string;
            this.fireDataFieldChange();
        }
    }

    public UserSqlServer getOwner() {
        return this.owner;
    }

    public void setOwner(UserSqlServer userSqlServer) {
        this.owner = userSqlServer;
        this.fireDataFieldChange();
    }

    @Override
    public DataBaseSqlServer getDatabase() {
        return this.database;
    }

    public void setDatabase(DataBaseSqlServer dataBaseSqlServer) {
        this.database = dataBaseSqlServer;
        this.fireDataFieldChange();
    }

    public UsedUDDTSet getUsedUDDTSet() {
        if (this.usedUDDTSet == null) {
            this.usedUDDTSet = new UsedUDDTSet();
        }
        return this.usedUDDTSet;
    }

    public void setUsedUDDTSet(UsedUDDTSet usedUDDTSet) {
        this.usedUDDTSet = usedUDDTSet;
    }

    public void setUsedUserDataType(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateUsedUserDataType(string);
        } else {
            this.addUsedUserDataType(string);
        }
        this.usedUDDT = this.getUsedUDDTSet().toString();
        this.fireDataFieldChange();
    }

    private void addUsedUserDataType(String string) {
        String string2 = string.substring(string.lastIndexOf(46) + 1, string.length());
        if (!this.getUsedUDDTSet().contains(string2)) {
            this.getUsedUDDTSet().add(string2);
        }
    }

    private void recreateUsedUserDataType(String string) {
        this.getUsedUDDTSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (this.getUsedUDDTSet().contains(string2)) continue;
            this.getUsedUDDTSet().add(string2);
        }
    }

    public void clearFromDataBase(DataBaseSqlServer dataBaseSqlServer) {
        UsedUserDefinedData[] usedUserDefinedDataArray = (UsedUserDefinedData[])((StorageDesignSqlServer)this.getStorageDesign()).getUsedUserDefinedDataSet().toArray();
        for (int i = 0; i < usedUserDefinedDataArray.length; ++i) {
            UsedUserDefinedData usedUserDefinedData = usedUserDefinedDataArray[i];
            if (usedUserDefinedData.getUserDefinedType() != this || usedUserDefinedData.getDatabase() != dataBaseSqlServer) continue;
            this.getUsedUDDTSet().remove(usedUserDefinedData.getName());
            ((StorageDesignSqlServer)this.getStorageDesign()).getUsedUserDefinedDataSet().remove(usedUserDefinedData);
        }
    }

    public String getUsedUDDT() {
        return this.usedUDDT;
    }

    public void setUsedUDDT(String string) {
        this.usedUDDT = string;
    }

    @Override
    public void remove() {
        UsedUserDefinedData[] usedUserDefinedDataArray = (UsedUserDefinedData[])((StorageDesignSqlServer)this.getStorageDesign()).getUsedUserDefinedDataSet().toArray();
        for (int i = 0; i < usedUserDefinedDataArray.length; ++i) {
            UsedUserDefinedData usedUserDefinedData = usedUserDefinedDataArray[i];
            if (usedUserDefinedData.getUserDefinedType() != this) continue;
            ((StorageDesignSqlServer)this.getStorageDesign()).getUsedUserDefinedDataSet().remove(usedUserDefinedData);
        }
        super.remove();
    }

    public class UsedUDDTSet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

