/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.sqlserver.ConstantsSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.TriggerPropertyDialogSqlServer;

public class TriggerSqlServer
extends Trigger {
    private TableProxySqlServer table;
    private TableViewProxySqlServer view;
    protected UserSqlServer owner;
    protected String encription = "NO";
    protected String forReplication = "YES";
    protected String executionOrder = "NONE";
    private SchemaSqlServer schema;
    public static final String[] TRIGGER_TIMES = new String[]{"AFTER", "INSTEAD OF"};
    private static List triggerTimeList = Arrays.asList("FOR", "AFTER", "INSTEAD OF");
    public static final String[] EXECUTION_ORDERS = new String[]{"NONE", "FIRST", "LAST"};
    private static Set executionOrderSet = null;

    public TriggerSqlServer(StorageDesign storageDesign) {
        super(storageDesign);
        this.setTriggerTime("AFTER");
    }

    public TableProxySqlServer getTable() {
        return this.table;
    }

    public void setTable(TableProxySqlServer tableProxySqlServer) {
        this.table = tableProxySqlServer;
        this.fireDataFieldChange();
    }

    public TableViewProxySqlServer getView() {
        return this.view;
    }

    public void setView(TableViewProxySqlServer tableViewProxySqlServer) {
        this.view = tableViewProxySqlServer;
        this.fireDataFieldChange();
    }

    public static String[] getTriggerTimes() {
        return TRIGGER_TIMES;
    }

    public static List getTriggerValues() {
        return triggerTimeList;
    }

    @Override
    protected boolean checkTriggerTime(String string) {
        return triggerTimeList.contains(string);
    }

    public UserSqlServer getOwner() {
        return this.owner;
    }

    public void setOwner(UserSqlServer userSqlServer) {
        this.owner = userSqlServer;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    public static String[] getExecitionOrders() {
        return EXECUTION_ORDERS;
    }

    protected boolean checkExecutionOrder(String string) {
        if (executionOrderSet == null) {
            executionOrderSet = new HashSet();
            executionOrderSet.addAll(Arrays.asList(TriggerSqlServer.getExecitionOrders()));
        }
        return executionOrderSet.contains(string.toUpperCase());
    }

    public String getExecutionOrder() {
        return this.executionOrder;
    }

    public void setExecutionOrder(String string) {
        if (string != null && this.checkExecutionOrder(string)) {
            this.executionOrder = string.toUpperCase();
            this.fireDataFieldChange();
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TriggerPropertyDialogSqlServer triggerPropertyDialogSqlServer = new TriggerPropertyDialogSqlServer(this.getDesign().getAppView(), this.getStorageDesign(), this);
            triggerPropertyDialogSqlServer.show();
        }
    }

    public String getEncription() {
        return this.encription;
    }

    public void setEncription(String string) {
        if (ConstantsSqlServer.checkYesNo(string)) {
            this.encription = string;
            this.fireDataFieldChange();
        }
    }

    public String getForReplication() {
        return this.forReplication;
    }

    public void setForReplication(String string) {
        if (ConstantsSqlServer.checkYesNo(string)) {
            this.forReplication = string;
            this.fireDataFieldChange();
        }
    }

    public boolean existInsteadOfTrigger(String string) {
        TriggerSqlServer triggerSqlServer;
        if (this.view != null) {
            TriggerSqlServer triggerSqlServer2;
            Iterator iterator = ((StorageObjectCollection)this.view.getChild(1)).iterator();
            return iterator.hasNext() && (triggerSqlServer2 = (TriggerSqlServer)iterator.next()) != this && triggerSqlServer2.getActionSet().contains(string) && triggerSqlServer2.getTriggerTime().equalsIgnoreCase("INSTEAD OF");
        }
        Iterator iterator = ((StorageObjectCollection)this.table.getChild(3)).iterator();
        return iterator.hasNext() && (triggerSqlServer = (TriggerSqlServer)iterator.next()) != this && triggerSqlServer.getActionSet().contains(string) && triggerSqlServer.getTriggerTime().equalsIgnoreCase("INSTEAD OF");
    }

    public boolean existFirstTrigger(String string) {
        TriggerSqlServer triggerSqlServer;
        if (this.view != null) {
            TriggerSqlServer triggerSqlServer2;
            Iterator iterator = ((StorageObjectCollection)this.view.getChild(1)).iterator();
            return iterator.hasNext() && (triggerSqlServer2 = (TriggerSqlServer)iterator.next()) != this && triggerSqlServer2.getActionSet().contains(string) && triggerSqlServer2.getExecutionOrder().equalsIgnoreCase("FIRST");
        }
        Iterator iterator = ((StorageObjectCollection)this.table.getChild(3)).iterator();
        return iterator.hasNext() && (triggerSqlServer = (TriggerSqlServer)iterator.next()) != this && triggerSqlServer.getActionSet().contains(string) && triggerSqlServer.getExecutionOrder().equalsIgnoreCase("FIRST");
    }

    public boolean existLastTrigger(String string) {
        TriggerSqlServer triggerSqlServer;
        if (this.view != null) {
            TriggerSqlServer triggerSqlServer2;
            Iterator iterator = ((StorageObjectCollection)this.view.getChild(1)).iterator();
            return iterator.hasNext() && (triggerSqlServer2 = (TriggerSqlServer)iterator.next()) != this && triggerSqlServer2.getActionSet().contains(string) && triggerSqlServer2.getExecutionOrder().equalsIgnoreCase("LAST");
        }
        Iterator iterator = ((StorageObjectCollection)this.table.getChild(3)).iterator();
        return iterator.hasNext() && (triggerSqlServer = (TriggerSqlServer)iterator.next()) != this && triggerSqlServer.getActionSet().contains(string) && triggerSqlServer.getExecutionOrder().equalsIgnoreCase("LAST");
    }

    public SchemaSqlServer getSchema() {
        return this.schema;
    }

    public void setSchema(SchemaSqlServer schemaSqlServer) {
        this.schema = schemaSqlServer;
    }

    @Override
    public String getFullyQualifiedName() {
        if (this.getSchema() != null && !this.getSchema().isNullInstance()) {
            return new StringBuffer().append(this.getSchema().getName()).append('.').append(this.getName()).toString();
        }
        return this.getName();
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("TRIGGER_ICON", 16);
    }
}

