/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.InstanceDescriptorColumnSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PKProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TriggerSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UniqueProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.TablePropertyDialogSqlServer;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class TableProxySqlServer
extends TableProxy
implements ModelObjectSetListener,
StorageObjectListener,
PropertiesPropagator {
    private DataBaseSqlServer database;
    private UserSqlServer owner;
    private FileGroupSqlServer filegroup;
    private FileGroupSqlServer textImageFG;
    private StorageObjectCollection fkeys;
    private StorageObjectCollection pkeys;
    private StorageObjectCollection ukeys;
    private StorageObjectCollection triggers;
    private StorageObjectCollection instDescriptorCols;
    private SchemaSqlServer schema;
    private String props = "";
    private InlineList extPropsSet = null;
    private List propertyWrapperList = null;
    protected StorageObjectCollection synonyms;

    public TableProxySqlServer(Table table, StorageDesign storageDesign) {
        super(table, storageDesign);
        if (table.getTypeSubstitution() == null) {
            this.columns.removeAll();
            this.addColumnsFromSuccessor(table);
        }
        this.fkeys = new StorageObjectCollection();
        this.fkeys.setParent(this);
        this.fkeys.setName(Messages.getString("TableProxyOracle.ForeignKeys"));
        this.fkeys.setIcon(GUIConfiguration.getInstance().getIcon("FK_ICON", 16));
        this.pkeys = new StorageObjectCollection();
        this.pkeys.setParent(this);
        this.pkeys.setName(Messages.getString("TableProxyOracle.PrimaryKeys"));
        this.pkeys.setIcon(GUIConfiguration.getInstance().getIcon("PK_ICON", 16));
        this.ukeys = new StorageObjectCollection();
        this.ukeys.setParent(this);
        this.ukeys.setName(Messages.getString("TableProxyOracle.UniqueKeys"));
        this.ukeys.setIcon(GUIConfiguration.getInstance().getIcon("INDEX_FOLDER_ICON", 16));
        this.addIndProxiesFromDesign(((StorageDesignSqlServer)storageDesign).getFKProxySet());
        ((StorageDesignSqlServer)storageDesign).getFKProxySet().addSetListener(this);
        this.addIndProxiesFromDesign(((StorageDesignSqlServer)storageDesign).getPKProxySet());
        ((StorageDesignSqlServer)storageDesign).getPKProxySet().addSetListener(this);
        this.addIndProxiesFromDesign(((StorageDesignSqlServer)storageDesign).getUniqueProxySet());
        ((StorageDesignSqlServer)storageDesign).getUniqueProxySet().addSetListener(this);
        this.triggers = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getTriggerSet());
        this.triggers.setParent(this);
        this.triggers.setName(Messages.getString("TableProxyOracle.Triggers"));
        this.triggers.setClassForParent(TableProxySqlServer.class);
        this.triggers.setSetMethod("setTable");
        this.triggers.setIcon(GUIConfiguration.getInstance().getIcon("TRIGGER_FOLDER_ICON", 16));
        ((StorageDesignSqlServer)storageDesign).getTriggerSet().addSetListener(this);
        this.addTriggersFromDesign(((StorageDesignSqlServer)storageDesign).getTriggerSet());
        this.instDescriptorCols = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getInstanceDescriptorColumnSet());
        ((StorageDesignSqlServer)storageDesign).getInstanceDescriptorColumnSet().addSetListener(this);
        this.setDatabase(null);
    }

    public TableProxySqlServer(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
        Table table = (Table)this.getObject();
        if (table.getTypeSubstitution() == null) {
            this.columns.removeAll();
            this.addColumnsFromSuccessor(table);
        }
        this.fkeys = new StorageObjectCollection();
        this.fkeys.setParent(this);
        this.fkeys.setName(Messages.getString("TableProxyOracle.ForeignKeys"));
        this.fkeys.setIcon(GUIConfiguration.getInstance().getIcon("FK_ICON", 16));
        this.pkeys = new StorageObjectCollection();
        this.pkeys.setParent(this);
        this.pkeys.setName(Messages.getString("TableProxyOracle.PrimaryKeys"));
        this.pkeys.setIcon(GUIConfiguration.getInstance().getIcon("PK_ICON", 16));
        this.ukeys = new StorageObjectCollection();
        this.ukeys.setParent(this);
        this.ukeys.setName(Messages.getString("TableProxyOracle.UniqueKeys"));
        this.ukeys.setIcon(GUIConfiguration.getInstance().getIcon("INDEX_FOLDER_ICON", 16));
        this.addIndProxiesFromDesign(((StorageDesignSqlServer)storageDesign).getFKProxySet());
        ((StorageDesignSqlServer)storageDesign).getFKProxySet().addSetListener(this);
        this.addIndProxiesFromDesign(((StorageDesignSqlServer)storageDesign).getPKProxySet());
        ((StorageDesignSqlServer)storageDesign).getPKProxySet().addSetListener(this);
        this.addIndProxiesFromDesign(((StorageDesignSqlServer)storageDesign).getUniqueProxySet());
        ((StorageDesignSqlServer)storageDesign).getUniqueProxySet().addSetListener(this);
        this.triggers = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getTriggerSet());
        this.triggers.setParent(this);
        this.triggers.setName(Messages.getString("TableProxyOracle.Triggers"));
        this.triggers.setClassForParent(TableProxySqlServer.class);
        this.triggers.setSetMethod("setTable");
        this.triggers.setIcon(GUIConfiguration.getInstance().getIcon("TRIGGER_FOLDER_ICON", 16));
        ((StorageDesignSqlServer)storageDesign).getTriggerSet().addSetListener(this);
        this.addTriggersFromDesign(((StorageDesignSqlServer)storageDesign).getTriggerSet());
        this.instDescriptorCols = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getInstanceDescriptorColumnSet());
        ((StorageDesignSqlServer)storageDesign).getInstanceDescriptorColumnSet().addSetListener(this);
        this.setDatabase(null);
    }

    private void addColumnsFromSuccessor(Table table) {
        for (Column column : table.getAllNestedElements()) {
            ColumnProxy columnProxy;
            if (!column.isAtomic() || (columnProxy = (ColumnProxy)this.getStorageDesign().getProxy(column)) == null) continue;
            columnProxy.setParent(this.columns);
            this.columns.add(columnProxy);
            columnProxy.setName(column.getName());
        }
    }

    public boolean existClusteredIndex(IndexProxy indexProxy) {
        IndexProxy[] indexProxyArray = this.getIndexProxies();
        for (int i = 0; i < indexProxyArray.length; ++i) {
            if (indexProxyArray[i] == null || indexProxyArray[i] == indexProxy || !indexProxyArray[i].isClustered()) continue;
            return true;
        }
        Iterator iterator = this.pkeys.iterator();
        while (iterator.hasNext()) {
            PKProxySqlServer pKProxySqlServer = (PKProxySqlServer)iterator.next();
            if (pKProxySqlServer == indexProxy || !pKProxySqlServer.isClustered()) continue;
            return true;
        }
        iterator = this.ukeys.iterator();
        while (iterator.hasNext()) {
            UniqueProxySqlServer uniqueProxySqlServer = (UniqueProxySqlServer)iterator.next();
            if (uniqueProxySqlServer == indexProxy || !uniqueProxySqlServer.isClustered()) continue;
            return true;
        }
        return false;
    }

    public int getClusteredIndexCount() {
        int n = 0;
        IndexProxy[] indexProxyArray = this.getIndexProxies();
        for (int i = 0; i < indexProxyArray.length; ++i) {
            if (indexProxyArray[i] == null || !indexProxyArray[i].isClustered()) continue;
            ++n;
        }
        Iterator iterator = this.pkeys.iterator();
        while (iterator.hasNext()) {
            PKProxySqlServer pKProxySqlServer = (PKProxySqlServer)iterator.next();
            if (!pKProxySqlServer.isClustered()) continue;
            ++n;
        }
        iterator = this.ukeys.iterator();
        while (iterator.hasNext()) {
            UniqueProxySqlServer uniqueProxySqlServer = (UniqueProxySqlServer)iterator.next();
            if (!uniqueProxySqlServer.isClustered()) continue;
            ++n;
        }
        return n;
    }

    public boolean existRowGuidColUniqueID(ColumnProxySqlServer columnProxySqlServer) {
        ColumnProxy[] columnProxyArray = this.getColumnProxies();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            if (columnProxyArray[i] == null || columnProxyArray[i] == columnProxySqlServer || !((ColumnProxySqlServer)columnProxyArray[i]).getDataTypeName().equalsIgnoreCase("uniqueidentifier") || !((ColumnProxySqlServer)columnProxyArray[i]).getRowGuidCol().equalsIgnoreCase("YES")) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getNumberOfChildren() {
        return super.getNumberOfChildren() + 4;
    }

    @Override
    public ModelObject getChild(int n) {
        if (n == this.getNumberOfChildren() - 1) {
            return this.pkeys;
        }
        if (n == this.getNumberOfChildren() - 2) {
            return this.fkeys;
        }
        if (n == this.getNumberOfChildren() - 3) {
            return this.ukeys;
        }
        if (n == this.getNumberOfChildren() - 4) {
            return this.triggers;
        }
        return super.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.pkeys) {
            return this.getNumberOfChildren() - 1;
        }
        if (modelObject == this.fkeys) {
            return this.getNumberOfChildren() - 2;
        }
        if (modelObject == this.ukeys) {
            return this.getNumberOfChildren() - 3;
        }
        if (modelObject == this.triggers) {
            return this.getNumberOfChildren() - 4;
        }
        return super.getIndexForChild(modelObject);
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.pkeys) {
            return this.getNumberOfChildren() - 1;
        }
        if (object == this.fkeys) {
            return this.getNumberOfChildren() - 2;
        }
        if (object == this.ukeys) {
            return this.getNumberOfChildren() - 3;
        }
        if (object == this.triggers) {
            return this.getNumberOfChildren() - 4;
        }
        return super.getIndexForChild(object);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TablePropertyDialogSqlServer tablePropertyDialogSqlServer = new TablePropertyDialogSqlServer(this.getDesign().getAppView(), this.getStorageDesign(), this);
            tablePropertyDialogSqlServer.show();
        }
    }

    @Override
    public void changed(RelationalObjectProxySet relationalObjectProxySet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof ColumnProxy) {
                ColumnProxy columnProxy = (ColumnProxy)modelObjectSetEvent.getAffected();
                if (this.getObject() == ((Column)columnProxy.getObject()).getContainerWithKeyObject()) {
                    this.columns.add(modelObjectSetEvent.getAffected());
                }
            } else if (modelObjectSetEvent.getAffected() instanceof IndexProxy) {
                IndexProxy indexProxy = (IndexProxy)modelObjectSetEvent.getAffected();
                Index index = (Index)indexProxy.getObject();
                if (this.getObject() == index.getContainerWithKeyObject()) {
                    if (index.isFK() && !this.fkeys.contains(indexProxy)) {
                        indexProxy.setParent(this.fkeys);
                        this.fkeys.add(indexProxy);
                    } else if (index.isPK() && !this.pkeys.contains(indexProxy)) {
                        indexProxy.setParent(this.pkeys);
                        this.pkeys.add(indexProxy);
                    } else if (index.isUnique() && !this.ukeys.contains(indexProxy)) {
                        indexProxy.setParent(this.ukeys);
                        this.ukeys.add(indexProxy);
                    } else if (!this.indexes.contains(indexProxy)) {
                        indexProxy.setParent(this.indexes);
                        this.indexes.add(modelObjectSetEvent.getAffected());
                    }
                } else if (modelObjectSetEvent.getAffected() instanceof TriggerSqlServer) {
                    TriggerSqlServer triggerSqlServer = (TriggerSqlServer)modelObjectSetEvent.getAffected();
                    triggerSqlServer.addObjectListener(this);
                    if (triggerSqlServer.getTable() == this) {
                        triggerSqlServer.setParent(this.triggers);
                        this.triggers.add(triggerSqlServer);
                    } else {
                        this.triggers.remove(triggerSqlServer);
                    }
                }
            }
        } else if (modelObjectSetEvent.isType(0)) {
            if (modelObjectSetEvent.getAffected() instanceof ColumnProxy) {
                this.columns.remove(((ColumnProxy)modelObjectSetEvent.getAffected()).getObject().getObjectID());
            } else if (modelObjectSetEvent.getAffected() instanceof IndexProxy) {
                IndexProxy indexProxy = (IndexProxy)modelObjectSetEvent.getAffected();
                if (this.indexes.contains(indexProxy)) {
                    this.indexes.remove(modelObjectSetEvent.getAffected());
                }
                if (this.pkeys.contains(indexProxy)) {
                    this.pkeys.remove(modelObjectSetEvent.getAffected());
                }
                if (this.ukeys.contains(indexProxy)) {
                    this.ukeys.remove(modelObjectSetEvent.getAffected());
                }
                if (this.fkeys.contains(indexProxy)) {
                    this.fkeys.remove(modelObjectSetEvent.getAffected());
                }
            } else if (modelObjectSetEvent.getAffected() instanceof TriggerSqlServer) {
                TriggerSqlServer triggerSqlServer = (TriggerSqlServer)modelObjectSetEvent.getAffected();
                this.triggers.remove(triggerSqlServer);
                triggerSqlServer.removeObjectListener(this);
            }
        }
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof TriggerSqlServer) {
            TriggerSqlServer triggerSqlServer = (TriggerSqlServer)objectChangeEvent.getAffected();
            if (triggerSqlServer.getTable() == this) {
                triggerSqlServer.setParent(this.triggers);
                this.triggers.add(triggerSqlServer);
            } else {
                this.triggers.remove(triggerSqlServer);
            }
        } else if (objectChangeEvent.getAffected() instanceof InstanceDescriptorColumnSqlServer) {
            InstanceDescriptorColumnSqlServer instanceDescriptorColumnSqlServer = (InstanceDescriptorColumnSqlServer)objectChangeEvent.getAffected();
            if (instanceDescriptorColumnSqlServer.getTable() == this) {
                instanceDescriptorColumnSqlServer.setParent(this.instDescriptorCols);
                this.instDescriptorCols.add(instanceDescriptorColumnSqlServer);
            } else {
                this.instDescriptorCols.remove(instanceDescriptorColumnSqlServer);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof TriggerSqlServer) {
                TriggerSqlServer triggerSqlServer = (TriggerSqlServer)modelObjectSetEvent.getAffected();
                triggerSqlServer.addObjectListener(this);
                if (triggerSqlServer.getTable() == this) {
                    triggerSqlServer.setParent(this.triggers);
                    this.triggers.add(triggerSqlServer);
                } else {
                    this.triggers.remove(triggerSqlServer);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof InstanceDescriptorColumnSqlServer) {
                InstanceDescriptorColumnSqlServer instanceDescriptorColumnSqlServer = (InstanceDescriptorColumnSqlServer)modelObjectSetEvent.getAffected();
                instanceDescriptorColumnSqlServer.addObjectListener(this);
                if (instanceDescriptorColumnSqlServer.getTable() == this) {
                    instanceDescriptorColumnSqlServer.setParent(this.instDescriptorCols);
                    this.instDescriptorCols.add(instanceDescriptorColumnSqlServer);
                } else {
                    this.instDescriptorCols.remove(instanceDescriptorColumnSqlServer);
                }
            }
        } else if (modelObjectSetEvent.isType(0)) {
            if (modelObjectSetEvent.getAffected() instanceof TriggerSqlServer) {
                TriggerSqlServer triggerSqlServer = (TriggerSqlServer)modelObjectSetEvent.getAffected();
                this.triggers.remove(triggerSqlServer);
                triggerSqlServer.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof InstanceDescriptorColumnSqlServer) {
                InstanceDescriptorColumnSqlServer instanceDescriptorColumnSqlServer = (InstanceDescriptorColumnSqlServer)modelObjectSetEvent.getAffected();
                this.instDescriptorCols.remove(instanceDescriptorColumnSqlServer);
                instanceDescriptorColumnSqlServer.removeObjectListener(this);
            }
        }
    }

    private void addIndProxiesFromDesign(RelationalObjectProxySet relationalObjectProxySet) {
        Iterator iterator = relationalObjectProxySet.iterator();
        while (iterator.hasNext()) {
            IndexProxy indexProxy = (IndexProxy)iterator.next();
            Index index = (Index)indexProxy.getObject();
            if (this.getObject() != index.getContainerWithKeyObject()) continue;
            if (index.isFK()) {
                indexProxy.setParent(this.fkeys);
                this.fkeys.add(indexProxy);
                continue;
            }
            if (index.isPK()) {
                indexProxy.setParent(this.pkeys);
                this.pkeys.add(indexProxy);
                continue;
            }
            if (!index.isUnique()) continue;
            indexProxy.setParent(this.ukeys);
            this.ukeys.add(indexProxy);
        }
    }

    public DataBaseSqlServer getDatabase() {
        return this.database;
    }

    public void setDatabase(DataBaseSqlServer dataBaseSqlServer) {
        this.database = dataBaseSqlServer == null && ((StorageDesignSqlServer)this.getStorageDesign()).getDataBaseSet().hasNullInstance() ? (DataBaseSqlServer)((StorageDesignSqlServer)this.getStorageDesign()).getDataBaseSet().getNullInstance() : dataBaseSqlServer;
        this.fireDataFieldChange();
    }

    public FileGroupSqlServer getFilegroup() {
        return this.filegroup;
    }

    public void setFilegroup(FileGroupSqlServer fileGroupSqlServer) {
        this.filegroup = fileGroupSqlServer;
        this.fireDataFieldChange();
    }

    public UserSqlServer getUser() {
        return this.owner;
    }

    public void setUser(UserSqlServer userSqlServer) {
        this.owner = userSqlServer;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    public FileGroupSqlServer getTextImageFG() {
        return this.textImageFG;
    }

    public void setTextImageFG(FileGroupSqlServer fileGroupSqlServer) {
        this.textImageFG = fileGroupSqlServer;
        this.fireDataFieldChange();
    }

    protected void addTriggersFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            TriggerSqlServer triggerSqlServer = (TriggerSqlServer)iterator.next();
            triggerSqlServer.addObjectListener(this);
            if (triggerSqlServer.getTable() == this) {
                triggerSqlServer.setParent(this.triggers);
                this.triggers.add(triggerSqlServer);
                continue;
            }
            this.triggers.remove(triggerSqlServer);
        }
    }

    public InlineList getExtPropsSet() {
        if (this.extPropsSet == null) {
            this.extPropsSet = new InlineList();
        }
        return this.extPropsSet;
    }

    public String getProps() {
        return this.props;
    }

    public void setProps(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateExtPropertiesSet(string);
        } else {
            this.addExtProperty(string);
        }
        this.props = this.getExtPropsSet().toString();
        this.fireDataFieldChange();
    }

    private void addExtProperty(String string) {
        this.getExtPropsSet().add(string);
    }

    protected void recreateExtPropertiesSet(String string) {
        this.getExtPropsSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.extPropsSet = new InlineList();
        while (stringTokenizer.hasMoreTokens()) {
            this.getExtPropsSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public StorageObjectCollection getFkeys() {
        return this.fkeys;
    }

    public void setFkeys(StorageObjectCollection storageObjectCollection) {
        this.fkeys = storageObjectCollection;
    }

    public StorageObjectCollection getPkeys() {
        return this.pkeys;
    }

    public void setPkeys(StorageObjectCollection storageObjectCollection) {
        this.pkeys = storageObjectCollection;
    }

    @Override
    public StorageObjectCollection getTriggers() {
        return this.triggers;
    }

    public void setTriggers(StorageObjectCollection storageObjectCollection) {
        this.triggers = storageObjectCollection;
    }

    public StorageObjectCollection getUkeys() {
        return this.ukeys;
    }

    public void setUkeys(StorageObjectCollection storageObjectCollection) {
        this.ukeys = storageObjectCollection;
    }

    @Override
    public IndexProxy[] getIndexProxies() {
        KeyObject[] keyObjectArray = ((Table)this.getObject()).getKeys();
        ArrayList<IndexProxy> arrayList = new ArrayList<IndexProxy>();
        for (int i = 0; i < keyObjectArray.length; ++i) {
            IndexProxy indexProxy = null;
            if (!(keyObjectArray[i].isPK() || keyObjectArray[i].isUnique() || keyObjectArray[i].isFK())) {
                indexProxy = (IndexProxy)this.getStorageDesign().getIndexProxySet().getProxy(keyObjectArray[i].getObjectID());
            }
            if (indexProxy == null) continue;
            arrayList.add(indexProxy);
        }
        return arrayList.toArray(new IndexProxy[0]);
    }

    @Override
    public StorageObject getUserSchema() {
        return this.getUser();
    }

    public StorageObjectCollection getInstanceDescriptorCols() {
        return this.instDescriptorCols;
    }

    public InstanceDescriptorColumnSqlServer createInstanceDescriptorCol() {
        if (this.instDescriptorCols.getStorageObjectSet() != null) {
            return (InstanceDescriptorColumnSqlServer)this.instDescriptorCols.createElement(null);
        }
        return null;
    }

    public SchemaSqlServer getSchema() {
        return this.schema;
    }

    public void setSchema(SchemaSqlServer schemaSqlServer) {
        this.schema = schemaSqlServer;
    }

    public void clear() {
        this.getExtPropsSet().removeAllElements();
        this.props = "";
    }

    @Override
    public void remove() {
        Object[] objectArray = this.triggers.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            TriggerSqlServer triggerSqlServer = (TriggerSqlServer)objectArray[i];
            triggerSqlServer.remove();
            triggerSqlServer.setTable(null);
            this.triggers.remove(triggerSqlServer);
        }
        super.remove();
    }

    @Override
    public int getMaxNameLength() {
        return 128;
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper("Database", this, "getDatabase", "setDatabase", DataBaseSqlServer.class));
            this.propertyWrapperList.add(new PropertyWrapper("Owner", this, "getUser", "setUser", UserSqlServer.class));
            this.propertyWrapperList.add(new PropertyWrapper("Filegroup", this, "getFilegroup", "setFilegroup", FileGroupSqlServer.class));
            this.propertyWrapperList.add(new PropertyWrapper("TEXTIMAGE group", this, "getTextImageFG", "setTextImageFG", FileGroupSqlServer.class));
        }
        return this.propertyWrapperList;
    }

    @Override
    public boolean shouldBeDroppedIndirectly() {
        if (Design.USE_DROP_DEPENDENCY) {
            return this.getDatabase().isDropEnabled() || this.getDatabase().shouldBeDroppedIndirectly();
        }
        return false;
    }

    @Override
    public void clearMergableStructure(Map map) {
        if (map != null) {
            ArrayList arrayList = new ArrayList();
            this.triggers.addAllElementsTo(arrayList);
            if (this.synonyms != null) {
                this.synonyms.addAllElementsTo(arrayList);
            }
            for (StorageObject storageObject : arrayList) {
                if (map.get(storageObject.getObjectID()) != null) continue;
                storageObject.remove(true);
            }
        }
    }

    @Override
    public String getLongName() {
        if (this.getUser() != null) {
            return new StringBuffer(this.getUser().getLongName()).append('.').append(this.getName()).toString();
        }
        ContainerObject containerObject = (ContainerObject)this.getObject();
        SchemaObject schemaObject = containerObject.getSchemaObject();
        if (schemaObject != null) {
            StorageObject storageObject = ((StorageDesignSqlServer)this.getStorageDesign()).getUserSet().getBySchemaObject(schemaObject);
            if (storageObject != null) {
                return new StringBuffer(storageObject.getLongName()).append('.').append(this.getName()).toString();
            }
            if (!this.getStorageDesign().isOpen()) {
                return new StringBuffer(schemaObject.getLongName()).append('.').append(this.getName()).toString();
            }
        }
        return super.getLongName();
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

