/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.sqlserver.AbstractStorageObjectSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PermissionsSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.RolePropertyDialogSqlServer;
import oracle.dbtools.crest.util.string.Crypt;

public class RoleSqlServer
extends AbstractStorageObjectSqlServer {
    private DataBaseSqlServer database;
    private boolean isApplicationRole = false;
    private String password;
    private String users = "";
    private UserSet userSet = null;
    private UserSqlServer owner;
    private static final String[] PRIVILEGES = new String[]{"ALL", "CREATE DEFAULT", "CREATE FUNCTION", "CREATE PROCEDURE", "CREATE RULE", "CREATE TABLE", "CREATE VIEW", "BACKUP DATABASE", "BACKUP LOG"};
    public static final List PRIVILEGESLIST = Arrays.asList(PRIVILEGES);
    private String systemPrivileges = "";
    private InlineList systemPrivilegesSet = null;
    private static Crypt crypt = new Crypt();
    public static final String TYPE_NAME = "Role";

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            RolePropertyDialogSqlServer rolePropertyDialogSqlServer = new RolePropertyDialogSqlServer(this.getDesign().getAppView(), this.getStorageDesign(), this);
            rolePropertyDialogSqlServer.show();
        }
    }

    public boolean getIsApplicationRole() {
        return this.isApplicationRole;
    }

    public void setIsApplicationRole(boolean bl) {
        this.isApplicationRole = bl;
    }

    @Override
    public DataBaseSqlServer getDatabase() {
        return this.database;
    }

    public void setDatabase(DataBaseSqlServer dataBaseSqlServer) {
        this.database = dataBaseSqlServer;
        this.fireDataFieldChange();
    }

    public String getPassword() {
        return this.password;
    }

    public String decodePassword() {
        String string = this.getDesign().getLoadedVersion() < 3.3f ? this.password : crypt.decrypt(this.password);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public void setPassword(String string) {
        this.password = string;
        this.fireDataFieldChange();
    }

    public void encodePassword(String string) {
        this.password = crypt.encrypt(string);
    }

    public UserSqlServer getOwner() {
        return this.owner;
    }

    public void setOwner(UserSqlServer userSqlServer) {
        this.owner = userSqlServer;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    private void addUser(String string) {
        String string2 = string.substring(string.lastIndexOf(46) + 1, string.length());
        if (!this.getUserSet().contains(string2)) {
            this.getUserSet().add(string2);
        }
    }

    public void recreateUserSet(String string) {
        this.getUserSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getUserSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public void setUsers(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateUserSet(string);
        } else {
            this.addUser(string);
        }
        this.users = this.getUserSet().toString();
        this.fireDataFieldChange();
    }

    public String getUsers() {
        return this.users;
    }

    public UserSet getUserSet() {
        if (this.userSet == null) {
            this.userSet = new UserSet();
        }
        return this.userSet;
    }

    public void clear() {
        this.getUserSet().removeAllElements();
        this.users = "";
        this.getPrivilegesSet().removeAllElements();
        this.systemPrivileges = "";
    }

    public static List getPrivilegesValues() {
        Collections.sort(PRIVILEGESLIST, new StringComparator());
        return PRIVILEGESLIST;
    }

    private void addPrivilege(String string) {
        if (!this.getPrivilegesSet().contains(string)) {
            this.getPrivilegesSet().add(string);
        }
    }

    public InlineList getPrivilegesSet() {
        if (this.systemPrivilegesSet == null) {
            this.systemPrivilegesSet = new InlineList();
        }
        return this.systemPrivilegesSet;
    }

    public String getSystemPrivileges() {
        return this.systemPrivileges;
    }

    public void recreateSystemPrivilegesSet(String string) {
        this.getPrivilegesSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.systemPrivilegesSet = new InlineList();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (!this.checkPrivileges(string2)) continue;
            this.getPrivilegesSet().add(string2);
        }
    }

    protected boolean checkPrivileges(String string) {
        return PRIVILEGESLIST.contains(string);
    }

    public void setSystemPrivileges(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateSystemPrivilegesSet(string);
        } else if (this.checkPrivileges(string)) {
            this.addPrivilege(string);
        }
        this.systemPrivileges = this.getPrivilegesSet().toString();
        this.fireDataFieldChange();
    }

    public List getPermissions() {
        ArrayList<PermissionsSqlServer> arrayList = new ArrayList<PermissionsSqlServer>();
        Iterator iterator = ((StorageDesignSqlServer)this.getStorageDesign()).getPermissionsSet().iterator();
        while (iterator.hasNext()) {
            PermissionsSqlServer permissionsSqlServer = (PermissionsSqlServer)iterator.next();
            if (permissionsSqlServer.getRole() != this || permissionsSqlServer.getTable() == null && permissionsSqlServer.getView() == null) continue;
            arrayList.add(permissionsSqlServer);
        }
        return arrayList;
    }

    public PermissionsSqlServer createPermission() {
        PermissionsSqlServer permissionsSqlServer = ((StorageDesignSqlServer)this.getStorageDesign()).getPermissionsSet().createPermissions();
        permissionsSqlServer.setRole(this);
        return permissionsSqlServer;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("ROLE_ICON", 16);
    }

    static class StringComparator
    implements Comparator {
        StringComparator() {
        }

        public int compare(Object object, Object object2) {
            return String.valueOf(object).compareTo(String.valueOf(object2));
        }
    }

    public class UserSet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

