/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.PKPropertyDialogSqlServer;

public class PKProxySqlServer
extends IndexProxy {
    private FileGroupSqlServer filegroup;
    private int fillFactor = 0;
    public static final String TYPE_NAME = "PKey";

    public PKProxySqlServer(Index index, StorageDesign storageDesign) {
        super(index, storageDesign);
        this.setClustered(true);
    }

    public PKProxySqlServer(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
        this.setClustered(true);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return "PrimaryKey";
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            PKPropertyDialogSqlServer pKPropertyDialogSqlServer = new PKPropertyDialogSqlServer(this.getDesign().getAppView(), this.getStorageDesign(), this);
            pKPropertyDialogSqlServer.show();
        }
    }

    public String getTableName() {
        return this.getTable().getName();
    }

    public String getTableUser() {
        if (((TableProxySqlServer)this.getTableProxy()).getUser() != null) {
            return ((TableProxySqlServer)this.getTableProxy()).getUser().getName();
        }
        return "";
    }

    public FileGroupSqlServer getFilegroup() {
        return this.filegroup;
    }

    public void setFilegroup(FileGroupSqlServer fileGroupSqlServer) {
        this.filegroup = fileGroupSqlServer;
        this.fireDataFieldChange();
    }

    public int getFillFactor() {
        return this.fillFactor;
    }

    public void setFillFactor(int n) {
        if (n >= 0 && n <= 100) {
            this.fillFactor = n;
        }
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        super.changed(designObject, objectChangeEvent);
        if (objectChangeEvent.isType(ObjectChangeEvent.KEY_CHANGED_NO_PK)) {
            ((StorageDesignSqlServer)this.getStorageDesign()).getPKProxySet().remove(this);
            if (!this.isUniqueConstraint()) {
                this.getStorageDesign().getIndexProxySet().add(designObject);
            }
            this.fireChangeNoDirty(objectChangeEvent);
        } else if (objectChangeEvent.isType(ObjectChangeEvent.KEY_CHANGED_TO_UNIQUE)) {
            ((StorageDesignSqlServer)this.getStorageDesign()).getPKProxySet().remove(this);
            ((StorageDesignSqlServer)this.getStorageDesign()).getUniqueProxySet().add(designObject);
            this.fireChangeNoDirty(objectChangeEvent);
        }
    }

    public boolean isUniqueConstraint() {
        return this.getIndex().getIndexState().equalsIgnoreCase("Unique Constraint");
    }

    @Override
    public int getMaxNameLength() {
        return 128;
    }
}

