/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.Iterator;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxySet;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.PKProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;

public class PKProxySetSqlServer
extends IndexProxySet {
    public PKProxySetSqlServer(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    protected RelationalObjectProxy createProxy(DesignObject designObject) {
        return new PKProxySqlServer((Index)designObject, this.getStorageDesign());
    }

    @Override
    protected RelationalObjectProxy createProxy(Design design, String string, String string2) {
        return new PKProxySqlServer(design, string, string2, this.getStorageDesign());
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        Index index;
        if (modelObjectSetEvent.isAdded()) {
            Index index2 = (Index)modelObjectSetEvent.getAffected();
            if (index2.isPK()) {
                this.add(index2);
                this.fireUpdate();
            }
        } else if (modelObjectSetEvent.isRemoved() && this.containsId((index = (Index)modelObjectSetEvent.getAffected()).getObjectID())) {
            this.remove((Index)modelObjectSetEvent.getAffected());
            this.fireUpdate();
        }
    }

    @Override
    protected void add(Index[] indexArray) {
        for (int i = 0; i < indexArray.length; ++i) {
            Index index = indexArray[i];
            if (!index.isPK()) continue;
            this.add(index);
        }
    }

    @Override
    public void add(DesignObject designObject) {
        String string = designObject.getObjectID();
        if (this.containsId(string)) {
            if (!this.getProxy(string).isLoaded()) {
                this.getProxy(string).loadDesignObject();
            }
        } else if (designObject instanceof KeyObject && ((KeyObject)designObject).isPK()) {
            RelationalObjectProxy relationalObjectProxy = this.createProxy(designObject);
            Iterator iterator = this.iterator();
            IndexProxy indexProxy = null;
            while (iterator.hasNext() && ((indexProxy = (IndexProxy)iterator.next()).equals(relationalObjectProxy) || !indexProxy.getTable().equals(((IndexProxy)relationalObjectProxy).getTable()))) {
                indexProxy = null;
            }
            try {
                if (indexProxy != null) {
                    this.remove(indexProxy);
                }
                this.add(relationalObjectProxy);
            }
            catch (IllegalStateException illegalStateException) {
                System.out.println("Error in PKProxySetSqlServer.add");
            }
        }
    }

    public boolean hasDublicateNames() {
        for (int i = 0; i < this.elements.size(); ++i) {
            PKProxySqlServer pKProxySqlServer = (PKProxySqlServer)this.elements.get(i);
            for (int j = i + 1; j < this.elements.size(); ++j) {
                PKProxySqlServer pKProxySqlServer2 = (PKProxySqlServer)this.elements.get(j);
                if (!pKProxySqlServer.getName().equalsIgnoreCase(pKProxySqlServer2.getName()) || ((TableProxySqlServer)pKProxySqlServer.getTableProxy()).getDatabase() != ((TableProxySqlServer)pKProxySqlServer2.getTableProxy()).getDatabase()) continue;
                return true;
            }
        }
        return false;
    }
}

