/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.DataTypeObject;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.storage.sqlserver.AbstractStorageObjectSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;

public class InstanceDescriptorColumnSqlServer
extends AbstractStorageObjectSqlServer
implements DataTypeObject {
    private TableProxySqlServer table;
    private String typeId;
    private boolean isReference;
    private String size;
    private int precision;
    private int scale;
    public static final short LOGICAL_TYPE = 0;
    public static final short DISTINCT_TYPE = 1;
    public static final short STRUCTURED_TYPE = 2;
    private short use = 0;
    public static final String DEFAULT_NAME = "InstanceDescriptorCol";
    public static final String TYPE_NAME = "InstanceDescriptorCol";

    @Override
    public void showPropertyDialog() {
    }

    @Override
    public String getObjectTypeName() {
        return "InstanceDescriptorCol";
    }

    @Override
    public String getIDPrefix() {
        return "DescrCol";
    }

    @Override
    public boolean isReference() {
        return this.isReference;
    }

    @Override
    public void setReference(boolean bl) {
        this.isReference = bl;
        this.fireDataFieldChange();
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public void setPrecision(int n) {
        this.precision = n;
        this.fireDataFieldChange();
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public void setScale(int n) {
        this.scale = n;
        this.fireDataFieldChange();
    }

    @Override
    public String getSize() {
        return this.size;
    }

    @Override
    public void setSize(String string) {
        this.size = string;
        this.fireDataFieldChange();
    }

    public short getUse() {
        return this.use;
    }

    public void setUse(short s) {
        this.use = s;
        this.fireDataFieldChange();
    }

    public String getTypeId() {
        return this.typeId;
    }

    public void setTypeId(String string) {
        this.typeId = string;
        this.fireDataFieldChange();
    }

    @Override
    public DesignObject getType() {
        if (this.typeId == null) {
            return this.getDesign().getLogicalDatatypeSet().getDefaultType();
        }
        if (this.getDesign().getDesignObject(this.typeId) == null) {
            return this.getDesign().getLogicalDatatypeSet().getDefaultType();
        }
        return this.getDesign().getDesignObject(this.typeId);
    }

    @Override
    public void setType(DesignObject designObject) {
        this.typeId = designObject == null ? null : designObject.getObjectID();
        this.fireDataFieldChange();
    }

    @Override
    public String getDataType() {
        return this.formatDataType();
    }

    public String formatDataType() {
        if (this.getType() != null) {
            Object object;
            String string = "";
            int n = 0;
            int n2 = 0;
            String string2 = "NONE";
            if (this.getType() instanceof LogicalDatatype) {
                string = this.size;
                n = this.precision;
                n2 = this.scale;
                string2 = this.getType().getName();
            } else if (this.getType() instanceof DistinctType) {
                object = (DistinctType)this.getType();
                if (((DistinctType)object).getLogicalDataType() != null) {
                    string = ((DistinctType)object).getSize();
                    n = ((DistinctType)object).getPrecision();
                    n2 = ((DistinctType)object).getScale();
                    string2 = ((DistinctType)object).getLogicalDataType().getName();
                }
            } else if (this.getType() instanceof StructuredType) {
                string2 = this.isReference ? "REF " + this.getType().getName() : this.getType().getName();
            }
            object = new StringBuffer(string2);
            boolean bl = false;
            boolean bl2 = false;
            if (string != null && !string.equals("") || n > 0 || n2 > 0) {
                bl = true;
            }
            if (bl) {
                ((StringBuffer)object).append('(');
            }
            if (string != null && !string.equals("")) {
                ((StringBuffer)object).append(string);
                bl2 = true;
            }
            if (n > 0) {
                if (bl2) {
                    ((StringBuffer)object).append(", ");
                }
                ((StringBuffer)object).append(n);
                bl2 = true;
            }
            if (n2 > 0) {
                if (bl2) {
                    ((StringBuffer)object).append(", ");
                }
                ((StringBuffer)object).append(n2);
            }
            if (bl) {
                ((StringBuffer)object).append(')');
            }
            return ((StringBuffer)object).toString();
        }
        return "NONE";
    }

    public TableProxySqlServer getTable() {
        return this.table;
    }

    public void setTable(TableProxySqlServer tableProxySqlServer) {
        this.table = tableProxySqlServer;
        this.setPAC_Element(tableProxySqlServer);
        this.fireDataFieldChange();
    }
}

