/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.sqlserver.AbstractStorageObjectSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataFileSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.FileGroupPropertyDialogSqlServer;

public class FileGroupSqlServer
extends AbstractStorageObjectSqlServer
implements ModelObjectSetListener,
StorageObjectListener {
    StorageObjectCollection datafiles;
    private static final String[] STATES = new String[]{"Read/Write", "Readonly"};
    private String state = "Read/Write";
    private static final List switchList = Arrays.asList(STATES);
    private static Set stateSet = null;
    private DataBaseSqlServer dataBase = null;
    public static final String TYPE_NAME = "FileGroup";

    public FileGroupSqlServer(StorageDesign storageDesign) {
        this.datafiles = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getDataFileSet());
        this.datafiles.setParent(this);
        this.datafiles.setName(Messages.getString("TableSpaceOracle.DataFiles"));
        this.datafiles.setSetMethod("setFileGroup");
        this.datafiles.setClassForParent(FileGroupSqlServer.class);
        this.datafiles.setIcon(GUIConfiguration.getInstance().getIcon("DATAFILE_ICON", 16));
        ((StorageDesignSqlServer)storageDesign).getDataFileSet().addSetListener(this);
        this.addDataFilesFromDesign(((StorageDesignSqlServer)storageDesign).getDataFileSet());
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            FileGroupPropertyDialogSqlServer fileGroupPropertyDialogSqlServer = new FileGroupPropertyDialogSqlServer(this.getDesign().getAppView(), this.getStorageDesign(), this);
            fileGroupPropertyDialogSqlServer.show();
        }
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "FG";
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.datafiles;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.datafiles) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.datafiles) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void clearChildren() {
        this.datafiles.removeAll();
    }

    public static List getSwitchValues() {
        return switchList;
    }

    protected boolean checkTypes(String string) {
        if (stateSet == null) {
            stateSet = new HashSet();
            stateSet.addAll(Arrays.asList(FileGroupSqlServer.getStateChoices()));
        }
        return stateSet.contains(string);
    }

    public String getState() {
        return this.state;
    }

    public void setState(String string) {
        this.state = string;
        this.fireDataFieldChange();
    }

    public static String[] getStateChoices() {
        return STATES;
    }

    public DataBaseSqlServer getDataBase() {
        return this.dataBase;
    }

    public void setDataBase(DataBaseSqlServer dataBaseSqlServer) {
        this.dataBase = dataBaseSqlServer;
        this.setPAC_Element(dataBaseSqlServer);
        this.fireDataFieldChange();
    }

    @Override
    public DataBaseSqlServer getDatabase() {
        return this.getDataBase();
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof DataFileSqlServer) {
                DataFileSqlServer dataFileSqlServer = (DataFileSqlServer)modelObjectSetEvent.getAffected();
                dataFileSqlServer.addObjectListener(this);
                if (dataFileSqlServer.getFileGroup() != null && dataFileSqlServer.getFileGroup() == this) {
                    dataFileSqlServer.setParent(this.datafiles);
                    this.datafiles.add(dataFileSqlServer);
                } else {
                    this.datafiles.remove(dataFileSqlServer);
                }
            }
        } else if (modelObjectSetEvent.isType(0) && modelObjectSetEvent.getAffected() instanceof DataFileSqlServer) {
            DataFileSqlServer dataFileSqlServer = (DataFileSqlServer)modelObjectSetEvent.getAffected();
            this.datafiles.remove(dataFileSqlServer);
            dataFileSqlServer.removeObjectListener(this);
        }
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof DataFileSqlServer) {
            DataFileSqlServer dataFileSqlServer = (DataFileSqlServer)objectChangeEvent.getAffected();
            if (dataFileSqlServer.getFileGroup() != null && dataFileSqlServer.getFileGroup() == this) {
                dataFileSqlServer.setParent(this.datafiles);
                this.datafiles.add(dataFileSqlServer);
            } else {
                this.datafiles.remove(dataFileSqlServer);
            }
        }
    }

    public void addDataFilesFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            DataFileSqlServer dataFileSqlServer = (DataFileSqlServer)iterator.next();
            if (dataFileSqlServer.getFileGroup() != null && dataFileSqlServer.getFileGroup() == this) {
                dataFileSqlServer.setParent(this.datafiles);
                this.datafiles.add(dataFileSqlServer);
                continue;
            }
            this.datafiles.remove(dataFileSqlServer);
        }
    }

    public StorageObjectCollection getDatafiles() {
        return this.datafiles;
    }

    public DataFileSqlServer createDatafile() {
        if (this.datafiles.getStorageObjectSet() != null) {
            return (DataFileSqlServer)this.datafiles.createElement(null);
        }
        return null;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("GROUP_ICON", 16);
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }

    @Override
    public void clearNoneMergableStructure() {
        this.datafiles.removeAll();
    }
}

