/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.ConstantsSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DefaultSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserDefinedTypeSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserDefinedTypeSqlServer;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.ColumnProxyPropertyDialogSqlServer;

public class ColumnProxySqlServer
extends ColumnProxy {
    private DefaultSqlServer defaultObject = null;
    private boolean asIdentity = false;
    private String identitySeed = "1";
    private int identityIncrement = 1;
    private String identityForReplication = "NO";
    private String rowGuidCol = "NO";
    private boolean computed = false;
    private boolean computedChanged = false;
    private boolean formulaChanged = false;
    private boolean asIdentityChanged = false;
    private String formula = "";
    private String collation = "";
    private String props = "";
    private InlineList extPropsSet = null;
    private boolean useDefaultObject = false;
    private String defValue = "";

    public ColumnProxySqlServer(Column column, StorageDesign storageDesign) {
        super(column, storageDesign);
    }

    public ColumnProxySqlServer(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
    }

    public String getComments() {
        Column column = this.getColumn();
        return column.getComment();
    }

    public boolean getNullsAllowed() {
        Column column = this.getColumn();
        return column.getNullsAllowed();
    }

    public int getColno() {
        Column column = this.getColumn();
        Table table = (Table)column.getContainer();
        return table.getIndexOf(column) + 1;
    }

    public boolean belongsToPK() {
        return this.getColumn().isPKElement();
    }

    public TableProxySqlServer getTableProxy() {
        Column column = this.getColumn();
        Table table = (Table)column.getContainer();
        return (TableProxySqlServer)this.getStorageDesign().getTableProxySet().getProxy(table.getObjectID());
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ColumnProxyPropertyDialogSqlServer columnProxyPropertyDialogSqlServer = new ColumnProxyPropertyDialogSqlServer(this.getDesign().getAppView(), this.getStorageDesign(), this);
            columnProxyPropertyDialogSqlServer.show();
        }
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        super.changed(designObject, objectChangeEvent);
        this.fireChangeNoDirty(objectChangeEvent);
    }

    public boolean getAsIdentity() {
        if (this.asIdentityChanged) {
            return this.asIdentity;
        }
        return this.getColumn().isIdentityColumn();
    }

    public void setAsIdentity(boolean bl) {
        this.asIdentity = bl;
    }

    public boolean isAsIdentityChanged() {
        return this.asIdentityChanged;
    }

    public void setAsIdentityChanged(boolean bl) {
        this.asIdentityChanged = bl;
    }

    public String getCollation() {
        return this.collation;
    }

    public void setCollation(String string) {
        this.collation = string == null ? "" : string;
    }

    public boolean getComputed() {
        if (this.computedChanged) {
            return this.computed;
        }
        return this.getColumn().isComputed();
    }

    public void setComputed(boolean bl) {
        this.computed = bl;
        if (bl && !this.getColumn().isComputed().booleanValue()) {
            this.computedChanged = true;
        }
    }

    public boolean isComputedChanged() {
        return this.computedChanged;
    }

    public void setComputedChanged(boolean bl) {
        this.computedChanged = bl;
    }

    public DefaultSqlServer getDefaultObject() {
        return this.defaultObject;
    }

    public void setDefaultObject(DefaultSqlServer defaultSqlServer) {
        this.defaultObject = defaultSqlServer;
    }

    public boolean getDefineDefault() {
        return this.useDefaultObject;
    }

    public void setDefineDefault(boolean bl) {
        this.useDefaultObject = bl;
    }

    public String getDefaultValue() {
        if (!this.defValue.trim().equalsIgnoreCase("")) {
            return this.defValue;
        }
        return this.getColumn().getDefaultValue() != null ? this.getColumn().getDefaultValue() : "";
    }

    public void setDefaultValue(String string) {
        this.defValue = string;
    }

    public String getFormula() {
        if (this.formulaChanged) {
            return this.formula;
        }
        return this.getColumn().getFormulaDesc();
    }

    public void setFormula(String string) {
        this.formula = string;
        if (string.length() > 0 && this.getColumn().getFormulaDesc().length() == 0) {
            this.formulaChanged = true;
        }
    }

    public boolean isFormulaChanged() {
        return this.formulaChanged;
    }

    public void setFormulaChanged(boolean bl) {
        this.formulaChanged = bl;
    }

    public String getIdentityForReplication() {
        return this.identityForReplication;
    }

    public void setIdentityForReplication(String string) {
        if (ConstantsSqlServer.checkYesNo(string)) {
            this.identityForReplication = string;
            this.fireDataFieldChange();
        }
    }

    public int getIdentityIncrement() {
        if (!this.isIncrementByChanged()) {
            return this.getColumn().getAutoIncrementIncrementBy();
        }
        return this.identityIncrement;
    }

    public void setIdentityIncrement(int n) {
        this.identityIncrement = n;
    }

    public String getIdentitySeed() {
        if (!this.isStartWithChanged()) {
            return this.getColumn().getAutoIncrementStartWith();
        }
        return this.identitySeed;
    }

    public void setIdentitySeed(String string) {
        this.identitySeed = string;
    }

    public String getRowGuidCol() {
        return this.rowGuidCol;
    }

    public void setRowGuidCol(String string) {
        if (ConstantsSqlServer.checkYesNo(string) && this.getDataTypeName().equalsIgnoreCase("uniqueIdentifier")) {
            this.rowGuidCol = string;
            this.fireDataFieldChange();
        }
    }

    public InlineList getExtPropsSet() {
        if (this.extPropsSet == null) {
            this.extPropsSet = new InlineList();
        }
        return this.extPropsSet;
    }

    public void clear() {
        this.getExtPropsSet().removeAllElements();
        this.props = "";
    }

    public String getProps() {
        return this.props;
    }

    public void setProps(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateExtPropertiesSet(string);
        } else {
            this.addExtProperty(string);
        }
        this.props = this.getExtPropsSet().toString();
        this.fireDataFieldChange();
    }

    private void addExtProperty(String string) {
        this.getExtPropsSet().add(string);
    }

    protected void recreateExtPropertiesSet(String string) {
        this.getExtPropsSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.extPropsSet = new InlineList();
        while (stringTokenizer.hasMoreTokens()) {
            this.getExtPropsSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public UserDefinedTypeSqlServer getUserDefinedType() {
        if (this.getColumn().getUse() == 0) {
            Domain domain = this.getColumn().getDomain();
            UserDefinedTypeSetSqlServer userDefinedTypeSetSqlServer = ((StorageDesignSqlServer)this.getStorageDesign()).getUserDefinedTypeSet();
            return userDefinedTypeSetSqlServer.getUserDefinedType(domain);
        }
        return null;
    }

    public String getDataTypeName() {
        Column column = this.getColumn();
        if (column.isOid() || column.isReference()) {
            return "DECIMAL";
        }
        return column.getDataType(this.getRDBMSType().toString()).getName();
    }

    @Override
    public String getDatatypeString() {
        if (this.getUserDefinedType() != null) {
            return this.getUserDefinedType().toString();
        }
        Column column = this.getColumn();
        if (column.isOid() || column.isReference()) {
            return "DECIMAL(38 , 0)";
        }
        String string = column.getDataType(this.getRDBMSType().toString()).toString();
        return string;
    }

    @Override
    public int getMaxNameLength() {
        return 128;
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

