/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v9i;

import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DataFileOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UndoTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.DataFileOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.UndoTablespacePropertyDialogOracle;

public class UndoTablespaceOraclev9i
extends UndoTablespaceOracle
implements ModelObjectSetListener,
StorageObjectListener {
    protected StorageObjectCollection dfiles;

    public UndoTablespaceOraclev9i(StorageDesign storageDesign) {
        super(storageDesign);
        this.dfiles = new StorageObjectCollection(((StorageDesignOracle)storageDesign).getDataFileSet());
        this.dfiles.setParent(this);
        this.dfiles.setName(Messages.getString("TableSpaceOracle.DataFiles"));
        this.dfiles.setSetMethod("setUndoTablespace");
        this.dfiles.setClassForParent(UndoTablespaceOracle.class);
        this.dfiles.setIcon(GUIConfiguration.getInstance().getIcon("DATAFILE_ICON", 16));
        ((StorageDesignOracle)storageDesign).getDataFileSet().addSetListener(this);
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof DataFileOraclev9i) {
            DataFileOraclev9i dataFileOraclev9i = (DataFileOraclev9i)objectChangeEvent.getAffected();
            if (dataFileOraclev9i.getUndoTablespace() == this) {
                dataFileOraclev9i.setParent(this.dfiles);
                this.dfiles.add(dataFileOraclev9i);
            } else {
                this.dfiles.remove(dataFileOraclev9i);
            }
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.dfiles;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.dfiles) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.dfiles) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof DataFileOraclev9i) {
                DataFileOraclev9i dataFileOraclev9i = (DataFileOraclev9i)modelObjectSetEvent.getAffected();
                dataFileOraclev9i.addObjectListener(this);
                if (dataFileOraclev9i.getUndoTablespace() == this) {
                    dataFileOraclev9i.setParent(this.dfiles);
                    this.dfiles.add(dataFileOraclev9i);
                } else {
                    this.dfiles.remove(dataFileOraclev9i);
                }
            }
        } else if (modelObjectSetEvent.isType(0) && modelObjectSetEvent.getAffected() instanceof DataFileOraclev9i) {
            DataFileOraclev9i dataFileOraclev9i = (DataFileOraclev9i)modelObjectSetEvent.getAffected();
            this.dfiles.remove(dataFileOraclev9i);
            dataFileOraclev9i.removeObjectListener(this);
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            UndoTablespacePropertyDialogOracle undoTablespacePropertyDialogOracle = new UndoTablespacePropertyDialogOracle(this.getDesign().getAppView(), this.getStorageDesign(), this);
            undoTablespacePropertyDialogOracle.show();
        }
    }

    @Override
    public void setOracleManagesFiles(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.oracleManagesFiles = string;
            if ("YES".equalsIgnoreCase(string) || this.fileType.equalsIgnoreCase(FILE_TYPES[1])) {
                while (this.dfiles.size() > 1) {
                    this.dfiles.remove(this.dfiles.getElement(1));
                }
                this.dfiles.setAllowedNumberOfElements(1);
            } else if (!this.fileType.equalsIgnoreCase(FILE_TYPES[1])) {
                this.dfiles.setAllowedNumberOfElements(99999);
            }
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setFileType(String string) {
        if (this.checkFileType(string)) {
            this.fileType = string;
            if (string.equalsIgnoreCase(FILE_TYPES[1]) || "YES".equalsIgnoreCase(this.oracleManagesFiles)) {
                while (this.dfiles.size() > 1) {
                    this.dfiles.remove(this.dfiles.getElement(1));
                }
                this.dfiles.setAllowedNumberOfElements(1);
            } else if ("YES".equalsIgnoreCase(this.oracleManagesFiles)) {
                this.dfiles.setAllowedNumberOfElements(99999);
            }
            this.fireDataFieldChange();
        }
    }

    public StorageObjectCollection getDfiles() {
        return this.dfiles;
    }

    public DataFileOracle createDataFile() {
        if (this.dfiles.getStorageObjectSet() != null) {
            return (DataFileOracle)this.dfiles.createElement(null);
        }
        return null;
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        UndoTablespaceOraclev9i undoTablespaceOraclev9i = null;
        StorageObject storageObject = (StorageObject)((StorageDesignOraclev9i)storageDesign).getUndoTablespaceSet().getByName(this.getName());
        if (storageObject != null) {
            if (!this.isRawObject()) {
                undoTablespaceOraclev9i = (UndoTablespaceOraclev9i)storageObject;
            }
        } else {
            undoTablespaceOraclev9i = (UndoTablespaceOraclev9i)((StorageDesignOraclev9i)storageDesign).getUndoTablespaceSet().createElement(null);
        }
        if (undoTablespaceOraclev9i != null) {
            undoTablespaceOraclev9i.setName(this.getName());
            Iterator iterator = this.getDfiles().iterator();
            while (iterator.hasNext()) {
                DataFileOraclev9i dataFileOraclev9i = (DataFileOraclev9i)iterator.next();
                DataFileOraclev9i dataFileOraclev9i2 = (DataFileOraclev9i)((StorageDesignOraclev9i)storageDesign).getDataFileSet().getByName(dataFileOraclev9i.getName());
                if (dataFileOraclev9i2 == null) {
                    DataFileOraclev9i dataFileOraclev9i3 = (DataFileOraclev9i)((StorageDesignOraclev9i)storageDesign).getDataFileSet().createDataFile();
                    dataFileOraclev9i3.setName(dataFileOraclev9i.getName());
                    dataFileOraclev9i3.setRawObject(true);
                    dataFileOraclev9i3.setUndoTablespace(undoTablespaceOraclev9i);
                    undoTablespaceOraclev9i.getDfiles().add(dataFileOraclev9i3);
                    continue;
                }
                dataFileOraclev9i2.setUndoTablespace(undoTablespaceOraclev9i);
                undoTablespaceOraclev9i.getDfiles().add(dataFileOraclev9i2);
            }
            undoTablespaceOraclev9i.setFileType(this.getFileType());
            undoTablespaceOraclev9i.setRetention(this.getRetention());
            undoTablespaceOraclev9i.setOracleManagesFiles(this.getOracleManagesFiles());
            undoTablespaceOraclev9i.setComment(this.getComment());
            undoTablespaceOraclev9i.setRawObject(false);
        }
    }

    @Override
    public void clearNoneMergableStructure() {
        this.dfiles.removeAll();
    }
}

