/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v9i;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.RoleOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.swingui.editor.storage.oracle.RolePropertyDialogOracle;

public class RoleOraclev9i
extends RoleOracle {
    private static final String[] AUTH_TYPES = new String[]{"BY_PASSWORD", "EXTERNALLY", "GLOBALLY", "USING PACKAGE"};
    private static Set authTypeSet = null;
    private String authType = AUTH_TYPES[0];
    private String schema = "";
    private String pack = "";
    protected String identifiedByPassword = "";
    protected static final String[] PRIVILEGES = new String[]{"CREATE CLUSTER", "CREATE ANY CLUSTER", "ALTER ANY CLUSTER", "DROP ANY CLUSTER", "CREATE ANY CONTEXT", "DROP ANY CONTEXT", "CREATE TABLE", "ALTER DATABASE", "ALTER SYSTEM", "AUDIT SYSTEM", "CREATE DATABASE LINK", "CREATE PUBLIC DATABASE LINK", "DROP PUBLIC DATABASE LINK", "CREATE DIMENSION", "CREATE ANY DIMENSION", "ALTER ANY DIMENSION", "DROP ANY DIMENSION", "CREATE ANY DIRECTORY", "DROP ANY DIRECTORY", "CREATE INDEXTYPE", "CREATE ANY INDEXTYPE", "DROP ANY INDEXTYPE", "EXECUTE ANY INDEXTYPE", "ALTER ANY INDEXTYPE", "CREATE ANY INDEX", "ALTER ANY INDEX", "DROP ANY INDEX", "QUERY REWRITE", "GLOBAL QUERY REWRITE", "CREATE LIBRARY", "CREATE ANY LIBRARY", "DROP LIBRARY", "DROP ANY LIBRARY", "CREATE MATERIALIZED VIEW", "CREATE ANY MATERIALIZED VIEW", "ALTER ANY MATERIALIZED VIEW", "DROP ANY MATERIALIZED VIEW", "CREATE OPERATOR", "CREATE ANY OPERATOR", "DROP ANY OPERATOR", "EXECUTE ANY OPERATOR", "CREATE ANY OUTLINE", "ALTER ANY OUTLINE", "DROP ANY OUTLINE", "CREATE PROCEDURE", "CREATE ANY PROCEDURE", "ALTER ANY PROCEDURE", "DROP ANY PROCEDURE", "EXECUTE ANY PROCEDURE", "CREATE PROFILE", "ALTER PROFILE", "DROP PROFILE", "CREATE ROLE", "ALTER ANY ROLE", "DROP ANY ROLE", "GRANT ANY ROLE", "CREATE ROLLBACK SEGMENT", "ALTER ROLLBACK SEGMENT", "DROP ROLLBACK SEGMENT", "CREATE SEQUENCE", "CREATE ANY SEQUENCE", "ALTER ANY SEQUENCE", "DROP ANY SEQUENCE", "SELECT ANY SEQUENCE", "CREATE SESSION", "ALTER RESOURCE COST", "ALTER SESSION", "RESTRICTED SESSION", "CREATE SNAPSHOT", "CREATE ANY SNAPSHOT", "ALTER ANY SNAPSHOT", "DROP ANY SNAPSHOT", "CREATE SYNONYM", "CREATE ANY SYNONYM", "CREATE PUBLIC SYNONYM", "DROP ANY SYNONYM", "DROP PUBLIC SYNONYM", "CREATE ANY TABLE", "ALTER ANY TABLE", "BACKUP ANY TABLE", "DELETE ANY TABLE", "DROP ANY TABLE", "INSERT ANY TABLE", "LOCK ANY TABLE", "UPDATE ANY TABLE", "SELECT ANY TABLE", "CREATE TABLESPACE", "ALTER TABLESPACE", "DROP TABLESPACE", "MANAGE TABLESPACE", "UNLIMITED TABLESPACE", "CREATE TRIGGER", "CREATE ANY TRIGGER", "ALTER ANY TRIGGER", "DROP ANY TRIGGER", "ADMINISTER DATABASE TRIGGER", "CREATE TYPE", "CREATE ANY TYPE", "ALTER ANY TYPE", "DROP ANY TYPE", "EXECUTE ANY TYPE", "CREATE USER", "ALTER USER", "BECOME USER", "DROP USER", "CREATE VIEW", "CREATE ANY VIEW", "DROP ANY VIEW", "ANALYZE ANY", "AUDIT ANY", "COMMENT ANY TABLE", "FORCE ANY TRANSACTION", "FORCE TRANSACTION", "GRANT ANY PRIVILEGE", "SYSDBA", "SYSOPER", "ON COMMIT REFRESH", "FLASHBACK ANY TABLE", "UNDER ANY TYPE", "UNDER ANY VIEW", "EXEMPT ACCESS POLICY", "GRANT ANY OBJECT PRIVILEGE", "RESUMABLE", "SELECT ANY DICTIONARY"};
    public static final List<String> PRIVILEGESLIST = Arrays.asList(PRIVILEGES);

    public static String[] getAuthTypes() {
        return AUTH_TYPES;
    }

    protected boolean checkAuthType(String string) {
        if (authTypeSet == null) {
            authTypeSet = new HashSet();
            authTypeSet.addAll(Arrays.asList(RoleOraclev9i.getAuthTypes()));
        }
        return authTypeSet.contains(string);
    }

    @Override
    public void setAuthType(String string) {
        if (this.checkAuthType(string)) {
            this.authType = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public String getAuthType() {
        return this.authType;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String string) {
        this.schema = string;
        this.fireDataFieldChange();
    }

    public String getPack() {
        return this.pack;
    }

    public void setPack(String string) {
        this.pack = string;
        this.fireDataFieldChange();
    }

    public String[] getPrivilegesValues() {
        Collections.sort(PRIVILEGESLIST, new RoleOracle.StringComparator());
        return (String[])PRIVILEGESLIST.toArray();
    }

    public String getIdentifiedByPassword() {
        return this.identifiedByPassword;
    }

    public void setIdentifiedByPassword(String string) {
        this.identifiedByPassword = string;
        this.fireDataFieldChange();
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            RolePropertyDialogOracle rolePropertyDialogOracle = new RolePropertyDialogOracle(this.getDesign().getAppView(), this.getStorageDesign(), this);
            rolePropertyDialogOracle.show();
        }
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        RoleOraclev9i roleOraclev9i = null;
        StorageObject storageObject = (StorageObject)((StorageDesignOracle)storageDesign).getRoleSet().getByName(this.getName());
        if (storageObject != null) {
            if (this.isRawObject()) {
                roleOraclev9i = (RoleOraclev9i)storageObject;
            }
        } else {
            roleOraclev9i = (RoleOraclev9i)((StorageDesignOracle)storageDesign).getRoleSet().createRole();
        }
        if (roleOraclev9i != null) {
            roleOraclev9i.setName(this.getName());
            roleOraclev9i.setIdentified(this.getIdentified());
            roleOraclev9i.setAuthType(this.getAuthType());
            roleOraclev9i.setPassword(this.getPassword());
            roleOraclev9i.setSchema(this.getSchema());
            roleOraclev9i.setPack(this.getPack());
            roleOraclev9i.setPublic(this.getPublic());
            roleOraclev9i.setAdminOption(this.getAdminOption());
            roleOraclev9i.setIdentifiedByPassword(this.getIdentifiedByPassword());
            roleOraclev9i.recreateSystemPrivilegesSet(this.getPrivilegesSet().toString());
            roleOraclev9i.recreateRoleSet(this.getRolesSet().toString());
            roleOraclev9i.setComment(this.getComment());
            roleOraclev9i.setRawObject(false);
        }
    }
}

